/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.solr.common.NavigableObject;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Pair;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;

public class ValidatingJsonMap
implements Map<String, Object>,
NavigableObject {
    private static final String INCLUDE = "#include";
    private static final String RESOURCE_EXTENSION = ".json";
    public static final PredicateWithErrMsg<Object> NOT_NULL = o -> {
        if (o == null) {
            return " Must not be NULL";
        }
        return null;
    };
    public static final PredicateWithErrMsg<Pair> ENUM_OF = pair -> {
        if (pair.second() instanceof Set) {
            Set set = (Set)pair.second();
            if (pair.first() instanceof Collection) {
                for (Object o : (Collection)pair.first()) {
                    if (set.contains(o)) continue;
                    return " Must be one of " + pair.second();
                }
            } else if (!set.contains(pair.first())) {
                return " Must be one of " + pair.second() + ", got " + pair.first();
            }
            return null;
        }
        return " Unknown type";
    };
    private final Map<String, Object> delegate;
    public static final ValidatingJsonMap EMPTY = new ValidatingJsonMap(Collections.EMPTY_MAP);

    public ValidatingJsonMap(Map<String, Object> delegate) {
        this.delegate = delegate;
    }

    public ValidatingJsonMap(int i) {
        this.delegate = new LinkedHashMap<String, Object>(i);
    }

    public ValidatingJsonMap() {
        this.delegate = new LinkedHashMap<String, Object>();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.delegate.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.delegate.entrySet();
    }

    public Object get(String key, PredicateWithErrMsg predicate) {
        String msg;
        Object v = this.get(key);
        if (predicate != null && (msg = predicate.test(v)) != null) {
            throw new RuntimeException("" + key + msg);
        }
        return v;
    }

    public Boolean getBool(String key, Boolean def) {
        Object v = this.get(key);
        if (v == null) {
            return def;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        try {
            return Boolean.parseBoolean(v.toString());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("value of " + key + "must be an boolean");
        }
    }

    public Integer getInt(String key, Integer def) {
        Object v = this.get(key);
        if (v == null) {
            return def;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        try {
            return Integer.parseInt(v.toString());
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("value of " + key + "must be an integer");
        }
    }

    public ValidatingJsonMap getMap(String key) {
        return this.getMap(key, null, null);
    }

    public ValidatingJsonMap getMap(String key, PredicateWithErrMsg predicate) {
        return this.getMap(key, predicate, null);
    }

    public ValidatingJsonMap getMap(String key, PredicateWithErrMsg predicate, String message) {
        String msg;
        Object v = this.get(key);
        if (v != null && !(v instanceof Map)) {
            throw new RuntimeException("" + key + " should be of type map");
        }
        if (predicate != null && (msg = predicate.test(v)) != null) {
            msg = message != null ? message : key + msg;
            throw new RuntimeException(msg);
        }
        return ValidatingJsonMap.wrap((Map)v);
    }

    public List getList(String key, PredicateWithErrMsg predicate) {
        return this.getList(key, predicate, null);
    }

    public List getList(String key, PredicateWithErrMsg predicate, Object test) {
        String msg;
        Object v = this.get(key);
        if (v != null && !(v instanceof List)) {
            throw new RuntimeException("" + key + " should be of type List");
        }
        if (predicate != null && (msg = predicate.test(test == null ? v : new Pair<Object, Object>(v, test))) != null) {
            throw new RuntimeException("" + key + msg);
        }
        return (List)v;
    }

    public Object get(String key, PredicateWithErrMsg<Pair> predicate, Object arg) {
        Object v = this.get(key);
        String test = predicate.test(new Pair<Object, Object>(v, arg));
        if (test != null) {
            throw new RuntimeException("" + key + test);
        }
        return v;
    }

    public Object get(String k, Object def) {
        Object v = this.get(k);
        if (v == null) {
            return def;
        }
        return v;
    }

    static ValidatingJsonMap wrap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        if (map instanceof ValidatingJsonMap) {
            return (ValidatingJsonMap)map;
        }
        return new ValidatingJsonMap(map);
    }

    public static ValidatingJsonMap fromJSON(InputStream is, String includeLocation) {
        return ValidatingJsonMap.fromJSON(new InputStreamReader(is, StandardCharsets.UTF_8), includeLocation);
    }

    public static ValidatingJsonMap fromJSON(Reader s, String includeLocation) {
        try {
            ValidatingJsonMap map = (ValidatingJsonMap)ValidatingJsonMap.getObjectBuilder(new JSONParser(s)).getObject();
            ValidatingJsonMap.handleIncludes(map, includeLocation, 4);
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private static void handleIncludes(ValidatingJsonMap map, String location, int maxDepth) {
        String loc = location == null ? "" : (location.endsWith("/") ? location.substring(0, location.length() - 1) : location);
        String resourceToInclude = (String)map.get(INCLUDE);
        if (resourceToInclude != null) {
            ValidatingJsonMap includedMap = ValidatingJsonMap.parse(loc + "/" + resourceToInclude + RESOURCE_EXTENSION, loc);
            map.remove(INCLUDE);
            map.putAll(includedMap);
        }
        if (maxDepth > 0) {
            map.values().stream().filter(o -> o instanceof Map).forEach((? super T m) -> ValidatingJsonMap.handleIncludes((ValidatingJsonMap)m, loc, maxDepth - 1));
        }
    }

    public static ValidatingJsonMap getDeepCopy(Map map, int maxDepth, boolean mutable) {
        if (map == null) {
            return null;
        }
        if (maxDepth < 1) {
            return ValidatingJsonMap.wrap(map);
        }
        ValidatingJsonMap copy = mutable ? new ValidatingJsonMap(map.size()) : new ValidatingJsonMap();
        for (Map.Entry o : map.entrySet()) {
            Map.Entry e = o;
            Object v = e.getValue();
            if (v instanceof Map) {
                v = ValidatingJsonMap.getDeepCopy((Map)v, maxDepth - 1, mutable);
            } else if (v instanceof Collection) {
                v = ValidatingJsonMap.getDeepCopy((Collection)v, maxDepth - 1, mutable);
            }
            copy.put((String)e.getKey(), v);
        }
        return mutable ? copy : new ValidatingJsonMap(Collections.unmodifiableMap(copy));
    }

    public static Collection getDeepCopy(Collection c, int maxDepth, boolean mutable) {
        if (c == null || maxDepth < 1) {
            return c;
        }
        AbstractCollection result = c instanceof Set ? new HashSet() : new ArrayList();
        for (Object o : c) {
            if (o instanceof Map) {
                o = ValidatingJsonMap.getDeepCopy((Map)o, maxDepth - 1, mutable);
            }
            result.add(o);
        }
        return mutable ? result : (result instanceof Set ? Collections.unmodifiableSet((Set)((Object)result)) : Collections.unmodifiableList((List)((Object)result)));
    }

    private static ObjectBuilder getObjectBuilder(JSONParser jp) throws IOException {
        return new ObjectBuilder(jp){

            @Override
            public Object newObject() throws IOException {
                return new ValidatingJsonMap();
            }
        };
    }

    public static ValidatingJsonMap parse(String resourceName, String includeLocation) {
        URL resource = ValidatingJsonMap.class.getClassLoader().getResource(resourceName);
        if (null == resource) {
            throw new RuntimeException("invalid API spec: " + resourceName);
        }
        ValidatingJsonMap map = null;
        try (InputStream is = resource.openStream();){
            try {
                map = ValidatingJsonMap.fromJSON(is, includeLocation);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in JSON : " + resourceName, (Throwable)e);
            }
        }
        catch (IOException ioe) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to read resource: " + resourceName, (Throwable)ioe);
        }
        if (map == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Empty value for " + resourceName);
        }
        return ValidatingJsonMap.getDeepCopy(map, 5, false);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof Map && this.delegate.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    public static interface PredicateWithErrMsg<T> {
        public String test(T var1);
    }
}

