/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.appservice.AppServiceCertificateOrder;
import com.microsoft.azure.management.appservice.HostingEnvironmentProfile;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.CertificateInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import java.io.File;
import java.util.List;
import org.joda.time.DateTime;

@Fluent(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
@Beta
public interface AppServiceCertificate
extends GroupableResource<AppServiceManager, CertificateInner>,
Refreshable<AppServiceCertificate> {
    public String friendlyName();

    public String subjectName();

    public List<String> hostNames();

    public byte[] pfxBlob();

    public String siteName();

    public String selfLink();

    public String issuer();

    public DateTime issueDate();

    public DateTime expirationDate();

    public String password();

    public String thumbprint();

    public Boolean valid();

    public byte[] certificateBlob();

    public String publicKeyHash();

    public HostingEnvironmentProfile hostingEnvironmentProfile();

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<AppServiceCertificate> {
        }

        public static interface WithPfxFilePassword {
            public WithCreate withPfxPassword(String var1);
        }

        public static interface WithCertificate {
            public WithPfxFilePassword withPfxFile(File var1);

            public WithPfxFilePassword withPfxByteArray(byte[] var1);

            public WithPfxFilePassword withPfxFileFromUrl(String var1);

            public WithCreate withExistingCertificateOrder(AppServiceCertificateOrder var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCertificate> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCertificate,
    DefinitionStages.WithPfxFilePassword,
    DefinitionStages.WithCreate {
    }
}

