/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac;

import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryApplication;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryObject;
import com.microsoft.azure.management.graphrbac.BuiltInRole;
import com.microsoft.azure.management.graphrbac.CertificateCredential;
import com.microsoft.azure.management.graphrbac.PasswordCredential;
import com.microsoft.azure.management.graphrbac.RoleAssignment;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalInner;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Fluent(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
public interface ServicePrincipal
extends ActiveDirectoryObject,
HasInner<ServicePrincipalInner>,
Updatable<Update> {
    public String applicationId();

    public List<String> servicePrincipalNames();

    public Map<String, PasswordCredential> passwordCredentials();

    public Map<String, CertificateCredential> certificateCredentials();

    public Set<RoleAssignment> roleAssignments();

    public static interface Update
    extends Appliable<ServicePrincipal>,
    UpdateStages.WithCredential,
    UpdateStages.WithRoleAssignment {
    }

    public static interface UpdateStages {

        public static interface WithRoleAssignment {
            public Update withNewRole(BuiltInRole var1, String var2);

            public Update withNewRoleInSubscription(BuiltInRole var1, String var2);

            public Update withNewRoleInResourceGroup(BuiltInRole var1, ResourceGroup var2);

            public Update withoutRole(RoleAssignment var1);
        }

        public static interface WithCredential {
            public CertificateCredential.UpdateDefinitionStages.Blank<Update> defineCertificateCredential(String var1);

            public PasswordCredential.UpdateDefinitionStages.Blank<Update> definePasswordCredential(String var1);

            public Update withoutCredential(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<ServicePrincipal>,
        WithCredential,
        WithRoleAssignment {
        }

        public static interface WithRoleAssignment {
            public WithCreate withNewRole(BuiltInRole var1, String var2);

            public WithCreate withNewRoleInSubscription(BuiltInRole var1, String var2);

            public WithCreate withNewRoleInResourceGroup(BuiltInRole var1, ResourceGroup var2);
        }

        public static interface WithCredential {
            public CertificateCredential.DefinitionStages.Blank<WithCreate> defineCertificateCredential(String var1);

            public PasswordCredential.DefinitionStages.Blank<WithCreate> definePasswordCredential(String var1);
        }

        public static interface WithApplication {
            public WithCreate withExistingApplication(String var1);

            public WithCreate withExistingApplication(ActiveDirectoryApplication var1);

            public WithCreate withNewApplication(Creatable<ActiveDirectoryApplication> var1);

            public WithCreate withNewApplication(String var1);
        }

        public static interface Blank
        extends WithApplication {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithCreate {
    }
}

