/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.eventhub.EventHub;
import com.microsoft.azure.management.eventhub.EventHubAuthorizationRules;
import com.microsoft.azure.management.eventhub.EventHubConsumerGroups;
import com.microsoft.azure.management.eventhub.EventHubs;
import com.microsoft.azure.management.eventhub.implementation.EventHubImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManager;
import com.microsoft.azure.management.eventhub.implementation.EventHubsInner;
import com.microsoft.azure.management.eventhub.implementation.EventhubInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.WrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class EventHubsImpl
extends WrapperImpl<EventHubsInner>
implements EventHubs {
    private final EventHubManager manager;
    private final StorageManager storageManager;

    protected EventHubsImpl(EventHubManager manager, StorageManager storageManager) {
        super((Object)((EventHubManagementClientImpl)((Object)manager.inner())).eventHubs());
        this.manager = manager;
        this.storageManager = storageManager;
    }

    public EventHubManager manager() {
        return this.manager;
    }

    public EventHubImpl define(String name) {
        return new EventHubImpl(name, this.manager, this.storageManager);
    }

    @Override
    public EventHubAuthorizationRules authorizationRules() {
        return this.manager().eventHubAuthorizationRules();
    }

    @Override
    public EventHubConsumerGroups consumerGroups() {
        return this.manager().consumerGroups();
    }

    public EventHub getById(String id) {
        return (EventHub)this.getByIdAsync(id).toBlocking().last();
    }

    public Observable<EventHub> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.getByNameAsync(resourceId.resourceGroupName(), resourceId.parent().name(), resourceId.name());
    }

    public ServiceFuture<EventHub> getByIdAsync(String id, ServiceCallback<EventHub> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    @Override
    public Observable<EventHub> getByNameAsync(String resourceGroupName, String namespaceName, String name) {
        return ((EventHubsInner)this.inner()).getAsync(resourceGroupName, namespaceName, name).map((Func1)new Func1<EventhubInner, EventHub>(){

            public EventHub call(EventhubInner inner) {
                if (inner == null) {
                    return null;
                }
                return EventHubsImpl.this.wrapModel(inner);
            }
        });
    }

    @Override
    public EventHub getByName(String resourceGroupName, String namespaceName, String name) {
        return (EventHub)this.getByNameAsync(resourceGroupName, namespaceName, name).toBlocking().last();
    }

    @Override
    public PagedList<EventHub> listByNamespace(String resourceGroupName, String namespaceName) {
        return new PagedListConverter<EventhubInner, EventHub>(){

            public Observable<EventHub> typeConvertAsync(EventhubInner inner) {
                return Observable.just((Object)EventHubsImpl.this.wrapModel(inner));
            }
        }.convert(((EventHubsInner)this.inner()).listByNamespace(resourceGroupName, namespaceName));
    }

    @Override
    public Observable<EventHub> listByNamespaceAsync(String resourceGroupName, String namespaceName) {
        return ((EventHubsInner)this.inner()).listByNamespaceAsync(resourceGroupName, namespaceName).flatMapIterable((Func1)new Func1<Page<EventhubInner>, Iterable<EventhubInner>>(){

            public Iterable<EventhubInner> call(Page<EventhubInner> page) {
                return page.items();
            }
        }).map((Func1)new Func1<EventhubInner, EventHub>(){

            public EventHub call(EventhubInner inner) {
                return EventHubsImpl.this.wrapModel(inner);
            }
        });
    }

    public void deleteById(String id) {
        this.deleteByIdAsync(id).await();
    }

    public ServiceFuture<Void> deleteByIdAsync(String id, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.deleteByIdAsync(id), callback);
    }

    public Completable deleteByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.deleteByNameAsync(resourceId.resourceGroupName(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public Completable deleteByNameAsync(String resourceGroupName, String namespaceName, String name) {
        return ((EventHubsInner)this.inner()).deleteAsync(resourceGroupName, namespaceName, name).toCompletable();
    }

    @Override
    public void deleteByName(String resourceGroupName, String namespaceName, String name) {
        this.deleteByNameAsync(resourceGroupName, namespaceName, name).await();
    }

    private EventHubImpl wrapModel(EventhubInner innerModel) {
        return new EventHubImpl(innerModel.name(), innerModel, this.manager, this.storageManager);
    }
}

