/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.storage.BlobTypes;
import com.microsoft.azure.management.storage.ManagementPolicy;
import com.microsoft.azure.management.storage.ManagementPolicyBaseBlob;
import com.microsoft.azure.management.storage.ManagementPolicyRule;
import com.microsoft.azure.management.storage.ManagementPolicySchema;
import com.microsoft.azure.management.storage.ManagementPolicySnapShot;
import com.microsoft.azure.management.storage.PolicyRule;
import com.microsoft.azure.management.storage.implementation.IdParsingUtils;
import com.microsoft.azure.management.storage.implementation.ManagementPoliciesInner;
import com.microsoft.azure.management.storage.implementation.ManagementPolicyInner;
import com.microsoft.azure.management.storage.implementation.PolicyRuleImpl;
import com.microsoft.azure.management.storage.implementation.StorageManagementClientImpl;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class ManagementPolicyImpl
extends CreatableUpdatableImpl<ManagementPolicy, ManagementPolicyInner, ManagementPolicyImpl>
implements ManagementPolicy,
ManagementPolicy.Definition,
ManagementPolicy.Update {
    private final StorageManager manager;
    private String resourceGroupName;
    private String accountName;
    private ManagementPolicySchema cpolicy;
    private ManagementPolicySchema upolicy;

    ManagementPolicyImpl(String name, StorageManager manager) {
        super(name, (Object)new ManagementPolicyInner());
        this.manager = manager;
        this.accountName = name;
        this.cpolicy = new ManagementPolicySchema();
        this.upolicy = new ManagementPolicySchema();
    }

    ManagementPolicyImpl(ManagementPolicyInner inner, StorageManager manager) {
        super(inner.name(), (Object)inner);
        this.manager = manager;
        this.accountName = inner.name();
        this.resourceGroupName = IdParsingUtils.getValueFromIdByName(inner.id(), "resourceGroups");
        this.accountName = IdParsingUtils.getValueFromIdByName(inner.id(), "storageAccounts");
        this.cpolicy = new ManagementPolicySchema();
        this.upolicy = new ManagementPolicySchema();
    }

    public StorageManager manager() {
        return this.manager;
    }

    public Observable<ManagementPolicy> createResourceAsync() {
        ManagementPoliciesInner client = ((StorageManagementClientImpl)((Object)this.manager().inner())).managementPolicies();
        return client.createOrUpdateAsync(this.resourceGroupName, this.accountName, this.cpolicy).map((Func1)new Func1<ManagementPolicyInner, ManagementPolicyInner>(){

            public ManagementPolicyInner call(ManagementPolicyInner resource) {
                ManagementPolicyImpl.this.resetCreateUpdateParameters();
                return resource;
            }
        }).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Observable<ManagementPolicy> updateResourceAsync() {
        ManagementPoliciesInner client = ((StorageManagementClientImpl)((Object)this.manager().inner())).managementPolicies();
        return client.createOrUpdateAsync(this.resourceGroupName, this.accountName, this.upolicy).map((Func1)new Func1<ManagementPolicyInner, ManagementPolicyInner>(){

            public ManagementPolicyInner call(ManagementPolicyInner resource) {
                ManagementPolicyImpl.this.resetCreateUpdateParameters();
                return resource;
            }
        }).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<ManagementPolicyInner> getInnerAsync() {
        ManagementPoliciesInner client = ((StorageManagementClientImpl)((Object)this.manager().inner())).managementPolicies();
        return client.getAsync(this.resourceGroupName, this.accountName);
    }

    public boolean isInCreateMode() {
        return ((ManagementPolicyInner)((Object)this.inner())).id() == null;
    }

    private void resetCreateUpdateParameters() {
        this.cpolicy = new ManagementPolicySchema();
        this.upolicy = new ManagementPolicySchema();
    }

    @Override
    public String id() {
        return ((ManagementPolicyInner)((Object)this.inner())).id();
    }

    @Override
    public DateTime lastModifiedTime() {
        return ((ManagementPolicyInner)((Object)this.inner())).lastModifiedTime();
    }

    @Override
    public String name() {
        return ((ManagementPolicyInner)((Object)this.inner())).name();
    }

    @Override
    public ManagementPolicySchema policy() {
        return ((ManagementPolicyInner)((Object)this.inner())).policy();
    }

    @Override
    public String type() {
        return ((ManagementPolicyInner)((Object)this.inner())).type();
    }

    @Override
    public List<PolicyRule> rules() {
        List<ManagementPolicyRule> originalRules = this.policy().rules();
        ArrayList<PolicyRule.DefinitionStages.PrefixActionFork> returnRules = new ArrayList<PolicyRule.DefinitionStages.PrefixActionFork>();
        for (ManagementPolicyRule originalRule : originalRules) {
            ManagementPolicySnapShot originalSnapshotActions;
            ManagementPolicyBaseBlob originalBaseBlobActions;
            List<String> originalBlobTypes = originalRule.definition().filters().blobTypes();
            ArrayList<BlobTypes> returnBlobTypes = new ArrayList<BlobTypes>();
            for (String originalBlobType : originalBlobTypes) {
                returnBlobTypes.add(BlobTypes.fromString(originalBlobType));
            }
            PolicyRule.DefinitionStages.PrefixActionFork returnRule = new PolicyRuleImpl(originalRule.name()).withLifecycleRuleType().withBlobTypesToFilterFor(returnBlobTypes);
            if (originalRule.definition().filters().prefixMatch() != null) {
                ((PolicyRuleImpl)returnRule).withPrefixesToFilterFor((List)originalRule.definition().filters().prefixMatch());
            }
            if ((originalBaseBlobActions = originalRule.definition().actions().baseBlob()) != null) {
                if (originalBaseBlobActions.tierToCool() != null) {
                    ((PolicyRuleImpl)returnRule).withTierToCoolActionOnBaseBlob(originalBaseBlobActions.tierToCool().daysAfterModificationGreaterThan());
                }
                if (originalBaseBlobActions.tierToArchive() != null) {
                    ((PolicyRuleImpl)returnRule).withTierToArchiveActionOnBaseBlob(originalBaseBlobActions.tierToArchive().daysAfterModificationGreaterThan());
                }
                if (originalBaseBlobActions.delete() != null) {
                    ((PolicyRuleImpl)returnRule).withDeleteActionOnBaseBlob(originalBaseBlobActions.delete().daysAfterModificationGreaterThan());
                }
            }
            if ((originalSnapshotActions = originalRule.definition().actions().snapshot()) != null && originalSnapshotActions.delete() != null) {
                ((PolicyRuleImpl)returnRule).withDeleteActionOnSnapShot(originalSnapshotActions.delete().daysAfterCreationGreaterThan());
            }
            returnRules.add(returnRule);
        }
        return Collections.unmodifiableList(returnRules);
    }

    @Override
    public ManagementPolicyImpl withExistingStorageAccount(String resourceGroupName, String accountName) {
        this.resourceGroupName = resourceGroupName;
        this.accountName = accountName;
        return this;
    }

    @Override
    public ManagementPolicyImpl withPolicy(ManagementPolicySchema policy) {
        if (this.isInCreateMode()) {
            this.cpolicy = policy;
        } else {
            this.upolicy = policy;
        }
        return this;
    }

    @Override
    public PolicyRule.DefinitionStages.Blank defineRule(String name) {
        return new PolicyRuleImpl(this, name);
    }

    void defineRule(PolicyRuleImpl policyRuleImpl) {
        if (this.isInCreateMode()) {
            if (this.cpolicy.rules() == null) {
                this.cpolicy.withRules(new ArrayList<ManagementPolicyRule>());
            }
            List<ManagementPolicyRule> rules = this.cpolicy.rules();
            rules.add(policyRuleImpl.inner());
            this.cpolicy.withRules(rules);
        } else {
            if (this.upolicy.rules() == null) {
                this.upolicy.withRules(new ArrayList<ManagementPolicyRule>());
            }
            List<ManagementPolicyRule> rules = this.upolicy.rules();
            rules.add(policyRuleImpl.inner());
            this.upolicy.withRules(rules);
        }
    }

    @Override
    public PolicyRule.Update updateRule(String name) {
        ManagementPolicyRule ruleToUpdate = null;
        for (ManagementPolicyRule rule : this.policy().rules()) {
            if (!rule.name().equals(name)) continue;
            ruleToUpdate = rule;
        }
        if (ruleToUpdate == null) {
            throw new UnsupportedOperationException("There is no rule that exists with the name " + name + ". Please define a rule with this name before updating.");
        }
        return new PolicyRuleImpl(ruleToUpdate, this);
    }

    @Override
    public ManagementPolicy.Update withoutRule(String name) {
        ManagementPolicyRule ruleToDelete = null;
        for (ManagementPolicyRule rule : this.policy().rules()) {
            if (!rule.name().equals(name)) continue;
            ruleToDelete = rule;
        }
        if (ruleToDelete == null) {
            throw new UnsupportedOperationException("There is no rule that exists with the name " + name + " so this rule can not be deleted.");
        }
        List<ManagementPolicyRule> currentRules = this.upolicy.rules();
        currentRules.remove(ruleToDelete);
        this.upolicy.withRules(currentRules);
        return this;
    }
}

