/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.storage.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.storage.Kind;
import com.microsoft.azure.management.storage.Restriction;
import com.microsoft.azure.management.storage.SKUCapability;
import com.microsoft.azure.management.storage.SkuName;
import com.microsoft.azure.management.storage.SkuTier;
import com.microsoft.azure.management.storage.StorageAccountSkuType;
import com.microsoft.azure.management.storage.StorageResourceType;
import com.microsoft.azure.management.storage.StorageSku;
import com.microsoft.azure.management.storage.implementation.SkuInner;
import java.util.ArrayList;
import java.util.List;

@LangDefinition
class StorageSkuImpl
implements StorageSku {
    private final SkuInner inner;

    StorageSkuImpl(SkuInner skuInner) {
        this.inner = skuInner;
    }

    @Override
    public SkuName name() {
        return this.inner.name();
    }

    @Override
    public SkuTier tier() {
        return this.inner.tier();
    }

    @Override
    public StorageResourceType resourceType() {
        if (this.inner.resourceType() != null) {
            return StorageResourceType.fromString(this.inner.resourceType());
        }
        return null;
    }

    @Override
    public List<Region> regions() {
        ArrayList<Region> regions = new ArrayList<Region>();
        if (this.inner.locations() != null) {
            for (String location : this.inner.locations()) {
                regions.add(Region.fromName((String)location));
            }
        }
        return regions;
    }

    @Override
    public List<SKUCapability> capabilities() {
        if (this.inner.capabilities() != null) {
            return this.inner.capabilities();
        }
        return new ArrayList<SKUCapability>();
    }

    @Override
    public List<Restriction> restrictions() {
        if (this.inner.restrictions() != null) {
            return this.inner.restrictions();
        }
        return new ArrayList<Restriction>();
    }

    @Override
    public Kind storageAccountKind() {
        return this.inner.kind();
    }

    @Override
    public StorageAccountSkuType storageAccountSku() {
        if (this.resourceType() != null && this.resourceType().equals((Object)StorageResourceType.STORAGE_ACCOUNTS)) {
            return StorageAccountSkuType.fromSkuName(this.inner.name());
        }
        return null;
    }

    public SkuInner inner() {
        return this.inner;
    }
}

