/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.cosmosdb.CosmosDBAccount;
import com.microsoft.azure.management.cosmosdb.CosmosDBAccounts;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountListConnectionStringsResult;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountListKeysResult;
import com.microsoft.azure.management.cosmosdb.DatabaseAccountListReadOnlyKeysResult;
import com.microsoft.azure.management.cosmosdb.KeyKind;
import com.microsoft.azure.management.cosmosdb.Location;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBAccountImpl;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBManager;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListConnectionStringsResultImpl;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListConnectionStringsResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListKeysResultImpl;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListKeysResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListReadOnlyKeysResultImpl;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountListReadOnlyKeysResultInner;
import com.microsoft.azure.management.cosmosdb.implementation.DatabaseAccountsInner;
import com.microsoft.azure.management.cosmosdb.implementation.FailoverPolicyInner;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupPagedList;
import java.util.ArrayList;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class CosmosDBAccountsImpl
extends GroupableResourcesImpl<CosmosDBAccount, CosmosDBAccountImpl, DatabaseAccountInner, DatabaseAccountsInner, CosmosDBManager>
implements CosmosDBAccounts {
    CosmosDBAccountsImpl(CosmosDBManager manager) {
        super((Object)((CosmosDBImpl)((Object)manager.inner())).databaseAccounts(), (ManagerBase)manager);
    }

    public PagedList<CosmosDBAccount> list() {
        final CosmosDBAccountsImpl self = this;
        return new GroupPagedList<CosmosDBAccount>(((CosmosDBManager)this.manager()).resourceManager().resourceGroups().list()){

            public List<CosmosDBAccount> listNextGroup(String resourceGroupName) {
                return CosmosDBAccountsImpl.this.wrapList(((DatabaseAccountsInner)self.inner()).listByResourceGroup(resourceGroupName));
            }
        };
    }

    public Observable<CosmosDBAccount> listAsync() {
        return ((CosmosDBManager)this.manager()).resourceManager().resourceGroups().listAsync().flatMap((Func1)new Func1<ResourceGroup, Observable<CosmosDBAccount>>(){

            public Observable<CosmosDBAccount> call(ResourceGroup resourceGroup) {
                return CosmosDBAccountsImpl.this.wrapPageAsync(((DatabaseAccountsInner)CosmosDBAccountsImpl.this.inner()).listByResourceGroupAsync(resourceGroup.name()));
            }
        });
    }

    public Observable<CosmosDBAccount> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(((DatabaseAccountsInner)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }

    public PagedList<CosmosDBAccount> listByResourceGroup(String groupName) {
        return this.wrapList(((DatabaseAccountsInner)this.inner()).listByResourceGroup(groupName));
    }

    protected Observable<DatabaseAccountInner> getInnerAsync(String resourceGroupName, String name) {
        return ((DatabaseAccountsInner)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    public CosmosDBAccountImpl define(String name) {
        return this.wrapModel(name);
    }

    protected Completable deleteInnerAsync(String groupName, String name) {
        return ((DatabaseAccountsInner)this.inner()).deleteAsync(groupName, name).toCompletable();
    }

    protected CosmosDBAccountImpl wrapModel(String name) {
        return new CosmosDBAccountImpl(name, new DatabaseAccountInner(), (CosmosDBManager)this.manager());
    }

    protected CosmosDBAccountImpl wrapModel(DatabaseAccountInner containerServiceInner) {
        if (containerServiceInner == null) {
            return null;
        }
        return new CosmosDBAccountImpl(containerServiceInner.name(), containerServiceInner, (CosmosDBManager)this.manager());
    }

    @Override
    public void failoverPriorityChange(String groupName, String accountName, List<Location> failoverLocations) {
        this.failoverPriorityChangeAsync(groupName, accountName, failoverLocations).toBlocking().last();
    }

    @Override
    public Observable<Void> failoverPriorityChangeAsync(String groupName, String accountName, List<Location> failoverLocations) {
        ArrayList<FailoverPolicyInner> policyInners = new ArrayList<FailoverPolicyInner>();
        for (int i = 0; i < failoverLocations.size(); ++i) {
            Location location = failoverLocations.get(i);
            FailoverPolicyInner policyInner = new FailoverPolicyInner();
            policyInner.withLocationName(location.locationName());
            policyInner.withFailoverPriority(i);
            policyInners.add(policyInner);
        }
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().failoverPriorityChangeAsync(groupName, accountName, policyInners);
    }

    @Override
    public DatabaseAccountListKeysResult listKeys(String groupName, String accountName) {
        return (DatabaseAccountListKeysResult)this.listKeysAsync(groupName, accountName).toBlocking().last();
    }

    @Override
    public DatabaseAccountListReadOnlyKeysResult listReadOnlyKeys(String groupName, String accountName) {
        return (DatabaseAccountListReadOnlyKeysResult)this.listReadOnlyKeysAsync(groupName, accountName).toBlocking().last();
    }

    @Override
    public Observable<DatabaseAccountListKeysResult> listKeysAsync(String groupName, String accountName) {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().listKeysAsync(groupName, accountName).map((Func1)new Func1<DatabaseAccountListKeysResultInner, DatabaseAccountListKeysResult>(){

            public DatabaseAccountListKeysResult call(DatabaseAccountListKeysResultInner databaseAccountListKeysResultInner) {
                return new DatabaseAccountListKeysResultImpl(databaseAccountListKeysResultInner);
            }
        });
    }

    @Override
    public Observable<DatabaseAccountListReadOnlyKeysResult> listReadOnlyKeysAsync(String groupName, String accountName) {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().listReadOnlyKeysAsync(groupName, accountName).map((Func1)new Func1<DatabaseAccountListReadOnlyKeysResultInner, DatabaseAccountListReadOnlyKeysResult>(){

            public DatabaseAccountListReadOnlyKeysResult call(DatabaseAccountListReadOnlyKeysResultInner databaseAccountListReadOnlyKeysResultInner) {
                return new DatabaseAccountListReadOnlyKeysResultImpl(databaseAccountListReadOnlyKeysResultInner);
            }
        });
    }

    @Override
    public DatabaseAccountListConnectionStringsResult listConnectionStrings(String groupName, String accountName) {
        return (DatabaseAccountListConnectionStringsResult)this.listConnectionStringsAsync(groupName, accountName).toBlocking().last();
    }

    @Override
    public Observable<DatabaseAccountListConnectionStringsResult> listConnectionStringsAsync(String groupName, String accountName) {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().listConnectionStringsAsync(groupName, accountName).map((Func1)new Func1<DatabaseAccountListConnectionStringsResultInner, DatabaseAccountListConnectionStringsResult>(){

            public DatabaseAccountListConnectionStringsResult call(DatabaseAccountListConnectionStringsResultInner databaseAccountListConnectionStringsResultInner) {
                return new DatabaseAccountListConnectionStringsResultImpl(databaseAccountListConnectionStringsResultInner);
            }
        });
    }

    @Override
    public void regenerateKey(String groupName, String accountName, KeyKind keyKind) {
        this.regenerateKeyAsync(groupName, accountName, keyKind).toBlocking().last();
    }

    @Override
    public Observable<Void> regenerateKeyAsync(String groupName, String accountName, KeyKind keyKind) {
        return ((CosmosDBImpl)((Object)((CosmosDBManager)this.manager()).inner())).databaseAccounts().regenerateKeyAsync(groupName, accountName, keyKind);
    }
}

