/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.keyvault.implementation;

import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.keyvault.KeyIdentifier;
import com.microsoft.azure.keyvault.models.Attributes;
import com.microsoft.azure.keyvault.models.BackupKeyResult;
import com.microsoft.azure.keyvault.models.KeyAttributes;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.KeyItem;
import com.microsoft.azure.keyvault.models.KeyOperationResult;
import com.microsoft.azure.keyvault.models.KeyVerifyResult;
import com.microsoft.azure.keyvault.requests.CreateKeyRequest;
import com.microsoft.azure.keyvault.requests.ImportKeyRequest;
import com.microsoft.azure.keyvault.requests.UpdateKeyRequest;
import com.microsoft.azure.keyvault.webkey.JsonWebKey;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyEncryptionAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyOperation;
import com.microsoft.azure.keyvault.webkey.JsonWebKeySignatureAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyType;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.keyvault.Key;
import com.microsoft.azure.management.keyvault.Vault;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultFutures;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.rest.ServiceFuture;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func0;
import rx.functions.Func1;

@LangDefinition
class KeyImpl
extends CreatableUpdatableImpl<Key, KeyBundle, KeyImpl>
implements Key,
Key.Definition,
Key.UpdateWithCreate,
Key.UpdateWithImport {
    private final Vault vault;
    private CreateKeyRequest.Builder createKeyRequest;
    private UpdateKeyRequest.Builder updateKeyRequest;
    private ImportKeyRequest.Builder importKeyRequest;

    KeyImpl(String name, KeyBundle innerObject, Vault vault) {
        super(name, (Object)innerObject);
        this.vault = vault;
        this.updateKeyRequest = new UpdateKeyRequest.Builder(vault.vaultUri(), name);
    }

    public String id() {
        if (((KeyBundle)this.inner()).keyIdentifier() == null) {
            return null;
        }
        return ((KeyBundle)this.inner()).keyIdentifier().identifier();
    }

    @Override
    public JsonWebKey jsonWebKey() {
        return ((KeyBundle)this.inner()).key();
    }

    @Override
    public KeyAttributes attributes() {
        return ((KeyBundle)this.inner()).attributes();
    }

    @Override
    public Map<String, String> tags() {
        return ((KeyBundle)this.inner()).tags();
    }

    @Override
    public boolean managed() {
        return Utils.toPrimitiveBoolean((Boolean)((KeyBundle)this.inner()).managed());
    }

    @Override
    public PagedList<Key> listVersions() {
        return new PagedListConverter<KeyItem, Key>(){

            public Observable<Key> typeConvertAsync(final KeyItem keyItem) {
                return new KeyVaultFutures.ServiceFutureConverter<KeyBundle, Key>(){

                    @Override
                    protected ServiceFuture<KeyBundle> callAsync() {
                        return KeyImpl.this.vault.client().getKeyAsync(keyItem.identifier().identifier(), null);
                    }

                    @Override
                    protected Key wrapModel(KeyBundle keyBundle) {
                        return new KeyImpl(keyBundle.keyIdentifier().name(), keyBundle, KeyImpl.this.vault);
                    }
                }.toObservable();
            }
        }.convert(this.vault.client().listKeyVersions(this.vault.vaultUri(), this.name()));
    }

    @Override
    public Observable<Key> listVersionsAsync() {
        return new KeyVaultFutures.ListCallbackObserver<KeyItem, KeyIdentifier>(){

            @Override
            protected void list(ListOperationCallback<KeyItem> callback) {
                KeyImpl.this.vault.client().listKeyVersionsAsync(KeyImpl.this.vault.vaultUri(), KeyImpl.this.name(), callback);
            }

            @Override
            protected Observable<KeyIdentifier> typeConvertAsync(KeyItem o) {
                return Observable.just((Object)o.identifier());
            }
        }.toObservable().flatMap((Func1)new Func1<KeyIdentifier, Observable<Key>>(){

            public Observable<Key> call(final KeyIdentifier keyIdentifier) {
                return new KeyVaultFutures.ServiceFutureConverter<KeyBundle, Key>(){

                    @Override
                    protected ServiceFuture<KeyBundle> callAsync() {
                        return KeyImpl.this.vault.client().getKeyAsync(keyIdentifier.identifier(), null);
                    }

                    @Override
                    protected Key wrapModel(KeyBundle keyBundle) {
                        return new KeyImpl(keyIdentifier.name(), keyBundle, KeyImpl.this.vault);
                    }
                }.toObservable();
            }
        });
    }

    @Override
    public byte[] backup() {
        return this.vault.client().backupKey(this.vault.vaultUri(), this.name()).value();
    }

    @Override
    public Observable<byte[]> backupAsync() {
        return new KeyVaultFutures.ServiceFutureConverter<BackupKeyResult, byte[]>(){

            @Override
            protected ServiceFuture<BackupKeyResult> callAsync() {
                return KeyImpl.this.vault.client().backupKeyAsync(KeyImpl.this.vault.vaultUri(), KeyImpl.this.name(), null);
            }

            @Override
            protected byte[] wrapModel(BackupKeyResult backupKeyResult) {
                return backupKeyResult.value();
            }
        }.toObservable();
    }

    @Override
    public byte[] encrypt(JsonWebKeyEncryptionAlgorithm algorithm, byte[] content) {
        return this.vault.client().encrypt(((KeyBundle)this.inner()).keyIdentifier().identifier(), algorithm, content).result();
    }

    @Override
    public Observable<byte[]> encryptAsync(final JsonWebKeyEncryptionAlgorithm algorithm, final byte[] content) {
        return new KeyVaultFutures.ServiceFutureConverter<KeyOperationResult, byte[]>(){

            @Override
            protected ServiceFuture<KeyOperationResult> callAsync() {
                return KeyImpl.this.vault.client().encryptAsync(((KeyBundle)KeyImpl.this.inner()).keyIdentifier().identifier(), algorithm, content, null);
            }

            @Override
            protected byte[] wrapModel(KeyOperationResult keyOperationResult) {
                return keyOperationResult.result();
            }
        }.toObservable();
    }

    @Override
    public byte[] decrypt(JsonWebKeyEncryptionAlgorithm algorithm, byte[] content) {
        return this.vault.client().decrypt(((KeyBundle)this.inner()).keyIdentifier().identifier(), algorithm, content).result();
    }

    @Override
    public Observable<byte[]> decryptAsync(final JsonWebKeyEncryptionAlgorithm algorithm, final byte[] content) {
        return new KeyVaultFutures.ServiceFutureConverter<KeyOperationResult, byte[]>(){

            @Override
            protected ServiceFuture<KeyOperationResult> callAsync() {
                return KeyImpl.this.vault.client().decryptAsync(((KeyBundle)KeyImpl.this.inner()).keyIdentifier().identifier(), algorithm, content, null);
            }

            @Override
            protected byte[] wrapModel(KeyOperationResult keyOperationResult) {
                return keyOperationResult.result();
            }
        }.toObservable();
    }

    @Override
    public byte[] sign(JsonWebKeySignatureAlgorithm algorithm, byte[] digest) {
        return this.vault.client().sign(((KeyBundle)this.inner()).keyIdentifier().identifier(), algorithm, digest).result();
    }

    @Override
    public Observable<byte[]> signAsync(final JsonWebKeySignatureAlgorithm algorithm, final byte[] digest) {
        return new KeyVaultFutures.ServiceFutureConverter<KeyOperationResult, byte[]>(){

            @Override
            protected ServiceFuture<KeyOperationResult> callAsync() {
                return KeyImpl.this.vault.client().signAsync(((KeyBundle)KeyImpl.this.inner()).keyIdentifier().identifier(), algorithm, digest, null);
            }

            @Override
            protected byte[] wrapModel(KeyOperationResult keyOperationResult) {
                return keyOperationResult.result();
            }
        }.toObservable();
    }

    @Override
    public boolean verify(JsonWebKeySignatureAlgorithm algorithm, byte[] digest, byte[] signature) {
        return this.vault.client().verify(((KeyBundle)this.inner()).keyIdentifier().identifier(), algorithm, digest, signature).value();
    }

    @Override
    public Observable<Boolean> verifyAsync(final JsonWebKeySignatureAlgorithm algorithm, final byte[] digest, final byte[] signature) {
        return new KeyVaultFutures.ServiceFutureConverter<KeyVerifyResult, Boolean>(){

            @Override
            protected ServiceFuture<KeyVerifyResult> callAsync() {
                return KeyImpl.this.vault.client().verifyAsync(((KeyBundle)KeyImpl.this.inner()).keyIdentifier().identifier(), algorithm, digest, signature, null);
            }

            @Override
            protected Boolean wrapModel(KeyVerifyResult keyOperationResult) {
                return keyOperationResult.value();
            }
        }.toObservable();
    }

    @Override
    public byte[] wrapKey(JsonWebKeyEncryptionAlgorithm algorithm, byte[] key) {
        return this.vault.client().wrapKey(((KeyBundle)this.inner()).keyIdentifier().identifier(), algorithm, key).result();
    }

    @Override
    public Observable<byte[]> wrapKeyAsync(final JsonWebKeyEncryptionAlgorithm algorithm, final byte[] key) {
        return new KeyVaultFutures.ServiceFutureConverter<KeyOperationResult, byte[]>(){

            @Override
            protected ServiceFuture<KeyOperationResult> callAsync() {
                return KeyImpl.this.vault.client().wrapKeyAsync(((KeyBundle)KeyImpl.this.inner()).keyIdentifier().identifier(), algorithm, key, null);
            }

            @Override
            protected byte[] wrapModel(KeyOperationResult keyOperationResult) {
                return keyOperationResult.result();
            }
        }.toObservable();
    }

    @Override
    public byte[] unwrapKey(JsonWebKeyEncryptionAlgorithm algorithm, byte[] key) {
        return this.vault.client().unwrapKey(((KeyBundle)this.inner()).keyIdentifier().identifier(), algorithm, key).result();
    }

    @Override
    public Observable<byte[]> unwrapKeyAsync(final JsonWebKeyEncryptionAlgorithm algorithm, final byte[] key) {
        return new KeyVaultFutures.ServiceFutureConverter<KeyOperationResult, byte[]>(){

            @Override
            protected ServiceFuture<KeyOperationResult> callAsync() {
                return KeyImpl.this.vault.client().unwrapKeyAsync(((KeyBundle)KeyImpl.this.inner()).keyIdentifier().identifier(), algorithm, key, null);
            }

            @Override
            protected byte[] wrapModel(KeyOperationResult keyOperationResult) {
                return keyOperationResult.result();
            }
        }.toObservable();
    }

    protected Observable<KeyBundle> getInnerAsync() {
        return Observable.from((Future)this.vault.client().getKeyAsync(this.id(), null));
    }

    @Override
    public KeyImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            if (this.createKeyRequest != null) {
                this.createKeyRequest.withTags(tags);
            } else {
                this.importKeyRequest.withTags(tags);
            }
        } else {
            this.updateKeyRequest.withTags(tags);
        }
        return this;
    }

    public boolean isInCreateMode() {
        return this.id() == null;
    }

    public Observable<Key> createResourceAsync() {
        return Observable.defer((Func0)new Func0<Observable<Key>>(){

            public Observable<Key> call() {
                if (KeyImpl.this.createKeyRequest != null) {
                    return Observable.from((Future)KeyImpl.this.vault.client().createKeyAsync(KeyImpl.this.createKeyRequest.build(), null)).map(KeyImpl.this.innerToFluentMap((IndexableRefreshableWrapperImpl)KeyImpl.this)).doOnCompleted(new Action0(){

                        public void call() {
                            KeyImpl.this.createKeyRequest = null;
                            KeyImpl.this.updateKeyRequest = new UpdateKeyRequest.Builder(KeyImpl.this.vault.vaultUri(), KeyImpl.this.name());
                        }
                    });
                }
                return Observable.from((Future)KeyImpl.this.vault.client().importKeyAsync(KeyImpl.this.importKeyRequest.build(), null)).map(KeyImpl.this.innerToFluentMap((IndexableRefreshableWrapperImpl)KeyImpl.this)).doOnCompleted(new Action0(){

                    public void call() {
                        KeyImpl.this.importKeyRequest = null;
                        KeyImpl.this.updateKeyRequest = new UpdateKeyRequest.Builder(KeyImpl.this.vault.vaultUri(), KeyImpl.this.name());
                    }
                });
            }
        });
    }

    public Observable<Key> updateResourceAsync() {
        Observable<Key> set = Observable.just((Object)this);
        if (this.createKeyRequest != null || this.importKeyRequest != null) {
            set = this.createResourceAsync();
        }
        return set.flatMap((Func1)new Func1<Key, Observable<KeyBundle>>(){

            public Observable<KeyBundle> call(Key secret) {
                return Observable.from((Future)KeyImpl.this.vault.client().updateKeyAsync(KeyImpl.this.updateKeyRequest.build(), null));
            }
        }).flatMap((Func1)new Func1<KeyBundle, Observable<Key>>(){

            public Observable<Key> call(KeyBundle secretBundle) {
                return KeyImpl.this.refreshAsync();
            }
        }).doOnCompleted(new Action0(){

            public void call() {
                KeyImpl.this.createKeyRequest = null;
                KeyImpl.this.importKeyRequest = null;
                KeyImpl.this.updateKeyRequest = new UpdateKeyRequest.Builder(KeyImpl.this.vault.vaultUri(), KeyImpl.this.name());
            }
        });
    }

    @Override
    public KeyImpl withAttributes(Attributes attributes) {
        if (this.isInCreateMode()) {
            if (this.createKeyRequest != null) {
                this.createKeyRequest.withAttributes(attributes);
            } else {
                this.importKeyRequest.withAttributes(attributes);
            }
        } else {
            this.updateKeyRequest.withAttributes(attributes);
        }
        return this;
    }

    @Override
    public KeyImpl withKeyTypeToCreate(JsonWebKeyType keyType) {
        this.createKeyRequest = new CreateKeyRequest.Builder(this.vault.vaultUri(), this.name(), keyType);
        return this;
    }

    @Override
    public KeyImpl withLocalKeyToImport(JsonWebKey key) {
        this.importKeyRequest = new ImportKeyRequest.Builder(this.vault.vaultUri(), this.name(), key);
        return this;
    }

    @Override
    public KeyImpl withKeyOperations(List<JsonWebKeyOperation> keyOperations) {
        if (this.isInCreateMode()) {
            this.createKeyRequest.withKeyOperations(keyOperations);
        } else {
            this.updateKeyRequest.withKeyOperations(keyOperations);
        }
        return this;
    }

    @Override
    public KeyImpl withKeyOperations(JsonWebKeyOperation ... keyOperations) {
        return this.withKeyOperations((List)Arrays.asList(keyOperations));
    }

    @Override
    public KeyImpl withHsm(boolean isHsm) {
        this.importKeyRequest.withHsm(isHsm);
        return this;
    }

    @Override
    public KeyImpl withKeySize(int size) {
        this.createKeyRequest.withKeySize(Integer.valueOf(size));
        return this;
    }
}

