/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.kms.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CryptoKeyPathName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key_path=**}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String keyRing;
    private final String cryptoKeyPath;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getKeyRing() {
        return this.keyRing;
    }

    public String getCryptoKeyPath() {
        return this.cryptoKeyPath;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CryptoKeyPathName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.keyRing = (String)Preconditions.checkNotNull((Object)builder.getKeyRing());
        this.cryptoKeyPath = (String)Preconditions.checkNotNull((Object)builder.getCryptoKeyPath());
    }

    public static CryptoKeyPathName of(String project, String location, String keyRing, String cryptoKeyPath) {
        return CryptoKeyPathName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).setCryptoKeyPath(cryptoKeyPath).build();
    }

    public static String format(String project, String location, String keyRing, String cryptoKeyPath) {
        return CryptoKeyPathName.newBuilder().setProject(project).setLocation(location).setKeyRing(keyRing).setCryptoKeyPath(cryptoKeyPath).build().toString();
    }

    public static CryptoKeyPathName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CryptoKeyPathName.parse: formattedString not in valid format");
        return CryptoKeyPathName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("key_ring"), (String)matchMap.get("crypto_key_path"));
    }

    public static List<CryptoKeyPathName> parseList(List<String> formattedStrings) {
        ArrayList<CryptoKeyPathName> list = new ArrayList<CryptoKeyPathName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CryptoKeyPathName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CryptoKeyPathName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CryptoKeyPathName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CryptoKeyPathName cryptoKeyPathName = this;
            synchronized (cryptoKeyPathName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"keyRing", (Object)this.keyRing);
                    fieldMapBuilder.put((Object)"cryptoKeyPath", (Object)this.cryptoKeyPath);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "key_ring", this.keyRing, "crypto_key_path", this.cryptoKeyPath});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CryptoKeyPathName) {
            CryptoKeyPathName that = (CryptoKeyPathName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.keyRing.equals(that.keyRing) && this.cryptoKeyPath.equals(that.cryptoKeyPath);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.keyRing.hashCode();
        h *= 1000003;
        return h ^= this.cryptoKeyPath.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String keyRing;
        private String cryptoKeyPath;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getKeyRing() {
            return this.keyRing;
        }

        public String getCryptoKeyPath() {
            return this.cryptoKeyPath;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setKeyRing(String keyRing) {
            this.keyRing = keyRing;
            return this;
        }

        public Builder setCryptoKeyPath(String cryptoKeyPath) {
            this.cryptoKeyPath = cryptoKeyPath;
            return this;
        }

        private Builder() {
        }

        private Builder(CryptoKeyPathName cryptoKeyPathName) {
            this.project = cryptoKeyPathName.project;
            this.location = cryptoKeyPathName.location;
            this.keyRing = cryptoKeyPathName.keyRing;
            this.cryptoKeyPath = cryptoKeyPathName.cryptoKeyPath;
        }

        public CryptoKeyPathName build() {
            return new CryptoKeyPathName(this);
        }
    }
}

