/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;

public class ImplicitDocRouter
extends DocRouter {
    public static final String NAME = "implicit";

    @Override
    public Slice getTargetSlice(String id, SolrInputDocument sdoc, String route, SolrParams params, DocCollection collection) {
        String shard = null;
        if (route != null) {
            shard = route;
        } else if (sdoc != null) {
            Object o;
            String f = this.getRouteField(collection);
            if (f != null) {
                o = sdoc.getFieldValue(f);
                if (o != null) {
                    shard = o.toString();
                } else {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No value for field " + f + " in " + sdoc);
                }
            }
            if (shard == null && (o = sdoc.getFieldValue("_route_")) != null) {
                shard = o.toString();
            }
        }
        if (shard == null) {
            shard = params.get("_route_");
        }
        if (shard != null) {
            Slice slice = collection.getSlice(shard);
            if (slice == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard called =" + shard + " in " + collection);
            }
            return slice;
        }
        return null;
    }

    @Override
    public boolean isTargetSlice(String id, SolrInputDocument sdoc, SolrParams params, String shardId, DocCollection collection) {
        return false;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Collection<Slice> getSearchSlicesSingle(String shardKey, SolrParams params, DocCollection collection) {
        if (shardKey == null) {
            return collection.getActiveSlices();
        }
        Slice slice = collection.getSlice(shardKey);
        if (slice == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "implicit router can't find shard " + shardKey + " in collection " + collection.getName());
        }
        return Collections.singleton(slice);
    }

    @Override
    public List<DocRouter.Range> partitionRange(int partitions, DocRouter.Range range) {
        return null;
    }
}

