/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.audit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.utils.JsonUtils;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.JsonUtilsV2;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerRESTUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerDefaultAuditHandler
implements RangerAccessResultProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(RangerDefaultAuditHandler.class);
    private static final String CONF_AUDIT_ID_STRICT_UUID = "xasecure.audit.auditid.strict.uuid";
    private static final boolean DEFAULT_AUDIT_ID_STRICT_UUID = false;
    private final boolean auditIdStrictUUID;
    protected final String moduleName;
    private final RangerRESTUtils restUtils = new RangerRESTUtils();
    private long sequenceNumber = 0L;
    private String UUID = MiscUtil.generateUniqueId();
    private AtomicInteger counter = new AtomicInteger(0);

    public RangerDefaultAuditHandler() {
        this.auditIdStrictUUID = false;
        this.moduleName = "ranger-acl";
    }

    public RangerDefaultAuditHandler(Configuration config) {
        this.auditIdStrictUUID = config.getBoolean(CONF_AUDIT_ID_STRICT_UUID, false);
        this.moduleName = config.get("xasecure.auditlog.xasecureAcl.name", "ranger-acl");
    }

    @Override
    public void processResult(RangerAccessResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultAuditHandler.processResult(" + result + ")");
        }
        AuthzAuditEvent event = this.getAuthzEvents(result);
        this.logAuthzAudit(event);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultAuditHandler.processResult(" + result + ")");
        }
    }

    @Override
    public void processResults(Collection<RangerAccessResult> results) {
        Collection<AuthzAuditEvent> events;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultAuditHandler.processResults(" + results + ")");
        }
        if ((events = this.getAuthzEvents(results)) != null) {
            this.logAuthzAudits(events);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultAuditHandler.processResults(" + results + ")");
        }
    }

    public AuthzAuditEvent getAuthzEvents(RangerAccessResult result) {
        RangerAccessRequest request;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultAuditHandler.getAuthzEvents(" + result + ")");
        }
        AuthzAuditEvent ret = null;
        RangerAccessRequest rangerAccessRequest = request = result != null ? result.getAccessRequest() : null;
        if (request != null && result != null && result.getIsAudited()) {
            RangerAccessResource resource = request.getResource();
            String resourceType = resource == null ? null : resource.getLeafName();
            String resourcePath = resource == null ? null : resource.getAsString();
            ret = this.createAuthzAuditEvent();
            ret.setRepositoryName(result.getServiceName());
            ret.setRepositoryType(result.getServiceType());
            ret.setResourceType(resourceType);
            ret.setResourcePath(resourcePath);
            ret.setRequestData(request.getRequestData());
            ret.setEventTime(request.getAccessTime() != null ? request.getAccessTime() : new Date());
            ret.setUser(request.getUser());
            ret.setAction(request.getAccessType());
            ret.setAccessResult((short)(result.getIsAllowed() ? 1 : 0));
            ret.setPolicyId(result.getPolicyId());
            ret.setAccessType(request.getAction());
            ret.setClientIP(request.getClientIPAddress());
            ret.setClientType(request.getClientType());
            ret.setSessionId(request.getSessionId());
            ret.setAclEnforcer(this.moduleName);
            Set<String> tags = this.getTags(request);
            if (tags != null) {
                ret.setTags(tags);
            }
            ret.setAdditionalInfo(this.getAdditionalInfo(request));
            ret.setClusterName(request.getClusterName());
            ret.setZoneName(result.getZoneName());
            ret.setAgentHostname(this.restUtils.getAgentHostname());
            ret.setPolicyVersion(result.getPolicyVersion());
            this.populateDefaults(ret);
            result.setAuditLogId(ret.getEventId());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultAuditHandler.getAuthzEvents(" + result + "): " + ret);
        }
        return ret;
    }

    public Collection<AuthzAuditEvent> getAuthzEvents(Collection<RangerAccessResult> results) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultAuditHandler.getAuthzEvents(" + results + ")");
        }
        ArrayList<AuthzAuditEvent> ret = null;
        if (results != null) {
            for (RangerAccessResult result : results) {
                AuthzAuditEvent event = this.getAuthzEvents(result);
                if (event == null) continue;
                if (ret == null) {
                    ret = new ArrayList<AuthzAuditEvent>();
                }
                ret.add(event);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultAuditHandler.getAuthzEvents(" + results + "): " + ret);
        }
        return ret;
    }

    public void logAuthzAudit(AuthzAuditEvent auditEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultAuditHandler.logAuthzAudit(" + auditEvent + ")");
        }
        if (auditEvent != null) {
            this.populateDefaults(auditEvent);
            AuditHandler auditProvider = RangerBasePlugin.getAuditProvider(auditEvent.getRepositoryName());
            if (auditProvider == null || !auditProvider.log((AuditEventBase)auditEvent)) {
                MiscUtil.logErrorMessageByInterval((Logger)LOG, (String)("fail to log audit event " + auditEvent));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultAuditHandler.logAuthzAudit(" + auditEvent + ")");
        }
    }

    private void populateDefaults(AuthzAuditEvent auditEvent) {
        if (auditEvent.getAclEnforcer() == null || auditEvent.getAclEnforcer().isEmpty()) {
            auditEvent.setAclEnforcer("ranger-acl");
        }
        if (auditEvent.getAgentHostname() == null || auditEvent.getAgentHostname().isEmpty()) {
            auditEvent.setAgentHostname(MiscUtil.getHostname());
        }
        if (auditEvent.getLogType() == null || auditEvent.getLogType().isEmpty()) {
            auditEvent.setLogType("RangerAudit");
        }
        if (auditEvent.getEventId() == null || auditEvent.getEventId().isEmpty()) {
            auditEvent.setEventId(this.generateNextAuditEventId());
        }
        if (auditEvent.getAgentId() == null) {
            auditEvent.setAgentId(MiscUtil.getApplicationType());
        }
        auditEvent.setSeqNum(this.sequenceNumber++);
    }

    public void logAuthzAudits(Collection<AuthzAuditEvent> auditEvents) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerDefaultAuditHandler.logAuthzAudits(" + auditEvents + ")");
        }
        if (auditEvents != null) {
            for (AuthzAuditEvent auditEvent : auditEvents) {
                this.logAuthzAudit(auditEvent);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerDefaultAuditHandler.logAuthzAudits(" + auditEvents + ")");
        }
    }

    public AuthzAuditEvent createAuthzAuditEvent() {
        return new AuthzAuditEvent();
    }

    protected final Set<String> getTags(RangerAccessRequest request) {
        HashSet<String> ret = null;
        Set<RangerTagForEval> tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
        if (CollectionUtils.isNotEmpty(tags)) {
            ret = new HashSet<String>();
            for (RangerTagForEval tag : tags) {
                ret.add(this.writeObjectAsString(tag));
            }
        }
        return ret;
    }

    public String getAdditionalInfo(RangerAccessRequest request) {
        if (StringUtils.isBlank((String)request.getRemoteIPAddress()) && CollectionUtils.isEmpty(request.getForwardedAddresses())) {
            return null;
        }
        HashMap<String, String> addInfomap = new HashMap<String, String>();
        addInfomap.put("forwarded-ip-addresses", "[" + StringUtils.join(request.getForwardedAddresses(), (String)", ") + "]");
        addInfomap.put("remote-ip-address", request.getRemoteIPAddress());
        String addInfojsonStr = JsonUtils.mapToJson(addInfomap);
        return addInfojsonStr;
    }

    private String generateNextAuditEventId() {
        String ret;
        if (this.auditIdStrictUUID) {
            ret = MiscUtil.generateGuid();
        } else {
            int nextId = this.counter.getAndIncrement();
            if (nextId == Integer.MAX_VALUE) {
                this.UUID = MiscUtil.generateUniqueId();
                this.counter = new AtomicInteger(0);
            }
            ret = this.UUID + "-" + Integer.toString(nextId);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("generateNextAuditEventId(): " + ret);
        }
        return ret;
    }

    private String writeObjectAsString(Serializable obj) {
        String jsonStr = "";
        try {
            jsonStr = JsonUtilsV2.objToJson(obj);
        }
        catch (Exception e) {
            LOG.error("Cannot create JSON string for object:[" + obj + "]", (Throwable)e);
        }
        return jsonStr;
    }
}

