/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.tagsync.source.atlas;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.atlas.model.TimeBoundary;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.notification.EntityNotification;
import org.apache.atlas.v1.model.instance.Id;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.instance.Struct;
import org.apache.atlas.v1.model.notification.EntityNotificationV1;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ranger.plugin.model.RangerValiditySchedule;
import org.apache.ranger.tagsync.source.atlas.AtlasResourceMapperUtil;
import org.apache.ranger.tagsync.source.atlasrest.RangerAtlasEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityNotificationWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(EntityNotificationWrapper.class);
    private final RangerAtlasEntity rangerAtlasEntity;
    private final String entityTypeName;
    private final boolean isEntityActive;
    private final boolean isEntityTypeHandled;
    private final boolean isEntityDeleteOp;
    private final boolean isEntityCreateOp;
    private final boolean isEmptyClassifications;
    private final List<RangerAtlasClassification> classifications;
    private final NotificationOpType opType;

    EntityNotificationWrapper(@Nonnull EntityNotification notification) {
        EntityNotification.EntityNotificationType notificationType = notification.getType();
        block0 : switch (notificationType) {
            case ENTITY_NOTIFICATION_V2: {
                EntityNotification.EntityNotificationV2 v2Notification = (EntityNotification.EntityNotificationV2)notification;
                AtlasEntityHeader atlasEntity = v2Notification.getEntity();
                String guid = atlasEntity.getGuid();
                String typeName = atlasEntity.getTypeName();
                this.rangerAtlasEntity = new RangerAtlasEntity(typeName, guid, atlasEntity.getAttributes());
                this.entityTypeName = atlasEntity.getTypeName();
                this.isEntityActive = atlasEntity.getStatus() == AtlasEntity.Status.ACTIVE;
                this.isEntityTypeHandled = AtlasResourceMapperUtil.isEntityTypeHandled(this.entityTypeName);
                this.isEntityDeleteOp = EntityNotification.EntityNotificationV2.OperationType.ENTITY_DELETE == v2Notification.getOperationType();
                this.isEntityCreateOp = EntityNotification.EntityNotificationV2.OperationType.ENTITY_CREATE == v2Notification.getOperationType();
                this.isEmptyClassifications = CollectionUtils.isEmpty((Collection)atlasEntity.getClassifications());
                List allClassifications = atlasEntity.getClassifications();
                if (CollectionUtils.isNotEmpty((Collection)allClassifications)) {
                    this.classifications = new ArrayList<RangerAtlasClassification>();
                    for (AtlasClassification classification : allClassifications) {
                        String classificationName = classification.getTypeName();
                        Map valuesMap = classification.getAttributes();
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        if (valuesMap != null) {
                            for (Map.Entry value : valuesMap.entrySet()) {
                                if (value.getValue() == null) continue;
                                attributes.put((String)value.getKey(), value.getValue().toString());
                            }
                        }
                        List<RangerValiditySchedule> validitySchedules = null;
                        List validityPeriods = classification.getValidityPeriods();
                        if (CollectionUtils.isNotEmpty((Collection)validityPeriods)) {
                            validitySchedules = EntityNotificationWrapper.convertTimeSpecFromAtlasToRanger(validityPeriods);
                        }
                        this.classifications.add(new RangerAtlasClassification(classificationName, attributes, validitySchedules));
                    }
                } else {
                    this.classifications = null;
                }
                EntityNotification.EntityNotificationV2.OperationType operationType = v2Notification.getOperationType();
                switch (operationType) {
                    case ENTITY_CREATE: {
                        this.opType = NotificationOpType.ENTITY_CREATE;
                        break block0;
                    }
                    case ENTITY_UPDATE: {
                        this.opType = NotificationOpType.ENTITY_UPDATE;
                        break block0;
                    }
                    case ENTITY_DELETE: {
                        this.opType = NotificationOpType.ENTITY_DELETE;
                        break block0;
                    }
                    case CLASSIFICATION_ADD: {
                        this.opType = NotificationOpType.CLASSIFICATION_ADD;
                        break block0;
                    }
                    case CLASSIFICATION_UPDATE: {
                        this.opType = NotificationOpType.CLASSIFICATION_UPDATE;
                        break block0;
                    }
                    case CLASSIFICATION_DELETE: {
                        this.opType = NotificationOpType.CLASSIFICATION_DELETE;
                        break block0;
                    }
                }
                LOG.error("Received OperationType [" + operationType + "], converting to UNKNOWN");
                this.opType = NotificationOpType.UNKNOWN;
                break;
            }
            case ENTITY_NOTIFICATION_V1: {
                EntityNotificationV1 v1Notification = (EntityNotificationV1)notification;
                Referenceable atlasEntity = v1Notification.getEntity();
                String guid = atlasEntity.getId()._getId();
                String typeName = atlasEntity.getTypeName();
                this.rangerAtlasEntity = new RangerAtlasEntity(typeName, guid, atlasEntity.getValues());
                this.entityTypeName = atlasEntity.getTypeName();
                this.isEntityActive = atlasEntity.getId().getState() == Id.EntityState.ACTIVE;
                this.isEntityTypeHandled = AtlasResourceMapperUtil.isEntityTypeHandled(this.entityTypeName);
                this.isEntityDeleteOp = EntityNotificationV1.OperationType.ENTITY_DELETE == v1Notification.getOperationType();
                this.isEntityCreateOp = EntityNotificationV1.OperationType.ENTITY_CREATE == v1Notification.getOperationType();
                this.isEmptyClassifications = CollectionUtils.isEmpty((Collection)v1Notification.getAllTraits());
                List allTraits = ((EntityNotificationV1)notification).getAllTraits();
                if (CollectionUtils.isNotEmpty((Collection)allTraits)) {
                    this.classifications = new ArrayList<RangerAtlasClassification>();
                    for (Struct trait : allTraits) {
                        String traitName = trait.getTypeName();
                        Map valuesMap = trait.getValuesMap();
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        if (valuesMap != null) {
                            for (Map.Entry value : valuesMap.entrySet()) {
                                if (value.getValue() == null) continue;
                                attributes.put((String)value.getKey(), value.getValue().toString());
                            }
                        }
                        this.classifications.add(new RangerAtlasClassification(traitName, attributes, null));
                    }
                } else {
                    this.classifications = null;
                }
                EntityNotificationV1.OperationType operationType = v1Notification.getOperationType();
                switch (operationType) {
                    case ENTITY_CREATE: {
                        this.opType = NotificationOpType.ENTITY_CREATE;
                        break block0;
                    }
                    case ENTITY_UPDATE: {
                        this.opType = NotificationOpType.ENTITY_UPDATE;
                        break block0;
                    }
                    case ENTITY_DELETE: {
                        this.opType = NotificationOpType.ENTITY_DELETE;
                        break block0;
                    }
                    case TRAIT_ADD: {
                        this.opType = NotificationOpType.CLASSIFICATION_ADD;
                        break block0;
                    }
                    case TRAIT_UPDATE: {
                        this.opType = NotificationOpType.CLASSIFICATION_UPDATE;
                        break block0;
                    }
                    case TRAIT_DELETE: {
                        this.opType = NotificationOpType.CLASSIFICATION_DELETE;
                        break block0;
                    }
                }
                LOG.error("Received OperationType [" + operationType + "], converting to UNKNOWN");
                this.opType = NotificationOpType.UNKNOWN;
                break;
            }
            default: {
                LOG.error("Unknown notification type - [" + notificationType + "]");
                this.rangerAtlasEntity = null;
                this.entityTypeName = null;
                this.isEntityActive = false;
                this.isEntityTypeHandled = false;
                this.isEntityDeleteOp = false;
                this.isEntityCreateOp = false;
                this.isEmptyClassifications = true;
                this.classifications = null;
                this.opType = NotificationOpType.UNKNOWN;
            }
        }
    }

    public RangerAtlasEntity getRangerAtlasEntity() {
        return this.rangerAtlasEntity;
    }

    public String getEntityTypeName() {
        return this.entityTypeName;
    }

    public boolean getIsEntityTypeHandled() {
        return this.isEntityTypeHandled;
    }

    public boolean getIsEntityDeleteOp() {
        return this.isEntityDeleteOp;
    }

    public boolean getIsEntityCreateOp() {
        return this.isEntityCreateOp;
    }

    public boolean getIsEmptyClassifications() {
        return this.isEmptyClassifications;
    }

    public List<RangerAtlasClassification> getClassifications() {
        return this.classifications;
    }

    public NotificationOpType getOpType() {
        return this.opType;
    }

    public boolean getIsEntityActive() {
        return this.isEntityActive;
    }

    public static List<RangerValiditySchedule> convertTimeSpecFromAtlasToRanger(List<TimeBoundary> atlasTimeSpec) {
        ArrayList<RangerValiditySchedule> rangerTimeSpec = null;
        if (CollectionUtils.isNotEmpty(atlasTimeSpec)) {
            rangerTimeSpec = new ArrayList<RangerValiditySchedule>();
            for (TimeBoundary validityPeriod : atlasTimeSpec) {
                RangerValiditySchedule validitySchedule = new RangerValiditySchedule();
                validitySchedule.setStartTime(validityPeriod.getStartTime());
                validitySchedule.setEndTime(validityPeriod.getEndTime());
                validitySchedule.setTimeZone(validityPeriod.getTimeZone());
                rangerTimeSpec.add(validitySchedule);
            }
        }
        return rangerTimeSpec;
    }

    public static class RangerAtlasClassification {
        private final String name;
        private final Map<String, String> attributes;
        private final List<RangerValiditySchedule> validityPeriods;

        public RangerAtlasClassification(String name, Map<String, String> attributes, List<RangerValiditySchedule> validityPeriods) {
            this.name = name;
            this.attributes = attributes;
            this.validityPeriods = validityPeriods;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public List<RangerValiditySchedule> getValidityPeriods() {
            return this.validityPeriods;
        }
    }

    public static enum NotificationOpType {
        UNKNOWN,
        ENTITY_CREATE,
        ENTITY_UPDATE,
        ENTITY_DELETE,
        CLASSIFICATION_ADD,
        CLASSIFICATION_UPDATE,
        CLASSIFICATION_DELETE;

    }
}

