/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.schema.registry.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.services.schema.registry.client.connection.DefaultSchemaRegistryClient;
import org.apache.ranger.services.schema.registry.client.connection.ISchemaRegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutocompletionAgent {
    private static final Logger LOG = LoggerFactory.getLogger(AutocompletionAgent.class);
    private ISchemaRegistryClient client;
    private String serviceName;
    private static final String errMessage = "You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check server logs for more info.";
    private static final String successMsg = "ConnectionTest Successful";

    public AutocompletionAgent(String serviceName, Map<String, String> configs) {
        this(serviceName, new DefaultSchemaRegistryClient(configs));
    }

    public AutocompletionAgent(String serviceName, ISchemaRegistryClient client) {
        this.serviceName = serviceName;
        this.client = client;
    }

    public HashMap<String, Object> connectionTest() {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        try {
            this.client.checkConnection();
            BaseClient.generateResponseDataMap((boolean)true, (String)successMsg, (String)successMsg, null, null, responseData);
            if (LOG.isDebugEnabled()) {
                LOG.debug("ConnectionTest Successful.");
            }
        }
        catch (Exception e) {
            LOG.error("Error connecting to SchemaRegistry. schemaRegistryClient=" + this, (Throwable)e);
            BaseClient.generateResponseDataMap((boolean)false, (String)errMessage, (String)errMessage, null, null, responseData);
        }
        return responseData;
    }

    public List<String> getSchemaGroupList(String lookupGroupName, List<String> groupList) {
        List<String> res = groupList;
        List<String> schemaGroups = this.client.getSchemaGroups();
        schemaGroups.forEach(gName -> {
            if (!res.contains(gName) && gName.contains(lookupGroupName)) {
                res.add((String)gName);
            }
        });
        return res;
    }

    public List<String> getSchemaMetadataList(String lookupSchemaMetadataName, List<String> schemaGroupList, List<String> schemaMetadataList) {
        List<String> res = schemaMetadataList;
        List<String> schemas = this.client.getSchemaNames(schemaGroupList);
        schemas.forEach(sName -> {
            if (!res.contains(sName) && sName.contains(lookupSchemaMetadataName)) {
                res.add((String)sName);
            }
        });
        return res;
    }

    public List<String> getBranchList(String lookupBranchName, List<String> groupList, List<String> schemaList, List<String> branchList) {
        List<String> res = branchList;
        List<String> expandedSchemaList = schemaList.stream().flatMap(schemaName -> this.expandSchemaMetadataNameRegex(groupList, (String)schemaName).stream()).collect(Collectors.toList());
        expandedSchemaList.forEach(schemaMetadataName -> {
            List<String> branches = this.client.getSchemaBranches((String)schemaMetadataName);
            branches.forEach(bName -> {
                if (!res.contains(bName) && bName.contains(lookupBranchName)) {
                    res.add((String)bName);
                }
            });
        });
        return res;
    }

    List<String> expandSchemaMetadataNameRegex(List<String> schemaGroupList, String lookupSchemaMetadataName) {
        ArrayList<String> res = new ArrayList<String>();
        List<String> schemas = this.client.getSchemaNames(schemaGroupList);
        schemas.forEach(sName -> {
            if (sName.matches(lookupSchemaMetadataName)) {
                res.add((String)sName);
            }
        });
        return res;
    }

    public String toString() {
        return "AutocompletionAgent [serviceName=" + this.serviceName + "]";
    }
}

