/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.eventhub.EventHub;
import com.microsoft.azure.management.eventhub.EventHubNamespace;
import com.microsoft.azure.management.eventhub.EventHubNamespaceAuthorizationRule;
import com.microsoft.azure.management.eventhub.EventHubNamespaceSkuType;
import com.microsoft.azure.management.eventhub.Sku;
import com.microsoft.azure.management.eventhub.SkuName;
import com.microsoft.azure.management.eventhub.implementation.EHNamespaceInner;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManager;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.dag.FunctionalTaskItem;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import org.joda.time.DateTime;
import rx.Observable;

@LangDefinition
class EventHubNamespaceImpl
extends GroupableResourceImpl<EventHubNamespace, EHNamespaceInner, EventHubNamespaceImpl, EventHubManager>
implements EventHubNamespace,
EventHubNamespace.Definition,
EventHubNamespace.Update {
    protected EventHubNamespaceImpl(String name, EHNamespaceInner innerObject, EventHubManager manager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
    }

    @Override
    public EventHubNamespaceSkuType sku() {
        return new EventHubNamespaceSkuType(((EHNamespaceInner)((Object)this.inner())).sku());
    }

    @Override
    public String azureInsightMetricId() {
        return ((EHNamespaceInner)((Object)this.inner())).metricId();
    }

    @Override
    public String serviceBusEndpoint() {
        return ((EHNamespaceInner)((Object)this.inner())).serviceBusEndpoint();
    }

    @Override
    public DateTime createdAt() {
        return ((EHNamespaceInner)((Object)this.inner())).createdAt();
    }

    @Override
    public DateTime updatedAt() {
        return ((EHNamespaceInner)((Object)this.inner())).updatedAt();
    }

    @Override
    public String provisioningState() {
        return ((EHNamespaceInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public boolean isAutoScaleEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((EHNamespaceInner)((Object)this.inner())).isAutoInflateEnabled());
    }

    @Override
    public int currentThroughputUnits() {
        return Utils.toPrimitiveInt((Integer)((EHNamespaceInner)((Object)this.inner())).sku().capacity());
    }

    @Override
    public int throughputUnitsUpperLimit() {
        return Utils.toPrimitiveInt((Integer)((EHNamespaceInner)((Object)this.inner())).maximumThroughputUnits());
    }

    @Override
    public EventHubNamespaceImpl withNewEventHub(final String eventHubName) {
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((EventHub.DefinitionStages.Blank)((EventHubManager)EventHubNamespaceImpl.this.manager()).eventHubs().define(eventHubName)).withExistingNamespace(EventHubNamespaceImpl.this.resourceGroupName(), EventHubNamespaceImpl.this.name()).createAsync();
            }
        });
        return this;
    }

    @Override
    public EventHubNamespaceImpl withNewEventHub(final String eventHubName, final int partitionCount) {
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((EventHub.DefinitionStages.Blank)((EventHubManager)EventHubNamespaceImpl.this.manager()).eventHubs().define(eventHubName)).withExistingNamespace(EventHubNamespaceImpl.this.resourceGroupName(), EventHubNamespaceImpl.this.name()).withPartitionCount(partitionCount).createAsync();
            }
        });
        return this;
    }

    @Override
    public EventHubNamespaceImpl withNewEventHub(final String eventHubName, final int partitionCount, final int retentionPeriodInDays) {
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((EventHub.DefinitionStages.Blank)((EventHubManager)EventHubNamespaceImpl.this.manager()).eventHubs().define(eventHubName)).withExistingNamespace(EventHubNamespaceImpl.this.resourceGroupName(), EventHubNamespaceImpl.this.name()).withPartitionCount(partitionCount).withRetentionPeriodInDays(retentionPeriodInDays).createAsync();
            }
        });
        return this;
    }

    @Override
    public EventHubNamespace.Update withoutEventHub(final String eventHubName) {
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((EventHubManager)EventHubNamespaceImpl.this.manager()).eventHubs().deleteByNameAsync(EventHubNamespaceImpl.this.resourceGroupName(), EventHubNamespaceImpl.this.name(), eventHubName).toObservable().concatWith(context.voidObservable());
            }
        });
        return this;
    }

    @Override
    public EventHubNamespaceImpl withNewSendRule(final String ruleName) {
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((EventHubNamespaceAuthorizationRule.DefinitionStages.WithCreate)((EventHubNamespaceAuthorizationRule.DefinitionStages.Blank)((EventHubManager)EventHubNamespaceImpl.this.manager()).namespaceAuthorizationRules().define(ruleName)).withExistingNamespace(EventHubNamespaceImpl.this.resourceGroupName(), EventHubNamespaceImpl.this.name()).withSendAccess()).createAsync();
            }
        });
        return this;
    }

    @Override
    public EventHubNamespaceImpl withNewListenRule(final String ruleName) {
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((EventHubNamespaceAuthorizationRule.DefinitionStages.WithCreate)((EventHubNamespaceAuthorizationRule.DefinitionStages.Blank)((EventHubManager)EventHubNamespaceImpl.this.manager()).namespaceAuthorizationRules().define(ruleName)).withExistingNamespace(EventHubNamespaceImpl.this.resourceGroupName(), EventHubNamespaceImpl.this.name()).withListenAccess()).createAsync();
            }
        });
        return this;
    }

    @Override
    public EventHubNamespaceImpl withNewManageRule(final String ruleName) {
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((EventHubNamespaceAuthorizationRule.DefinitionStages.WithCreate)((EventHubNamespaceAuthorizationRule.DefinitionStages.Blank)((EventHubManager)EventHubNamespaceImpl.this.manager()).namespaceAuthorizationRules().define(ruleName)).withExistingNamespace(EventHubNamespaceImpl.this.resourceGroupName(), EventHubNamespaceImpl.this.name()).withManageAccess()).createAsync();
            }
        });
        return this;
    }

    @Override
    public EventHubNamespaceImpl withoutAuthorizationRule(final String ruleName) {
        this.addPostRunDependent(new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context context) {
                return ((EventHubManager)EventHubNamespaceImpl.this.manager()).namespaceAuthorizationRules().deleteByNameAsync(EventHubNamespaceImpl.this.resourceGroupName(), EventHubNamespaceImpl.this.name(), ruleName).toObservable().concatWith(context.voidObservable());
            }
        });
        return this;
    }

    @Override
    public EventHubNamespaceImpl withAutoScaling() {
        this.setDefaultSkuIfNotSet();
        ((EHNamespaceInner)((Object)this.inner())).withIsAutoInflateEnabled(true);
        if (((EHNamespaceInner)((Object)this.inner())).maximumThroughputUnits() == null) {
            this.withThroughputUnitsUpperLimit(20);
        }
        return this;
    }

    @Override
    public EventHubNamespaceImpl withSku(EventHubNamespaceSkuType namespaceSku) {
        boolean isDifferent;
        Sku newSkuInner = new Sku().withName(namespaceSku.name()).withTier(namespaceSku.tier()).withCapacity(null);
        Sku currentSkuInner = ((EHNamespaceInner)((Object)this.inner())).sku();
        boolean bl = isDifferent = currentSkuInner == null || !currentSkuInner.name().equals((Object)newSkuInner.name());
        if (isDifferent) {
            ((EHNamespaceInner)((Object)this.inner())).withSku(newSkuInner);
            if (newSkuInner.name().equals((Object)SkuName.STANDARD)) {
                newSkuInner.withCapacity(1);
            }
        }
        return this;
    }

    @Override
    public EventHubNamespaceImpl withCurrentThroughputUnits(int units) {
        this.setDefaultSkuIfNotSet();
        ((EHNamespaceInner)((Object)this.inner())).sku().withCapacity(units);
        return this;
    }

    @Override
    public EventHubNamespaceImpl withThroughputUnitsUpperLimit(int units) {
        ((EHNamespaceInner)((Object)this.inner())).withMaximumThroughputUnits(units);
        return this;
    }

    public Observable<EventHubNamespace> createResourceAsync() {
        return ((EventHubManagementClientImpl)((Object)((EventHubManager)this.manager()).inner())).namespaces().createOrUpdateAsync(this.resourceGroupName(), this.name(), (EHNamespaceInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    @Override
    public Observable<EventHub> listEventHubsAsync() {
        return ((EventHubManager)this.manager()).eventHubs().listByNamespaceAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public Observable<EventHubNamespaceAuthorizationRule> listAuthorizationRulesAsync() {
        return ((EventHubManager)this.manager()).namespaceAuthorizationRules().listByNamespaceAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public PagedList<EventHub> listEventHubs() {
        return ((EventHubManager)this.manager()).eventHubs().listByNamespace(this.resourceGroupName(), this.name());
    }

    @Override
    public PagedList<EventHubNamespaceAuthorizationRule> listAuthorizationRules() {
        return ((EventHubManager)this.manager()).namespaceAuthorizationRules().listByNamespace(this.resourceGroupName(), this.name());
    }

    protected Observable<EHNamespaceInner> getInnerAsync() {
        return ((EventHubManagementClientImpl)((Object)((EventHubManager)this.manager()).inner())).namespaces().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private void setDefaultSkuIfNotSet() {
        if (((EHNamespaceInner)((Object)this.inner())).sku() == null) {
            this.withSku(EventHubNamespaceSkuType.STANDARD);
        }
    }
}

