/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.search.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableParentResourceImpl;
import com.microsoft.azure.management.search.AdminKeyKind;
import com.microsoft.azure.management.search.AdminKeys;
import com.microsoft.azure.management.search.HostingMode;
import com.microsoft.azure.management.search.ProvisioningState;
import com.microsoft.azure.management.search.QueryKey;
import com.microsoft.azure.management.search.SearchService;
import com.microsoft.azure.management.search.SearchServiceStatus;
import com.microsoft.azure.management.search.Sku;
import com.microsoft.azure.management.search.SkuName;
import com.microsoft.azure.management.search.implementation.AdminKeyResultInner;
import com.microsoft.azure.management.search.implementation.AdminKeysImpl;
import com.microsoft.azure.management.search.implementation.QueryKeyImpl;
import com.microsoft.azure.management.search.implementation.QueryKeyInner;
import com.microsoft.azure.management.search.implementation.SearchManagementClientImpl;
import com.microsoft.azure.management.search.implementation.SearchServiceInner;
import com.microsoft.azure.management.search.implementation.SearchServiceManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class SearchServiceImpl
extends GroupableParentResourceImpl<SearchService, SearchServiceInner, SearchServiceImpl, SearchServiceManager>
implements SearchService,
SearchService.Definition,
SearchService.Update {
    SearchServiceImpl(String name, SearchServiceInner innerModel, SearchServiceManager searchManager) {
        super(name, (Resource)innerModel, (ManagerBase)searchManager);
    }

    protected void initializeChildrenFromInner() {
    }

    public Observable<SearchService> refreshAsync() {
        return super.refreshAsync().map((Func1)new Func1<SearchService, SearchService>(){

            public SearchService call(SearchService foo) {
                SearchServiceImpl impl = (SearchServiceImpl)foo;
                impl.initializeChildrenFromInner();
                return impl;
            }
        });
    }

    protected Observable<SearchServiceInner> getInnerAsync() {
        return ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).services().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    protected void beforeCreating() {
        if (this.isInCreateMode()) {
            // empty if block
        }
    }

    protected void afterCreating() {
        this.initializeChildrenFromInner();
    }

    protected Observable<SearchServiceInner> createInner() {
        return ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).services().createOrUpdateAsync(this.resourceGroupName(), this.name(), (SearchServiceInner)((Object)this.inner()));
    }

    @Override
    public SearchServiceStatus status() {
        return ((SearchServiceInner)((Object)this.inner())).status();
    }

    @Override
    public String statusDetails() {
        return ((SearchServiceInner)((Object)this.inner())).statusDetails();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((SearchServiceInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public HostingMode hostingMode() {
        return ((SearchServiceInner)((Object)this.inner())).hostingMode();
    }

    @Override
    public Sku sku() {
        return ((SearchServiceInner)((Object)this.inner())).sku();
    }

    @Override
    public int replicaCount() {
        return ((SearchServiceInner)((Object)this.inner())).replicaCount();
    }

    @Override
    public int partitionCount() {
        return ((SearchServiceInner)((Object)this.inner())).partitionCount();
    }

    @Override
    public AdminKeysImpl getAdminKeys() {
        return new AdminKeysImpl(((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).adminKeys().get(this.resourceGroupName(), this.name()));
    }

    @Override
    public Observable<AdminKeys> getAdminKeysAsync() {
        return ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).adminKeys().getAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<AdminKeyResultInner, AdminKeys>(){

            public AdminKeys call(AdminKeyResultInner adminKeyResultInner) {
                return new AdminKeysImpl(adminKeyResultInner);
            }
        });
    }

    @Override
    public List<QueryKey> listQueryKeys() {
        ArrayList<QueryKeyImpl> queryKeys = new ArrayList<QueryKeyImpl>();
        List<QueryKeyInner> queryKeyInners = ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).queryKeys().listBySearchService(this.resourceGroupName(), this.name());
        if (queryKeyInners != null) {
            for (QueryKeyInner queryKeyInner : queryKeyInners) {
                queryKeys.add(new QueryKeyImpl(queryKeyInner));
            }
        }
        return Collections.unmodifiableList(queryKeys);
    }

    @Override
    public Observable<QueryKey> listQueryKeysAsync() {
        Observable<List<QueryKeyInner>> queryKeysList = ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).queryKeys().listBySearchServiceAsync(this.resourceGroupName(), this.name());
        return queryKeysList.flatMap((Func1)new Func1<List<QueryKeyInner>, Observable<QueryKeyInner>>(){

            public Observable<QueryKeyInner> call(List<QueryKeyInner> queryKeyInners) {
                return Observable.from(queryKeyInners);
            }
        }).map((Func1)new Func1<QueryKeyInner, QueryKey>(){

            public QueryKey call(QueryKeyInner queryKeyInner) {
                return new QueryKeyImpl(queryKeyInner);
            }
        });
    }

    @Override
    public AdminKeys regenerateAdminKeys(AdminKeyKind keyKind) {
        return new AdminKeysImpl(((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).adminKeys().regenerate(this.resourceGroupName(), this.name(), keyKind));
    }

    @Override
    public Observable<AdminKeys> regenerateAdminKeysAsync(AdminKeyKind keyKind) {
        return ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).adminKeys().regenerateAsync(this.resourceGroupName(), this.name(), keyKind).map((Func1)new Func1<AdminKeyResultInner, AdminKeys>(){

            public AdminKeys call(AdminKeyResultInner adminKeyResultInner) {
                return new AdminKeysImpl(adminKeyResultInner);
            }
        });
    }

    @Override
    public QueryKey createQueryKey(String name) {
        return new QueryKeyImpl(((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).queryKeys().create(this.resourceGroupName(), this.name(), name));
    }

    @Override
    public Observable<QueryKey> createQueryKeyAsync(String name) {
        return ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).queryKeys().createAsync(this.resourceGroupName(), this.name(), name).map((Func1)new Func1<QueryKeyInner, QueryKey>(){

            public QueryKey call(QueryKeyInner queryKeyInner) {
                return new QueryKeyImpl(queryKeyInner);
            }
        });
    }

    @Override
    public void deleteQueryKey(String key) {
        ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).queryKeys().delete(this.resourceGroupName(), this.name(), key);
    }

    @Override
    public Completable deleteQueryKeyAsync(String key) {
        return ((SearchManagementClientImpl)((Object)((SearchServiceManager)this.manager()).inner())).queryKeys().deleteAsync(this.resourceGroupName(), this.name(), key).toCompletable();
    }

    @Override
    public SearchServiceImpl withSku(SkuName skuName) {
        ((SearchServiceInner)((Object)this.inner())).withSku(new Sku().withName(skuName));
        return this;
    }

    @Override
    public SearchServiceImpl withFreeSku() {
        ((SearchServiceInner)((Object)this.inner())).withSku(new Sku().withName(SkuName.FREE));
        return this;
    }

    @Override
    public SearchServiceImpl withBasicSku() {
        ((SearchServiceInner)((Object)this.inner())).withSku(new Sku().withName(SkuName.BASIC));
        return this;
    }

    @Override
    public SearchServiceImpl withStandardSku() {
        ((SearchServiceInner)((Object)this.inner())).withSku(new Sku().withName(SkuName.STANDARD));
        return this;
    }

    @Override
    public SearchServiceImpl withReplicaCount(int replicaCount) {
        ((SearchServiceInner)((Object)this.inner())).withReplicaCount(replicaCount);
        return this;
    }

    @Override
    public SearchServiceImpl withPartitionCount(int partitionCount) {
        ((SearchServiceInner)((Object)this.inner())).withPartitionCount(partitionCount);
        return this;
    }
}

