/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.trafficmanager.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.trafficmanager.implementation.EndpointsInner;
import com.microsoft.azure.management.trafficmanager.implementation.GeographicHierarchiesInner;
import com.microsoft.azure.management.trafficmanager.implementation.HeatMapsInner;
import com.microsoft.azure.management.trafficmanager.implementation.ProfilesInner;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerUserMetricsKeysInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class TrafficManagerManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private EndpointsInner endpoints;
    private ProfilesInner profiles;
    private GeographicHierarchiesInner geographicHierarchies;
    private HeatMapsInner heatMaps;
    private TrafficManagerUserMetricsKeysInner trafficManagerUserMetricsKeys;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public TrafficManagerManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public TrafficManagerManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public TrafficManagerManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public TrafficManagerManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public EndpointsInner endpoints() {
        return this.endpoints;
    }

    public ProfilesInner profiles() {
        return this.profiles;
    }

    public GeographicHierarchiesInner geographicHierarchies() {
        return this.geographicHierarchies;
    }

    public HeatMapsInner heatMaps() {
        return this.heatMaps;
    }

    public TrafficManagerUserMetricsKeysInner trafficManagerUserMetricsKeys() {
        return this.trafficManagerUserMetricsKeys;
    }

    public TrafficManagerManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public TrafficManagerManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public TrafficManagerManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2018-04-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.endpoints = new EndpointsInner(this.restClient().retrofit(), this);
        this.profiles = new ProfilesInner(this.restClient().retrofit(), this);
        this.geographicHierarchies = new GeographicHierarchiesInner(this.restClient().retrofit(), this);
        this.heatMaps = new HeatMapsInner(this.restClient().retrofit(), this);
        this.trafficManagerUserMetricsKeys = new TrafficManagerUserMetricsKeysInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "TrafficManagerManagementClient", "2018-04-01");
    }
}

