/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.AddressSpace;
import com.microsoft.azure.management.network.PointToSiteConfiguration;
import com.microsoft.azure.management.network.VirtualNetworkGateway;
import com.microsoft.azure.management.network.VpnClientConfiguration;
import com.microsoft.azure.management.network.VpnClientProtocol;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayImpl;
import com.microsoft.azure.management.network.implementation.VpnClientRevokedCertificateInner;
import com.microsoft.azure.management.network.implementation.VpnClientRootCertificateInner;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;

@LangDefinition
class PointToSiteConfigurationImpl
extends IndexableWrapperImpl<VpnClientConfiguration>
implements PointToSiteConfiguration,
PointToSiteConfiguration.Definition<VirtualNetworkGateway.Update>,
PointToSiteConfiguration.Update {
    private static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    private static final String END_CERT = "-----END CERTIFICATE-----";
    private VirtualNetworkGatewayImpl parent;

    PointToSiteConfigurationImpl(VpnClientConfiguration inner, VirtualNetworkGatewayImpl parent) {
        super((Object)inner);
        this.parent = parent;
    }

    public VirtualNetworkGatewayImpl attach() {
        this.parent.attachPointToSiteConfiguration(this);
        return this.parent;
    }

    @Override
    public PointToSiteConfigurationImpl withAddressPool(String addressPool) {
        ArrayList<String> addressPrefixes = new ArrayList<String>();
        addressPrefixes.add(addressPool);
        ((VpnClientConfiguration)this.inner()).withVpnClientAddressPool(new AddressSpace().withAddressPrefixes(addressPrefixes));
        return this;
    }

    @Override
    public PointToSiteConfigurationImpl withAzureCertificate(String name, String certificateData) {
        if (((VpnClientConfiguration)this.inner()).vpnClientRootCertificates() == null) {
            ((VpnClientConfiguration)this.inner()).withVpnClientRootCertificates(new ArrayList<VpnClientRootCertificateInner>());
        }
        ((VpnClientConfiguration)this.inner()).vpnClientRootCertificates().add(new VpnClientRootCertificateInner().withName(name).withPublicCertData(certificateData));
        ((VpnClientConfiguration)this.inner()).withRadiusServerAddress(null).withRadiusServerSecret(null);
        return this;
    }

    @Override
    public PointToSiteConfigurationImpl withAzureCertificateFromFile(String name, File certificateFile) throws IOException {
        if (certificateFile == null) {
            return this;
        }
        byte[] content = Files.readAllBytes(certificateFile.toPath());
        String certificate = new String(content).replace(BEGIN_CERT, "").replace(END_CERT, "");
        return this.withAzureCertificate(name, certificate);
    }

    @Override
    public PointToSiteConfiguration.Update withoutAzureCertificate(String name) {
        if (((VpnClientConfiguration)this.inner()).vpnClientRootCertificates() != null) {
            for (VpnClientRootCertificateInner certificateInner : ((VpnClientConfiguration)this.inner()).vpnClientRootCertificates()) {
                if (!name.equals(certificateInner.name())) continue;
                ((VpnClientConfiguration)this.inner()).vpnClientRootCertificates().remove((Object)certificateInner);
                break;
            }
        }
        return this;
    }

    @Override
    public PointToSiteConfigurationImpl withRadiusAuthentication(String serverIPAddress, String serverSecret) {
        ((VpnClientConfiguration)this.inner()).withRadiusServerAddress(serverIPAddress).withRadiusServerSecret(serverSecret);
        ((VpnClientConfiguration)this.inner()).withVpnClientRootCertificates(null);
        ((VpnClientConfiguration)this.inner()).withVpnClientRevokedCertificates(null);
        return this;
    }

    @Override
    public PointToSiteConfigurationImpl withRevokedCertificate(String name, String thumbprint) {
        if (((VpnClientConfiguration)this.inner()).vpnClientRevokedCertificates() == null) {
            ((VpnClientConfiguration)this.inner()).withVpnClientRevokedCertificates(new ArrayList<VpnClientRevokedCertificateInner>());
        }
        ((VpnClientConfiguration)this.inner()).vpnClientRevokedCertificates().add(new VpnClientRevokedCertificateInner().withName(name).withThumbprint(thumbprint));
        ((VpnClientConfiguration)this.inner()).withRadiusServerAddress(null).withRadiusServerSecret(null);
        return this;
    }

    @Override
    public PointToSiteConfigurationImpl withSstpOnly() {
        ((VpnClientConfiguration)this.inner()).withVpnClientProtocols(Collections.singletonList(VpnClientProtocol.SSTP));
        return this;
    }

    @Override
    public PointToSiteConfigurationImpl withIkeV2Only() {
        ((VpnClientConfiguration)this.inner()).withVpnClientProtocols(Collections.singletonList(VpnClientProtocol.IKE_V2));
        return this;
    }

    public VirtualNetworkGateway.Update parent() {
        return this.parent;
    }
}

