/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.VpnClientParameters;
import com.microsoft.azure.management.network.VpnDeviceScriptParameters;
import com.microsoft.azure.management.network.implementation.BgpPeerStatusListResultInner;
import com.microsoft.azure.management.network.implementation.GatewayRouteListResultInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayConnectionListEntityInner;
import com.microsoft.azure.management.network.implementation.VirtualNetworkGatewayInner;
import com.microsoft.azure.management.network.implementation.VpnClientIPsecParametersInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VirtualNetworkGatewaysInner
implements InnerSupportsGet<VirtualNetworkGatewayInner>,
InnerSupportsDelete<Void> {
    private VirtualNetworkGatewaysService service;
    private NetworkManagementClientImpl client;

    public VirtualNetworkGatewaysInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VirtualNetworkGatewaysService)retrofit.create(VirtualNetworkGatewaysService.class);
        this.client = client;
    }

    public VirtualNetworkGatewayInner createOrUpdate(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGatewayInner parameters) {
        return (VirtualNetworkGatewayInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualNetworkGatewayInner> createOrUpdateAsync(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGatewayInner parameters, ServiceCallback<VirtualNetworkGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters), serviceCallback);
    }

    public Observable<VirtualNetworkGatewayInner> createOrUpdateAsync(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGatewayInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters).map((Func1)new Func1<ServiceResponse<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner>(){

            public VirtualNetworkGatewayInner call(ServiceResponse<VirtualNetworkGatewayInner> response) {
                return (VirtualNetworkGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkGatewayInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGatewayInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), parameters, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualNetworkGatewayInner>(){}.getType());
    }

    public VirtualNetworkGatewayInner beginCreateOrUpdate(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGatewayInner parameters) {
        return (VirtualNetworkGatewayInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualNetworkGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGatewayInner parameters, ServiceCallback<VirtualNetworkGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters), serviceCallback);
    }

    public Observable<VirtualNetworkGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGatewayInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters).map((Func1)new Func1<ServiceResponse<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner>(){

            public VirtualNetworkGatewayInner call(ServiceResponse<VirtualNetworkGatewayInner> response) {
                return (VirtualNetworkGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkGatewayInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGatewayInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2018-06-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), parameters, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkGatewayInner>>>(){

            public Observable<ServiceResponse<VirtualNetworkGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualNetworkGatewayInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualNetworkGatewayInner>(){}.getType()).register(201, new TypeToken<VirtualNetworkGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualNetworkGatewayInner getByResourceGroup(String resourceGroupName, String virtualNetworkGatewayName) {
        return (VirtualNetworkGatewayInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualNetworkGatewayInner> getByResourceGroupAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<VirtualNetworkGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<VirtualNetworkGatewayInner> getByResourceGroupAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner>(){

            public VirtualNetworkGatewayInner call(ServiceResponse<VirtualNetworkGatewayInner> response) {
                return (VirtualNetworkGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkGatewayInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.getByResourceGroup(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkGatewayInner>>>(){

            public Observable<ServiceResponse<VirtualNetworkGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualNetworkGatewayInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualNetworkGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String virtualNetworkGatewayName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String virtualNetworkGatewayName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.beginDelete(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualNetworkGatewayInner updateTags(String resourceGroupName, String virtualNetworkGatewayName) {
        return (VirtualNetworkGatewayInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualNetworkGatewayInner> updateTagsAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<VirtualNetworkGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<VirtualNetworkGatewayInner> updateTagsAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner>(){

            public VirtualNetworkGatewayInner call(ServiceResponse<VirtualNetworkGatewayInner> response) {
                return (VirtualNetworkGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkGatewayInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualNetworkGatewayInner>(){}.getType());
    }

    public VirtualNetworkGatewayInner updateTags(String resourceGroupName, String virtualNetworkGatewayName, Map<String, String> tags) {
        return (VirtualNetworkGatewayInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualNetworkGatewayInner> updateTagsAsync(String resourceGroupName, String virtualNetworkGatewayName, Map<String, String> tags, ServiceCallback<VirtualNetworkGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, tags), serviceCallback);
    }

    public Observable<VirtualNetworkGatewayInner> updateTagsAsync(String resourceGroupName, String virtualNetworkGatewayName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, tags).map((Func1)new Func1<ServiceResponse<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner>(){

            public VirtualNetworkGatewayInner call(ServiceResponse<VirtualNetworkGatewayInner> response) {
                return (VirtualNetworkGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkGatewayInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2018-06-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.updateTags(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualNetworkGatewayInner>(){}.getType());
    }

    public VirtualNetworkGatewayInner beginUpdateTags(String resourceGroupName, String virtualNetworkGatewayName) {
        return (VirtualNetworkGatewayInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualNetworkGatewayInner> beginUpdateTagsAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<VirtualNetworkGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<VirtualNetworkGatewayInner> beginUpdateTagsAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner>(){

            public VirtualNetworkGatewayInner call(ServiceResponse<VirtualNetworkGatewayInner> response) {
                return (VirtualNetworkGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkGatewayInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Object tags = null;
        TagsObject parameters = new TagsObject();
        parameters.withTags(null);
        return this.service.beginUpdateTags(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkGatewayInner>>>(){

            public Observable<ServiceResponse<VirtualNetworkGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public VirtualNetworkGatewayInner beginUpdateTags(String resourceGroupName, String virtualNetworkGatewayName, Map<String, String> tags) {
        return (VirtualNetworkGatewayInner)((Object)((ServiceResponse)this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualNetworkGatewayInner> beginUpdateTagsAsync(String resourceGroupName, String virtualNetworkGatewayName, Map<String, String> tags, ServiceCallback<VirtualNetworkGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, tags), serviceCallback);
    }

    public Observable<VirtualNetworkGatewayInner> beginUpdateTagsAsync(String resourceGroupName, String virtualNetworkGatewayName, Map<String, String> tags) {
        return this.beginUpdateTagsWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, tags).map((Func1)new Func1<ServiceResponse<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner>(){

            public VirtualNetworkGatewayInner call(ServiceResponse<VirtualNetworkGatewayInner> response) {
                return (VirtualNetworkGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkGatewayInner>> beginUpdateTagsWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2018-06-01";
        TagsObject parameters = new TagsObject();
        parameters.withTags(tags);
        return this.service.beginUpdateTags(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkGatewayInner>>>(){

            public Observable<ServiceResponse<VirtualNetworkGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.beginUpdateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualNetworkGatewayInner> beginUpdateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualNetworkGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualNetworkGatewayInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VirtualNetworkGatewayInner>((Page)response.body()){

            public Page<VirtualNetworkGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualNetworkGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualNetworkGatewayInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<VirtualNetworkGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>> call(String nextPageLink) {
                return VirtualNetworkGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualNetworkGatewayInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<VirtualNetworkGatewayInner>>, Page<VirtualNetworkGatewayInner>>(){

            public Page<VirtualNetworkGatewayInner> call(ServiceResponse<Page<VirtualNetworkGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualNetworkGatewayInner>>, Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>> call(ServiceResponse<Page<VirtualNetworkGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualNetworkGatewaysInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualNetworkGatewaysInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualNetworkGatewayInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualNetworkGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualNetworkGatewayConnectionListEntityInner> listConnections(String resourceGroupName, String virtualNetworkGatewayName) {
        ServiceResponse response = (ServiceResponse)this.listConnectionsSinglePageAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().single();
        return new PagedList<VirtualNetworkGatewayConnectionListEntityInner>((Page)response.body()){

            public Page<VirtualNetworkGatewayConnectionListEntityInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualNetworkGatewaysInner.this.listConnectionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualNetworkGatewayConnectionListEntityInner>> listConnectionsAsync(String resourceGroupName, String virtualNetworkGatewayName, ListOperationCallback<VirtualNetworkGatewayConnectionListEntityInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listConnectionsSinglePageAsync(resourceGroupName, virtualNetworkGatewayName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>> call(String nextPageLink) {
                return VirtualNetworkGatewaysInner.this.listConnectionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualNetworkGatewayConnectionListEntityInner>> listConnectionsAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.listConnectionsWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>, Page<VirtualNetworkGatewayConnectionListEntityInner>>(){

            public Page<VirtualNetworkGatewayConnectionListEntityInner> call(ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>> listConnectionsWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.listConnectionsSinglePageAsync(resourceGroupName, virtualNetworkGatewayName).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>, Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>> call(ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualNetworkGatewaysInner.this.listConnectionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>> listConnectionsSinglePageAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.listConnections(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualNetworkGatewaysInner.this.listConnectionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualNetworkGatewayConnectionListEntityInner>> listConnectionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualNetworkGatewayConnectionListEntityInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualNetworkGatewayInner reset(String resourceGroupName, String virtualNetworkGatewayName) {
        return (VirtualNetworkGatewayInner)((Object)((ServiceResponse)this.resetWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualNetworkGatewayInner> resetAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<VirtualNetworkGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.resetWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<VirtualNetworkGatewayInner> resetAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.resetWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner>(){

            public VirtualNetworkGatewayInner call(ServiceResponse<VirtualNetworkGatewayInner> response) {
                return (VirtualNetworkGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkGatewayInner>> resetWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        String gatewayVip = null;
        Observable<Response<ResponseBody>> observable = this.service.reset(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), gatewayVip, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<VirtualNetworkGatewayInner>(){}.getType());
    }

    public VirtualNetworkGatewayInner reset(String resourceGroupName, String virtualNetworkGatewayName, String gatewayVip) {
        return (VirtualNetworkGatewayInner)((Object)((ServiceResponse)this.resetWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, gatewayVip).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualNetworkGatewayInner> resetAsync(String resourceGroupName, String virtualNetworkGatewayName, String gatewayVip, ServiceCallback<VirtualNetworkGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.resetWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, gatewayVip), serviceCallback);
    }

    public Observable<VirtualNetworkGatewayInner> resetAsync(String resourceGroupName, String virtualNetworkGatewayName, String gatewayVip) {
        return this.resetWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, gatewayVip).map((Func1)new Func1<ServiceResponse<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner>(){

            public VirtualNetworkGatewayInner call(ServiceResponse<VirtualNetworkGatewayInner> response) {
                return (VirtualNetworkGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkGatewayInner>> resetWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, String gatewayVip) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.reset(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), gatewayVip, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<VirtualNetworkGatewayInner>(){}.getType());
    }

    public VirtualNetworkGatewayInner beginReset(String resourceGroupName, String virtualNetworkGatewayName) {
        return (VirtualNetworkGatewayInner)((Object)((ServiceResponse)this.beginResetWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualNetworkGatewayInner> beginResetAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<VirtualNetworkGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginResetWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<VirtualNetworkGatewayInner> beginResetAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.beginResetWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner>(){

            public VirtualNetworkGatewayInner call(ServiceResponse<VirtualNetworkGatewayInner> response) {
                return (VirtualNetworkGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkGatewayInner>> beginResetWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        String gatewayVip = null;
        return this.service.beginReset(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), gatewayVip, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkGatewayInner>>>(){

            public Observable<ServiceResponse<VirtualNetworkGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.beginResetDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public VirtualNetworkGatewayInner beginReset(String resourceGroupName, String virtualNetworkGatewayName, String gatewayVip) {
        return (VirtualNetworkGatewayInner)((Object)((ServiceResponse)this.beginResetWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, gatewayVip).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualNetworkGatewayInner> beginResetAsync(String resourceGroupName, String virtualNetworkGatewayName, String gatewayVip, ServiceCallback<VirtualNetworkGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginResetWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, gatewayVip), serviceCallback);
    }

    public Observable<VirtualNetworkGatewayInner> beginResetAsync(String resourceGroupName, String virtualNetworkGatewayName, String gatewayVip) {
        return this.beginResetWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, gatewayVip).map((Func1)new Func1<ServiceResponse<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner>(){

            public VirtualNetworkGatewayInner call(ServiceResponse<VirtualNetworkGatewayInner> response) {
                return (VirtualNetworkGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualNetworkGatewayInner>> beginResetWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, String gatewayVip) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.beginReset(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), gatewayVip, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualNetworkGatewayInner>>>(){

            public Observable<ServiceResponse<VirtualNetworkGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.beginResetDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualNetworkGatewayInner> beginResetDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualNetworkGatewayInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public String generatevpnclientpackage(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters) {
        return (String)((ServiceResponse)this.generatevpnclientpackageWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<String> generatevpnclientpackageAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters, ServiceCallback<String> serviceCallback) {
        return ServiceFuture.fromResponse(this.generatevpnclientpackageWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters), serviceCallback);
    }

    public Observable<String> generatevpnclientpackageAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters) {
        return this.generatevpnclientpackageWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters).map((Func1)new Func1<ServiceResponse<String>, String>(){

            public String call(ServiceResponse<String> response) {
                return (String)response.body();
            }
        });
    }

    public Observable<ServiceResponse<String>> generatevpnclientpackageWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.generatevpnclientpackage(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), parameters, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<String>(){}.getType());
    }

    public String beginGeneratevpnclientpackage(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters) {
        return (String)((ServiceResponse)this.beginGeneratevpnclientpackageWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<String> beginGeneratevpnclientpackageAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters, ServiceCallback<String> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGeneratevpnclientpackageWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters), serviceCallback);
    }

    public Observable<String> beginGeneratevpnclientpackageAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters) {
        return this.beginGeneratevpnclientpackageWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters).map((Func1)new Func1<ServiceResponse<String>, String>(){

            public String call(ServiceResponse<String> response) {
                return (String)response.body();
            }
        });
    }

    public Observable<ServiceResponse<String>> beginGeneratevpnclientpackageWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-06-01";
        return this.service.beginGeneratevpnclientpackage(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), parameters, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<String>>>(){

            public Observable<ServiceResponse<String>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.beginGeneratevpnclientpackageDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<String> beginGeneratevpnclientpackageDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<String>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public String generateVpnProfile(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters) {
        return (String)((ServiceResponse)this.generateVpnProfileWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<String> generateVpnProfileAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters, ServiceCallback<String> serviceCallback) {
        return ServiceFuture.fromResponse(this.generateVpnProfileWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters), serviceCallback);
    }

    public Observable<String> generateVpnProfileAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters) {
        return this.generateVpnProfileWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters).map((Func1)new Func1<ServiceResponse<String>, String>(){

            public String call(ServiceResponse<String> response) {
                return (String)response.body();
            }
        });
    }

    public Observable<ServiceResponse<String>> generateVpnProfileWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.generateVpnProfile(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), parameters, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<String>(){}.getType());
    }

    public String beginGenerateVpnProfile(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters) {
        return (String)((ServiceResponse)this.beginGenerateVpnProfileWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<String> beginGenerateVpnProfileAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters, ServiceCallback<String> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGenerateVpnProfileWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters), serviceCallback);
    }

    public Observable<String> beginGenerateVpnProfileAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters) {
        return this.beginGenerateVpnProfileWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, parameters).map((Func1)new Func1<ServiceResponse<String>, String>(){

            public String call(ServiceResponse<String> response) {
                return (String)response.body();
            }
        });
    }

    public Observable<ServiceResponse<String>> beginGenerateVpnProfileWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-06-01";
        return this.service.beginGenerateVpnProfile(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), parameters, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<String>>>(){

            public Observable<ServiceResponse<String>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.beginGenerateVpnProfileDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<String> beginGenerateVpnProfileDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<String>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public String getVpnProfilePackageUrl(String resourceGroupName, String virtualNetworkGatewayName) {
        return (String)((ServiceResponse)this.getVpnProfilePackageUrlWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().last()).body();
    }

    public ServiceFuture<String> getVpnProfilePackageUrlAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<String> serviceCallback) {
        return ServiceFuture.fromResponse(this.getVpnProfilePackageUrlWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<String> getVpnProfilePackageUrlAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.getVpnProfilePackageUrlWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<String>, String>(){

            public String call(ServiceResponse<String> response) {
                return (String)response.body();
            }
        });
    }

    public Observable<ServiceResponse<String>> getVpnProfilePackageUrlWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.getVpnProfilePackageUrl(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<String>(){}.getType());
    }

    public String beginGetVpnProfilePackageUrl(String resourceGroupName, String virtualNetworkGatewayName) {
        return (String)((ServiceResponse)this.beginGetVpnProfilePackageUrlWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<String> beginGetVpnProfilePackageUrlAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<String> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGetVpnProfilePackageUrlWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<String> beginGetVpnProfilePackageUrlAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.beginGetVpnProfilePackageUrlWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<String>, String>(){

            public String call(ServiceResponse<String> response) {
                return (String)response.body();
            }
        });
    }

    public Observable<ServiceResponse<String>> beginGetVpnProfilePackageUrlWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.beginGetVpnProfilePackageUrl(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<String>>>(){

            public Observable<ServiceResponse<String>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.beginGetVpnProfilePackageUrlDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<String> beginGetVpnProfilePackageUrlDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<String>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BgpPeerStatusListResultInner getBgpPeerStatus(String resourceGroupName, String virtualNetworkGatewayName) {
        return (BgpPeerStatusListResultInner)((ServiceResponse)this.getBgpPeerStatusWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().last()).body();
    }

    public ServiceFuture<BgpPeerStatusListResultInner> getBgpPeerStatusAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<BgpPeerStatusListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getBgpPeerStatusWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<BgpPeerStatusListResultInner> getBgpPeerStatusAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.getBgpPeerStatusWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<BgpPeerStatusListResultInner>, BgpPeerStatusListResultInner>(){

            public BgpPeerStatusListResultInner call(ServiceResponse<BgpPeerStatusListResultInner> response) {
                return (BgpPeerStatusListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BgpPeerStatusListResultInner>> getBgpPeerStatusWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        String peer = null;
        Observable<Response<ResponseBody>> observable = this.service.getBgpPeerStatus(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), peer, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<BgpPeerStatusListResultInner>(){}.getType());
    }

    public BgpPeerStatusListResultInner getBgpPeerStatus(String resourceGroupName, String virtualNetworkGatewayName, String peer) {
        return (BgpPeerStatusListResultInner)((ServiceResponse)this.getBgpPeerStatusWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, peer).toBlocking().last()).body();
    }

    public ServiceFuture<BgpPeerStatusListResultInner> getBgpPeerStatusAsync(String resourceGroupName, String virtualNetworkGatewayName, String peer, ServiceCallback<BgpPeerStatusListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getBgpPeerStatusWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, peer), serviceCallback);
    }

    public Observable<BgpPeerStatusListResultInner> getBgpPeerStatusAsync(String resourceGroupName, String virtualNetworkGatewayName, String peer) {
        return this.getBgpPeerStatusWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, peer).map((Func1)new Func1<ServiceResponse<BgpPeerStatusListResultInner>, BgpPeerStatusListResultInner>(){

            public BgpPeerStatusListResultInner call(ServiceResponse<BgpPeerStatusListResultInner> response) {
                return (BgpPeerStatusListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BgpPeerStatusListResultInner>> getBgpPeerStatusWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, String peer) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.getBgpPeerStatus(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), peer, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<BgpPeerStatusListResultInner>(){}.getType());
    }

    public BgpPeerStatusListResultInner beginGetBgpPeerStatus(String resourceGroupName, String virtualNetworkGatewayName) {
        return (BgpPeerStatusListResultInner)((ServiceResponse)this.beginGetBgpPeerStatusWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<BgpPeerStatusListResultInner> beginGetBgpPeerStatusAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<BgpPeerStatusListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGetBgpPeerStatusWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<BgpPeerStatusListResultInner> beginGetBgpPeerStatusAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.beginGetBgpPeerStatusWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<BgpPeerStatusListResultInner>, BgpPeerStatusListResultInner>(){

            public BgpPeerStatusListResultInner call(ServiceResponse<BgpPeerStatusListResultInner> response) {
                return (BgpPeerStatusListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BgpPeerStatusListResultInner>> beginGetBgpPeerStatusWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        String peer = null;
        return this.service.beginGetBgpPeerStatus(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), peer, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BgpPeerStatusListResultInner>>>(){

            public Observable<ServiceResponse<BgpPeerStatusListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.beginGetBgpPeerStatusDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public BgpPeerStatusListResultInner beginGetBgpPeerStatus(String resourceGroupName, String virtualNetworkGatewayName, String peer) {
        return (BgpPeerStatusListResultInner)((ServiceResponse)this.beginGetBgpPeerStatusWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, peer).toBlocking().single()).body();
    }

    public ServiceFuture<BgpPeerStatusListResultInner> beginGetBgpPeerStatusAsync(String resourceGroupName, String virtualNetworkGatewayName, String peer, ServiceCallback<BgpPeerStatusListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGetBgpPeerStatusWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, peer), serviceCallback);
    }

    public Observable<BgpPeerStatusListResultInner> beginGetBgpPeerStatusAsync(String resourceGroupName, String virtualNetworkGatewayName, String peer) {
        return this.beginGetBgpPeerStatusWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, peer).map((Func1)new Func1<ServiceResponse<BgpPeerStatusListResultInner>, BgpPeerStatusListResultInner>(){

            public BgpPeerStatusListResultInner call(ServiceResponse<BgpPeerStatusListResultInner> response) {
                return (BgpPeerStatusListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BgpPeerStatusListResultInner>> beginGetBgpPeerStatusWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, String peer) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.beginGetBgpPeerStatus(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), peer, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BgpPeerStatusListResultInner>>>(){

            public Observable<ServiceResponse<BgpPeerStatusListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.beginGetBgpPeerStatusDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BgpPeerStatusListResultInner> beginGetBgpPeerStatusDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BgpPeerStatusListResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public String supportedVpnDevices(String resourceGroupName, String virtualNetworkGatewayName) {
        return (String)((ServiceResponse)this.supportedVpnDevicesWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<String> supportedVpnDevicesAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<String> serviceCallback) {
        return ServiceFuture.fromResponse(this.supportedVpnDevicesWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<String> supportedVpnDevicesAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.supportedVpnDevicesWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<String>, String>(){

            public String call(ServiceResponse<String> response) {
                return (String)response.body();
            }
        });
    }

    public Observable<ServiceResponse<String>> supportedVpnDevicesWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.supportedVpnDevices(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<String>>>(){

            public Observable<ServiceResponse<String>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.supportedVpnDevicesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<String> supportedVpnDevicesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<String>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GatewayRouteListResultInner getLearnedRoutes(String resourceGroupName, String virtualNetworkGatewayName) {
        return (GatewayRouteListResultInner)((ServiceResponse)this.getLearnedRoutesWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().last()).body();
    }

    public ServiceFuture<GatewayRouteListResultInner> getLearnedRoutesAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<GatewayRouteListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getLearnedRoutesWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<GatewayRouteListResultInner> getLearnedRoutesAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.getLearnedRoutesWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<GatewayRouteListResultInner>, GatewayRouteListResultInner>(){

            public GatewayRouteListResultInner call(ServiceResponse<GatewayRouteListResultInner> response) {
                return (GatewayRouteListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<GatewayRouteListResultInner>> getLearnedRoutesWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.getLearnedRoutes(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<GatewayRouteListResultInner>(){}.getType());
    }

    public GatewayRouteListResultInner beginGetLearnedRoutes(String resourceGroupName, String virtualNetworkGatewayName) {
        return (GatewayRouteListResultInner)((ServiceResponse)this.beginGetLearnedRoutesWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<GatewayRouteListResultInner> beginGetLearnedRoutesAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<GatewayRouteListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGetLearnedRoutesWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<GatewayRouteListResultInner> beginGetLearnedRoutesAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.beginGetLearnedRoutesWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<GatewayRouteListResultInner>, GatewayRouteListResultInner>(){

            public GatewayRouteListResultInner call(ServiceResponse<GatewayRouteListResultInner> response) {
                return (GatewayRouteListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<GatewayRouteListResultInner>> beginGetLearnedRoutesWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.beginGetLearnedRoutes(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GatewayRouteListResultInner>>>(){

            public Observable<ServiceResponse<GatewayRouteListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.beginGetLearnedRoutesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GatewayRouteListResultInner> beginGetLearnedRoutesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GatewayRouteListResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GatewayRouteListResultInner getAdvertisedRoutes(String resourceGroupName, String virtualNetworkGatewayName, String peer) {
        return (GatewayRouteListResultInner)((ServiceResponse)this.getAdvertisedRoutesWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, peer).toBlocking().last()).body();
    }

    public ServiceFuture<GatewayRouteListResultInner> getAdvertisedRoutesAsync(String resourceGroupName, String virtualNetworkGatewayName, String peer, ServiceCallback<GatewayRouteListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAdvertisedRoutesWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, peer), serviceCallback);
    }

    public Observable<GatewayRouteListResultInner> getAdvertisedRoutesAsync(String resourceGroupName, String virtualNetworkGatewayName, String peer) {
        return this.getAdvertisedRoutesWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, peer).map((Func1)new Func1<ServiceResponse<GatewayRouteListResultInner>, GatewayRouteListResultInner>(){

            public GatewayRouteListResultInner call(ServiceResponse<GatewayRouteListResultInner> response) {
                return (GatewayRouteListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<GatewayRouteListResultInner>> getAdvertisedRoutesWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, String peer) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (peer == null) {
            throw new IllegalArgumentException("Parameter peer is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.getAdvertisedRoutes(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), peer, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<GatewayRouteListResultInner>(){}.getType());
    }

    public GatewayRouteListResultInner beginGetAdvertisedRoutes(String resourceGroupName, String virtualNetworkGatewayName, String peer) {
        return (GatewayRouteListResultInner)((ServiceResponse)this.beginGetAdvertisedRoutesWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, peer).toBlocking().single()).body();
    }

    public ServiceFuture<GatewayRouteListResultInner> beginGetAdvertisedRoutesAsync(String resourceGroupName, String virtualNetworkGatewayName, String peer, ServiceCallback<GatewayRouteListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGetAdvertisedRoutesWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, peer), serviceCallback);
    }

    public Observable<GatewayRouteListResultInner> beginGetAdvertisedRoutesAsync(String resourceGroupName, String virtualNetworkGatewayName, String peer) {
        return this.beginGetAdvertisedRoutesWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, peer).map((Func1)new Func1<ServiceResponse<GatewayRouteListResultInner>, GatewayRouteListResultInner>(){

            public GatewayRouteListResultInner call(ServiceResponse<GatewayRouteListResultInner> response) {
                return (GatewayRouteListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<GatewayRouteListResultInner>> beginGetAdvertisedRoutesWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, String peer) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (peer == null) {
            throw new IllegalArgumentException("Parameter peer is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.beginGetAdvertisedRoutes(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), peer, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GatewayRouteListResultInner>>>(){

            public Observable<ServiceResponse<GatewayRouteListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.beginGetAdvertisedRoutesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GatewayRouteListResultInner> beginGetAdvertisedRoutesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GatewayRouteListResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VpnClientIPsecParametersInner setVpnclientIpsecParameters(String resourceGroupName, String virtualNetworkGatewayName, VpnClientIPsecParametersInner vpnclientIpsecParams) {
        return (VpnClientIPsecParametersInner)((ServiceResponse)this.setVpnclientIpsecParametersWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, vpnclientIpsecParams).toBlocking().last()).body();
    }

    public ServiceFuture<VpnClientIPsecParametersInner> setVpnclientIpsecParametersAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientIPsecParametersInner vpnclientIpsecParams, ServiceCallback<VpnClientIPsecParametersInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.setVpnclientIpsecParametersWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, vpnclientIpsecParams), serviceCallback);
    }

    public Observable<VpnClientIPsecParametersInner> setVpnclientIpsecParametersAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientIPsecParametersInner vpnclientIpsecParams) {
        return this.setVpnclientIpsecParametersWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, vpnclientIpsecParams).map((Func1)new Func1<ServiceResponse<VpnClientIPsecParametersInner>, VpnClientIPsecParametersInner>(){

            public VpnClientIPsecParametersInner call(ServiceResponse<VpnClientIPsecParametersInner> response) {
                return (VpnClientIPsecParametersInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VpnClientIPsecParametersInner>> setVpnclientIpsecParametersWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientIPsecParametersInner vpnclientIpsecParams) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (vpnclientIpsecParams == null) {
            throw new IllegalArgumentException("Parameter vpnclientIpsecParams is required and cannot be null.");
        }
        Validator.validate((Object)vpnclientIpsecParams);
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.setVpnclientIpsecParameters(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), vpnclientIpsecParams, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<VpnClientIPsecParametersInner>(){}.getType());
    }

    public VpnClientIPsecParametersInner beginSetVpnclientIpsecParameters(String resourceGroupName, String virtualNetworkGatewayName, VpnClientIPsecParametersInner vpnclientIpsecParams) {
        return (VpnClientIPsecParametersInner)((ServiceResponse)this.beginSetVpnclientIpsecParametersWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, vpnclientIpsecParams).toBlocking().single()).body();
    }

    public ServiceFuture<VpnClientIPsecParametersInner> beginSetVpnclientIpsecParametersAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientIPsecParametersInner vpnclientIpsecParams, ServiceCallback<VpnClientIPsecParametersInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginSetVpnclientIpsecParametersWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, vpnclientIpsecParams), serviceCallback);
    }

    public Observable<VpnClientIPsecParametersInner> beginSetVpnclientIpsecParametersAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientIPsecParametersInner vpnclientIpsecParams) {
        return this.beginSetVpnclientIpsecParametersWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName, vpnclientIpsecParams).map((Func1)new Func1<ServiceResponse<VpnClientIPsecParametersInner>, VpnClientIPsecParametersInner>(){

            public VpnClientIPsecParametersInner call(ServiceResponse<VpnClientIPsecParametersInner> response) {
                return (VpnClientIPsecParametersInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VpnClientIPsecParametersInner>> beginSetVpnclientIpsecParametersWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName, VpnClientIPsecParametersInner vpnclientIpsecParams) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (vpnclientIpsecParams == null) {
            throw new IllegalArgumentException("Parameter vpnclientIpsecParams is required and cannot be null.");
        }
        Validator.validate((Object)vpnclientIpsecParams);
        String apiVersion = "2018-06-01";
        return this.service.beginSetVpnclientIpsecParameters(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), vpnclientIpsecParams, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnClientIPsecParametersInner>>>(){

            public Observable<ServiceResponse<VpnClientIPsecParametersInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.beginSetVpnclientIpsecParametersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnClientIPsecParametersInner> beginSetVpnclientIpsecParametersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnClientIPsecParametersInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VpnClientIPsecParametersInner getVpnclientIpsecParameters(String resourceGroupName, String virtualNetworkGatewayName) {
        return (VpnClientIPsecParametersInner)((ServiceResponse)this.getVpnclientIpsecParametersWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().last()).body();
    }

    public ServiceFuture<VpnClientIPsecParametersInner> getVpnclientIpsecParametersAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<VpnClientIPsecParametersInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getVpnclientIpsecParametersWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<VpnClientIPsecParametersInner> getVpnclientIpsecParametersAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.getVpnclientIpsecParametersWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<VpnClientIPsecParametersInner>, VpnClientIPsecParametersInner>(){

            public VpnClientIPsecParametersInner call(ServiceResponse<VpnClientIPsecParametersInner> response) {
                return (VpnClientIPsecParametersInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VpnClientIPsecParametersInner>> getVpnclientIpsecParametersWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        Observable<Response<ResponseBody>> observable = this.service.getVpnclientIpsecParameters(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<VpnClientIPsecParametersInner>(){}.getType());
    }

    public VpnClientIPsecParametersInner beginGetVpnclientIpsecParameters(String resourceGroupName, String virtualNetworkGatewayName) {
        return (VpnClientIPsecParametersInner)((ServiceResponse)this.beginGetVpnclientIpsecParametersWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<VpnClientIPsecParametersInner> beginGetVpnclientIpsecParametersAsync(String resourceGroupName, String virtualNetworkGatewayName, ServiceCallback<VpnClientIPsecParametersInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginGetVpnclientIpsecParametersWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName), serviceCallback);
    }

    public Observable<VpnClientIPsecParametersInner> beginGetVpnclientIpsecParametersAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        return this.beginGetVpnclientIpsecParametersWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayName).map((Func1)new Func1<ServiceResponse<VpnClientIPsecParametersInner>, VpnClientIPsecParametersInner>(){

            public VpnClientIPsecParametersInner call(ServiceResponse<VpnClientIPsecParametersInner> response) {
                return (VpnClientIPsecParametersInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<VpnClientIPsecParametersInner>> beginGetVpnclientIpsecParametersWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2018-06-01";
        return this.service.beginGetVpnclientIpsecParameters(resourceGroupName, virtualNetworkGatewayName, this.client.subscriptionId(), "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnClientIPsecParametersInner>>>(){

            public Observable<ServiceResponse<VpnClientIPsecParametersInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.beginGetVpnclientIpsecParametersDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnClientIPsecParametersInner> beginGetVpnclientIpsecParametersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnClientIPsecParametersInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public String vpnDeviceConfigurationScript(String resourceGroupName, String virtualNetworkGatewayConnectionName, VpnDeviceScriptParameters parameters) {
        return (String)((ServiceResponse)this.vpnDeviceConfigurationScriptWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayConnectionName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<String> vpnDeviceConfigurationScriptAsync(String resourceGroupName, String virtualNetworkGatewayConnectionName, VpnDeviceScriptParameters parameters, ServiceCallback<String> serviceCallback) {
        return ServiceFuture.fromResponse(this.vpnDeviceConfigurationScriptWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayConnectionName, parameters), serviceCallback);
    }

    public Observable<String> vpnDeviceConfigurationScriptAsync(String resourceGroupName, String virtualNetworkGatewayConnectionName, VpnDeviceScriptParameters parameters) {
        return this.vpnDeviceConfigurationScriptWithServiceResponseAsync(resourceGroupName, virtualNetworkGatewayConnectionName, parameters).map((Func1)new Func1<ServiceResponse<String>, String>(){

            public String call(ServiceResponse<String> response) {
                return (String)response.body();
            }
        });
    }

    public Observable<ServiceResponse<String>> vpnDeviceConfigurationScriptWithServiceResponseAsync(String resourceGroupName, String virtualNetworkGatewayConnectionName, VpnDeviceScriptParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkGatewayConnectionName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkGatewayConnectionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2018-06-01";
        return this.service.vpnDeviceConfigurationScript(resourceGroupName, virtualNetworkGatewayConnectionName, this.client.subscriptionId(), parameters, "2018-06-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<String>>>(){

            public Observable<ServiceResponse<String>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualNetworkGatewaysInner.this.vpnDeviceConfigurationScriptDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<String> vpnDeviceConfigurationScriptDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<String>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualNetworkGatewayInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualNetworkGatewayInner>((Page)response.body()){

            public Page<VirtualNetworkGatewayInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualNetworkGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualNetworkGatewayInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<VirtualNetworkGatewayInner>> serviceFuture, ListOperationCallback<VirtualNetworkGatewayInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>> call(String nextPageLink) {
                return VirtualNetworkGatewaysInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualNetworkGatewayInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualNetworkGatewayInner>>, Page<VirtualNetworkGatewayInner>>(){

            public Page<VirtualNetworkGatewayInner> call(ServiceResponse<Page<VirtualNetworkGatewayInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualNetworkGatewayInner>>, Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>> call(ServiceResponse<Page<VirtualNetworkGatewayInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualNetworkGatewaysInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualNetworkGatewaysInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualNetworkGatewayInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualNetworkGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualNetworkGatewayConnectionListEntityInner> listConnectionsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listConnectionsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualNetworkGatewayConnectionListEntityInner>((Page)response.body()){

            public Page<VirtualNetworkGatewayConnectionListEntityInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualNetworkGatewaysInner.this.listConnectionsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualNetworkGatewayConnectionListEntityInner>> listConnectionsNextAsync(String nextPageLink, ServiceFuture<List<VirtualNetworkGatewayConnectionListEntityInner>> serviceFuture, ListOperationCallback<VirtualNetworkGatewayConnectionListEntityInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listConnectionsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>> call(String nextPageLink) {
                return VirtualNetworkGatewaysInner.this.listConnectionsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualNetworkGatewayConnectionListEntityInner>> listConnectionsNextAsync(String nextPageLink) {
        return this.listConnectionsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>, Page<VirtualNetworkGatewayConnectionListEntityInner>>(){

            public Page<VirtualNetworkGatewayConnectionListEntityInner> call(ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>> listConnectionsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listConnectionsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>, Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>> call(ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualNetworkGatewaysInner.this.listConnectionsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>> listConnectionsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listConnectionsNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualNetworkGatewayConnectionListEntityInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualNetworkGatewaysInner.this.listConnectionsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualNetworkGatewayConnectionListEntityInner>> listConnectionsNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualNetworkGatewayConnectionListEntityInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VirtualNetworkGatewaysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body VirtualNetworkGatewayInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body VirtualNetworkGatewayInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways beginUpdateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}")
        public Observable<Response<ResponseBody>> beginUpdateTags(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways listConnections"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/connections")
        public Observable<Response<ResponseBody>> listConnections(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways reset"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/reset")
        public Observable<Response<ResponseBody>> reset(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="gatewayVip") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways beginReset"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/reset")
        public Observable<Response<ResponseBody>> beginReset(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="gatewayVip") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways generatevpnclientpackage"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/generatevpnclientpackage")
        public Observable<Response<ResponseBody>> generatevpnclientpackage(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body VpnClientParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways beginGeneratevpnclientpackage"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/generatevpnclientpackage")
        public Observable<Response<ResponseBody>> beginGeneratevpnclientpackage(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body VpnClientParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways generateVpnProfile"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/generatevpnprofile")
        public Observable<Response<ResponseBody>> generateVpnProfile(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body VpnClientParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways beginGenerateVpnProfile"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/generatevpnprofile")
        public Observable<Response<ResponseBody>> beginGenerateVpnProfile(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body VpnClientParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways getVpnProfilePackageUrl"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getvpnprofilepackageurl")
        public Observable<Response<ResponseBody>> getVpnProfilePackageUrl(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways beginGetVpnProfilePackageUrl"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getvpnprofilepackageurl")
        public Observable<Response<ResponseBody>> beginGetVpnProfilePackageUrl(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways getBgpPeerStatus"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getBgpPeerStatus")
        public Observable<Response<ResponseBody>> getBgpPeerStatus(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="peer") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways beginGetBgpPeerStatus"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getBgpPeerStatus")
        public Observable<Response<ResponseBody>> beginGetBgpPeerStatus(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="peer") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways supportedVpnDevices"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/supportedvpndevices")
        public Observable<Response<ResponseBody>> supportedVpnDevices(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways getLearnedRoutes"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getLearnedRoutes")
        public Observable<Response<ResponseBody>> getLearnedRoutes(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways beginGetLearnedRoutes"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getLearnedRoutes")
        public Observable<Response<ResponseBody>> beginGetLearnedRoutes(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways getAdvertisedRoutes"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getAdvertisedRoutes")
        public Observable<Response<ResponseBody>> getAdvertisedRoutes(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="peer") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways beginGetAdvertisedRoutes"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getAdvertisedRoutes")
        public Observable<Response<ResponseBody>> beginGetAdvertisedRoutes(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="peer") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways setVpnclientIpsecParameters"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/setvpnclientipsecparameters")
        public Observable<Response<ResponseBody>> setVpnclientIpsecParameters(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body VpnClientIPsecParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways beginSetVpnclientIpsecParameters"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/setvpnclientipsecparameters")
        public Observable<Response<ResponseBody>> beginSetVpnclientIpsecParameters(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body VpnClientIPsecParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways getVpnclientIpsecParameters"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getvpnclientipsecparameters")
        public Observable<Response<ResponseBody>> getVpnclientIpsecParameters(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways beginGetVpnclientIpsecParameters"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworkGateways/{virtualNetworkGatewayName}/getvpnclientipsecparameters")
        public Observable<Response<ResponseBody>> beginGetVpnclientIpsecParameters(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways vpnDeviceConfigurationScript"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/connections/{virtualNetworkGatewayConnectionName}/vpndeviceconfigurationscript")
        public Observable<Response<ResponseBody>> vpnDeviceConfigurationScript(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkGatewayConnectionName") String var2, @Path(value="subscriptionId") String var3, @Body VpnDeviceScriptParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualNetworkGateways listConnectionsNext"})
        @GET
        public Observable<Response<ResponseBody>> listConnectionsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

