/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.BackupShortTermRetentionPolicyInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class BackupShortTermRetentionPoliciesInner {
    private BackupShortTermRetentionPoliciesService service;
    private SqlManagementClientImpl client;

    public BackupShortTermRetentionPoliciesInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (BackupShortTermRetentionPoliciesService)retrofit.create(BackupShortTermRetentionPoliciesService.class);
        this.client = client;
    }

    public BackupShortTermRetentionPolicyInner get(String resourceGroupName, String serverName, String databaseName) {
        return (BackupShortTermRetentionPolicyInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<BackupShortTermRetentionPolicyInner> getAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<BackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<BackupShortTermRetentionPolicyInner> getAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner>(){

            public BackupShortTermRetentionPolicyInner call(ServiceResponse<BackupShortTermRetentionPolicyInner> response) {
                return (BackupShortTermRetentionPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-10-01-preview";
        return this.service.get(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>>>(){

            public Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BackupShortTermRetentionPoliciesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BackupShortTermRetentionPolicyInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BackupShortTermRetentionPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BackupShortTermRetentionPolicyInner createOrUpdate(String resourceGroupName, String serverName, String databaseName) {
        return (BackupShortTermRetentionPolicyInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().last()).body();
    }

    public ServiceFuture<BackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<BackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<BackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner>(){

            public BackupShortTermRetentionPolicyInner call(ServiceResponse<BackupShortTermRetentionPolicyInner> response) {
                return (BackupShortTermRetentionPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-10-01-preview";
        Object retentionDays = null;
        BackupShortTermRetentionPolicyInner parameters = new BackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(null);
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BackupShortTermRetentionPolicyInner>(){}.getType());
    }

    public BackupShortTermRetentionPolicyInner createOrUpdate(String resourceGroupName, String serverName, String databaseName, Integer retentionDays) {
        return (BackupShortTermRetentionPolicyInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, retentionDays).toBlocking().last()).body();
    }

    public ServiceFuture<BackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, Integer retentionDays, ServiceCallback<BackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, retentionDays), serviceCallback);
    }

    public Observable<BackupShortTermRetentionPolicyInner> createOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, Integer retentionDays) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, retentionDays).map((Func1)new Func1<ServiceResponse<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner>(){

            public BackupShortTermRetentionPolicyInner call(ServiceResponse<BackupShortTermRetentionPolicyInner> response) {
                return (BackupShortTermRetentionPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, Integer retentionDays) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-10-01-preview";
        BackupShortTermRetentionPolicyInner parameters = new BackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BackupShortTermRetentionPolicyInner>(){}.getType());
    }

    public BackupShortTermRetentionPolicyInner beginCreateOrUpdate(String resourceGroupName, String serverName, String databaseName) {
        return (BackupShortTermRetentionPolicyInner)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<BackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<BackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<BackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner>(){

            public BackupShortTermRetentionPolicyInner call(ServiceResponse<BackupShortTermRetentionPolicyInner> response) {
                return (BackupShortTermRetentionPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-10-01-preview";
        Object retentionDays = null;
        BackupShortTermRetentionPolicyInner parameters = new BackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(null);
        return this.service.beginCreateOrUpdate(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>>>(){

            public Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BackupShortTermRetentionPoliciesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public BackupShortTermRetentionPolicyInner beginCreateOrUpdate(String resourceGroupName, String serverName, String databaseName, Integer retentionDays) {
        return (BackupShortTermRetentionPolicyInner)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, retentionDays).toBlocking().single()).body();
    }

    public ServiceFuture<BackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, Integer retentionDays, ServiceCallback<BackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, retentionDays), serviceCallback);
    }

    public Observable<BackupShortTermRetentionPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String serverName, String databaseName, Integer retentionDays) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, retentionDays).map((Func1)new Func1<ServiceResponse<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner>(){

            public BackupShortTermRetentionPolicyInner call(ServiceResponse<BackupShortTermRetentionPolicyInner> response) {
                return (BackupShortTermRetentionPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, Integer retentionDays) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-10-01-preview";
        BackupShortTermRetentionPolicyInner parameters = new BackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        return this.service.beginCreateOrUpdate(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>>>(){

            public Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BackupShortTermRetentionPoliciesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BackupShortTermRetentionPolicyInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BackupShortTermRetentionPolicyInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public BackupShortTermRetentionPolicyInner update(String resourceGroupName, String serverName, String databaseName) {
        return (BackupShortTermRetentionPolicyInner)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().last()).body();
    }

    public ServiceFuture<BackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<BackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<BackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner>(){

            public BackupShortTermRetentionPolicyInner call(ServiceResponse<BackupShortTermRetentionPolicyInner> response) {
                return (BackupShortTermRetentionPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>> updateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-10-01-preview";
        Object retentionDays = null;
        BackupShortTermRetentionPolicyInner parameters = new BackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(null);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BackupShortTermRetentionPolicyInner>(){}.getType());
    }

    public BackupShortTermRetentionPolicyInner update(String resourceGroupName, String serverName, String databaseName, Integer retentionDays) {
        return (BackupShortTermRetentionPolicyInner)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, retentionDays).toBlocking().last()).body();
    }

    public ServiceFuture<BackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String serverName, String databaseName, Integer retentionDays, ServiceCallback<BackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, retentionDays), serviceCallback);
    }

    public Observable<BackupShortTermRetentionPolicyInner> updateAsync(String resourceGroupName, String serverName, String databaseName, Integer retentionDays) {
        return this.updateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, retentionDays).map((Func1)new Func1<ServiceResponse<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner>(){

            public BackupShortTermRetentionPolicyInner call(ServiceResponse<BackupShortTermRetentionPolicyInner> response) {
                return (BackupShortTermRetentionPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>> updateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, Integer retentionDays) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-10-01-preview";
        BackupShortTermRetentionPolicyInner parameters = new BackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<BackupShortTermRetentionPolicyInner>(){}.getType());
    }

    public BackupShortTermRetentionPolicyInner beginUpdate(String resourceGroupName, String serverName, String databaseName) {
        return (BackupShortTermRetentionPolicyInner)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<BackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName, ServiceCallback<BackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName), serviceCallback);
    }

    public Observable<BackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner>(){

            public BackupShortTermRetentionPolicyInner call(ServiceResponse<BackupShortTermRetentionPolicyInner> response) {
                return (BackupShortTermRetentionPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-10-01-preview";
        Object retentionDays = null;
        BackupShortTermRetentionPolicyInner parameters = new BackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(null);
        return this.service.beginUpdate(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>>>(){

            public Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BackupShortTermRetentionPoliciesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public BackupShortTermRetentionPolicyInner beginUpdate(String resourceGroupName, String serverName, String databaseName, Integer retentionDays) {
        return (BackupShortTermRetentionPolicyInner)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, retentionDays).toBlocking().single()).body();
    }

    public ServiceFuture<BackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName, Integer retentionDays, ServiceCallback<BackupShortTermRetentionPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, retentionDays), serviceCallback);
    }

    public Observable<BackupShortTermRetentionPolicyInner> beginUpdateAsync(String resourceGroupName, String serverName, String databaseName, Integer retentionDays) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, serverName, databaseName, retentionDays).map((Func1)new Func1<ServiceResponse<BackupShortTermRetentionPolicyInner>, BackupShortTermRetentionPolicyInner>(){

            public BackupShortTermRetentionPolicyInner call(ServiceResponse<BackupShortTermRetentionPolicyInner> response) {
                return (BackupShortTermRetentionPolicyInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName, Integer retentionDays) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String policyName = "default";
        String apiVersion = "2017-10-01-preview";
        BackupShortTermRetentionPolicyInner parameters = new BackupShortTermRetentionPolicyInner();
        parameters.withRetentionDays(retentionDays);
        return this.service.beginUpdate(resourceGroupName, serverName, databaseName, "default", this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>>>(){

            public Observable<ServiceResponse<BackupShortTermRetentionPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = BackupShortTermRetentionPoliciesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<BackupShortTermRetentionPolicyInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<BackupShortTermRetentionPolicyInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BackupShortTermRetentionPolicyInner> listByDatabase(String resourceGroupName, String serverName, String databaseName) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName).toBlocking().single();
        return new PagedList<BackupShortTermRetentionPolicyInner>((Page)response.body()){

            public Page<BackupShortTermRetentionPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BackupShortTermRetentionPoliciesInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BackupShortTermRetentionPolicyInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName, ListOperationCallback<BackupShortTermRetentionPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName), (Func1)new Func1<String, Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>> call(String nextPageLink) {
                return BackupShortTermRetentionPoliciesInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BackupShortTermRetentionPolicyInner>> listByDatabaseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listByDatabaseWithServiceResponseAsync(resourceGroupName, serverName, databaseName).map((Func1)new Func1<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>, Page<BackupShortTermRetentionPolicyInner>>(){

            public Page<BackupShortTermRetentionPolicyInner> call(ServiceResponse<Page<BackupShortTermRetentionPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>> listByDatabaseWithServiceResponseAsync(String resourceGroupName, String serverName, String databaseName) {
        return this.listByDatabaseSinglePageAsync(resourceGroupName, serverName, databaseName).concatMap((Func1)new Func1<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>, Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>> call(ServiceResponse<Page<BackupShortTermRetentionPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BackupShortTermRetentionPoliciesInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>> listByDatabaseSinglePageAsync(String resourceGroupName, String serverName, String databaseName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-10-01-preview";
        return this.service.listByDatabase(resourceGroupName, serverName, databaseName, this.client.subscriptionId(), "2017-10-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BackupShortTermRetentionPoliciesInner.this.listByDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<BackupShortTermRetentionPolicyInner>> listByDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<BackupShortTermRetentionPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<BackupShortTermRetentionPolicyInner> listByDatabaseNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<BackupShortTermRetentionPolicyInner>((Page)response.body()){

            public Page<BackupShortTermRetentionPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)BackupShortTermRetentionPoliciesInner.this.listByDatabaseNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<BackupShortTermRetentionPolicyInner>> listByDatabaseNextAsync(String nextPageLink, ServiceFuture<List<BackupShortTermRetentionPolicyInner>> serviceFuture, ListOperationCallback<BackupShortTermRetentionPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByDatabaseNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>> call(String nextPageLink) {
                return BackupShortTermRetentionPoliciesInner.this.listByDatabaseNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<BackupShortTermRetentionPolicyInner>> listByDatabaseNextAsync(String nextPageLink) {
        return this.listByDatabaseNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>, Page<BackupShortTermRetentionPolicyInner>>(){

            public Page<BackupShortTermRetentionPolicyInner> call(ServiceResponse<Page<BackupShortTermRetentionPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>> listByDatabaseNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByDatabaseNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>, Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>> call(ServiceResponse<Page<BackupShortTermRetentionPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(BackupShortTermRetentionPoliciesInner.this.listByDatabaseNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>> listByDatabaseNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByDatabaseNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<BackupShortTermRetentionPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = BackupShortTermRetentionPoliciesInner.this.listByDatabaseNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<BackupShortTermRetentionPolicyInner>> listByDatabaseNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<BackupShortTermRetentionPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface BackupShortTermRetentionPoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.BackupShortTermRetentionPolicies get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="policyName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.BackupShortTermRetentionPolicies createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="policyName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body BackupShortTermRetentionPolicyInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.BackupShortTermRetentionPolicies beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="policyName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body BackupShortTermRetentionPolicyInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.BackupShortTermRetentionPolicies update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="policyName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body BackupShortTermRetentionPolicyInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.BackupShortTermRetentionPolicies beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="policyName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body BackupShortTermRetentionPolicyInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.BackupShortTermRetentionPolicies listByDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupShortTermRetentionPolicies")
        public Observable<Response<ResponseBody>> listByDatabase(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="databaseName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.BackupShortTermRetentionPolicies listByDatabaseNext"})
        @GET
        public Observable<Response<ResponseBody>> listByDatabaseNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

