/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.containerregistry.Architecture;
import com.microsoft.azure.management.containerregistry.BaseImageTriggerType;
import com.microsoft.azure.management.containerregistry.PlatformProperties;
import com.microsoft.azure.management.containerregistry.PlatformUpdateParameters;
import com.microsoft.azure.management.containerregistry.ProvisioningState;
import com.microsoft.azure.management.containerregistry.RegistryDockerTaskStep;
import com.microsoft.azure.management.containerregistry.RegistryEncodedTaskStep;
import com.microsoft.azure.management.containerregistry.RegistryFileTaskStep;
import com.microsoft.azure.management.containerregistry.RegistrySourceTrigger;
import com.microsoft.azure.management.containerregistry.RegistryTaskStep;
import com.microsoft.azure.management.containerregistry.TaskStatus;
import com.microsoft.azure.management.containerregistry.TriggerProperties;
import com.microsoft.azure.management.containerregistry.TriggerStatus;
import com.microsoft.azure.management.containerregistry.Variant;
import com.microsoft.azure.management.containerregistry.implementation.TaskInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.Map;
import org.joda.time.DateTime;

@Fluent
@Beta(value=Beta.SinceVersion.V1_17_0)
public interface RegistryTask
extends Resource,
HasInner<TaskInner>,
Refreshable<RegistryTask>,
Updatable<Update> {
    public String resourceGroupName();

    public String parentRegistryId();

    public ProvisioningState provisioningState();

    public DateTime creationDate();

    public TaskStatus status();

    public RegistryTaskStep registryTaskStep();

    public int timeout();

    public PlatformProperties platform();

    public int cpuCount();

    public TriggerProperties trigger();

    public Map<String, RegistrySourceTrigger> sourceTriggers();

    public static interface UpdateStages {

        public static interface Timeout {
            public Update withTimeout(int var1);
        }

        public static interface AgentConfiguration {
            public Update withCpuCount(int var1);
        }

        public static interface TriggerTypes {
            public RegistrySourceTrigger.Update updateSourceTrigger(String var1);

            public RegistrySourceTrigger.UpdateDefinitionStages.Blank defineSourceTrigger(String var1);

            public Update updateBaseImageTrigger(String var1, BaseImageTriggerType var2);

            public Update updateBaseImageTrigger(String var1, BaseImageTriggerType var2, TriggerStatus var3);
        }

        public static interface Platform {
            public Update withLinux();

            public Update withWindows();

            public Update withLinux(Architecture var1);

            public Update withWindows(Architecture var1);

            public Update withLinux(Architecture var1, Variant var2);

            public Update withWindows(Architecture var1, Variant var2);

            public Update withPlatform(PlatformUpdateParameters var1);
        }

        public static interface TaskStepType {
            public RegistryFileTaskStep.Update updateFileTaskStep();

            public RegistryEncodedTaskStep.Update updateEncodedTaskStep();

            public RegistryDockerTaskStep.Update updateDockerTaskStep();
        }
    }

    public static interface DefinitionStages {

        public static interface TaskCreatable
        extends AgentConfiguration,
        Timeout,
        SourceTriggerDefinition,
        TriggerTypes,
        Creatable<RegistryTask> {
        }

        public static interface Timeout {
            public TaskCreatable withTimeout(int var1);
        }

        public static interface AgentConfiguration {
            public TaskCreatable withCpuCount(int var1);
        }

        public static interface TriggerTypes {
            public RegistrySourceTrigger.DefinitionStages.Blank defineSourceTrigger(String var1);

            public TaskCreatable withBaseImageTrigger(String var1, BaseImageTriggerType var2);

            public TaskCreatable withBaseImageTrigger(String var1, BaseImageTriggerType var2, TriggerStatus var3);
        }

        public static interface SourceTriggerDefinition {
            public RegistrySourceTrigger.DefinitionStages.Blank defineSourceTrigger(String var1);
        }

        public static interface TaskStepType {
            public RegistryFileTaskStep.DefinitionStages.Blank defineFileTaskStep();

            public RegistryEncodedTaskStep.DefinitionStages.Blank defineEncodedTaskStep();

            public RegistryDockerTaskStep.DefinitionStages.Blank defineDockerTaskStep();
        }

        public static interface Platform {
            public TaskStepType withLinux();

            public TaskStepType withWindows();

            public TaskStepType withLinux(Architecture var1);

            public TaskStepType withWindows(Architecture var1);

            public TaskStepType withLinux(Architecture var1, Variant var2);

            public TaskStepType withWindows(Architecture var1, Variant var2);

            public TaskStepType withPlatform(PlatformProperties var1);
        }

        public static interface Location {
            public Platform withLocation(String var1);

            public Platform withLocation(Region var1);
        }

        public static interface Blank {
            public Location withExistingRegistry(String var1, String var2);
        }
    }

    public static interface Update
    extends UpdateStages.Platform,
    UpdateStages.TriggerTypes,
    UpdateStages.AgentConfiguration,
    UpdateStages.Timeout,
    UpdateStages.TaskStepType,
    Appliable<RegistryTask> {
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.Location,
    DefinitionStages.Platform,
    DefinitionStages.TaskStepType,
    DefinitionStages.SourceTriggerDefinition,
    DefinitionStages.TriggerTypes,
    DefinitionStages.TaskCreatable {
    }
}

