/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.containerregistry.FileTaskRunRequest;
import com.microsoft.azure.management.containerregistry.OverridingValue;
import com.microsoft.azure.management.containerregistry.PlatformProperties;
import com.microsoft.azure.management.containerregistry.RegistryFileTaskRunRequest;
import com.microsoft.azure.management.containerregistry.SetValue;
import com.microsoft.azure.management.containerregistry.implementation.RegistryTaskRunImpl;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.Map;

@LangDefinition
class RegistryFileTaskRunRequestImpl
implements RegistryFileTaskRunRequest,
RegistryFileTaskRunRequest.Definition,
HasInner<FileTaskRunRequest> {
    private FileTaskRunRequest inner = new FileTaskRunRequest();
    private RegistryTaskRunImpl registryTaskRunImpl;

    @Override
    public int timeout() {
        return Utils.toPrimitiveInt((Integer)this.inner.timeout());
    }

    @Override
    public PlatformProperties platform() {
        return this.inner.platform();
    }

    @Override
    public int cpuCount() {
        if (this.inner.agentConfiguration() == null) {
            return 0;
        }
        return Utils.toPrimitiveInt((Integer)this.inner.agentConfiguration().cpu());
    }

    @Override
    public String sourceLocation() {
        return this.inner.sourceLocation();
    }

    @Override
    public boolean isArchiveEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)this.inner.isArchiveEnabled());
    }

    RegistryFileTaskRunRequestImpl(RegistryTaskRunImpl registryTaskRunImpl) {
        this.registryTaskRunImpl = registryTaskRunImpl;
    }

    @Override
    public RegistryFileTaskRunRequestImpl defineFileTaskStep() {
        return this;
    }

    @Override
    public RegistryFileTaskRunRequestImpl withTaskPath(String taskPath) {
        this.inner.withTaskFilePath(taskPath);
        return this;
    }

    @Override
    public RegistryFileTaskRunRequestImpl withValuesPath(String valuesPath) {
        this.inner.withValuesFilePath(valuesPath);
        return this;
    }

    @Override
    public RegistryFileTaskRunRequestImpl withOverridingValues(Map<String, OverridingValue> overridingValues) {
        if (overridingValues.size() == 0) {
            return this;
        }
        ArrayList<SetValue> overridingValuesList = new ArrayList<SetValue>();
        for (Map.Entry<String, OverridingValue> entry : overridingValues.entrySet()) {
            SetValue value = new SetValue();
            value.withName(entry.getKey());
            value.withValue(entry.getValue().value());
            value.withIsSecret(entry.getValue().isSecret());
            overridingValuesList.add(value);
        }
        this.inner.withValues(overridingValuesList);
        return this;
    }

    @Override
    public RegistryFileTaskRunRequestImpl withOverridingValue(String name, OverridingValue overridingValue) {
        if (this.inner.values() == null) {
            this.inner.withValues(new ArrayList<SetValue>());
        }
        SetValue value = new SetValue();
        value.withName(name);
        value.withValue(overridingValue.value());
        value.withIsSecret(overridingValue.isSecret());
        this.inner.values().add(value);
        return this;
    }

    public RegistryTaskRunImpl attach() {
        this.registryTaskRunImpl.withFileTaskRunRequest(this.inner);
        return this.registryTaskRunImpl;
    }

    public FileTaskRunRequest inner() {
        return this.inner;
    }
}

