/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.codec.http.ClientCookieEncoder;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.reactivex.netty.channel.ByteTransformer;
import io.reactivex.netty.channel.ContentTransformer;
import io.reactivex.netty.protocol.http.client.HttpRequestHeaders;
import java.nio.charset.Charset;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Func1;

public class HttpClientRequest<T> {
    private final HttpRequest nettyRequest;
    private final HttpRequestHeaders headers;
    private Observable<T> contentSource;
    private Observable<ByteBuf> rawContentSource;
    private String absoluteUri;
    private Action0 onWriteCompleteAction;

    HttpClientRequest(HttpRequest nettyRequest) {
        this.nettyRequest = nettyRequest;
        this.headers = new HttpRequestHeaders(nettyRequest);
    }

    HttpClientRequest(HttpClientRequest<T> shallowCopySource) {
        this.nettyRequest = shallowCopySource.nettyRequest;
        this.headers = new HttpRequestHeaders(this.nettyRequest);
        this.contentSource = shallowCopySource.contentSource;
        this.rawContentSource = shallowCopySource.rawContentSource;
        this.absoluteUri = shallowCopySource.absoluteUri;
    }

    HttpClientRequest(HttpRequest nettyRequest, HttpClientRequest<T> shallowCopySource) {
        this.nettyRequest = nettyRequest;
        this.headers = new HttpRequestHeaders(nettyRequest);
        this.contentSource = shallowCopySource.contentSource;
        this.rawContentSource = shallowCopySource.rawContentSource;
        this.absoluteUri = shallowCopySource.absoluteUri;
    }

    public static HttpClientRequest<ByteBuf> createGet(String uri) {
        return HttpClientRequest.create(HttpMethod.GET, uri);
    }

    public static HttpClientRequest<ByteBuf> createPost(String uri) {
        return HttpClientRequest.create(HttpMethod.POST, uri);
    }

    public static HttpClientRequest<ByteBuf> createPut(String uri) {
        return HttpClientRequest.create(HttpMethod.PUT, uri);
    }

    public static HttpClientRequest<ByteBuf> createDelete(String uri) {
        return HttpClientRequest.create(HttpMethod.DELETE, uri);
    }

    public static <T> HttpClientRequest<T> create(HttpVersion httpVersion, HttpMethod method, String uri) {
        DefaultHttpRequest nettyRequest = new DefaultHttpRequest(httpVersion, method, uri);
        return new HttpClientRequest<T>((HttpRequest)nettyRequest);
    }

    public static <T> HttpClientRequest<T> create(HttpMethod method, String uri) {
        return HttpClientRequest.create(HttpVersion.HTTP_1_1, method, uri);
    }

    public HttpClientRequest<T> withHeader(String name, String value) {
        this.headers.add(name, (Object)value);
        return this;
    }

    public HttpClientRequest<T> withCookie(Cookie cookie) {
        String cookieHeader = ClientCookieEncoder.encode((Cookie)cookie);
        return this.withHeader("Cookie", cookieHeader);
    }

    public HttpClientRequest<T> withContentSource(Observable<T> contentSource) {
        this.contentSource = contentSource;
        return this;
    }

    public <S> HttpClientRequest<T> withRawContentSource(Observable<S> rawContentSource, final ContentTransformer<S> transformer) {
        this.rawContentSource = rawContentSource.map(new Func1<S, ByteBuf>(){

            public ByteBuf call(S rawContent) {
                return (ByteBuf)transformer.call(rawContent, PooledByteBufAllocator.DEFAULT);
            }
        });
        return this;
    }

    public <S> HttpClientRequest<T> withRawContent(S content, ContentTransformer<S> transformer) {
        return this.withRawContentSource(Observable.just(content), transformer);
    }

    public HttpClientRequest<T> withContent(T content) {
        this.withContentSource(Observable.just(content));
        return this;
    }

    public HttpClientRequest<T> withContent(String content) {
        return this.withContent(content.getBytes(Charset.defaultCharset()));
    }

    public HttpClientRequest<T> withContent(byte[] content) {
        this.headers.set("Content-Length", (Object)content.length);
        this.withRawContentSource(Observable.just((Object)content), ByteTransformer.DEFAULT_INSTANCE);
        return this;
    }

    public HttpRequestHeaders getHeaders() {
        return this.headers;
    }

    public HttpVersion getHttpVersion() {
        return this.nettyRequest.getProtocolVersion();
    }

    public HttpMethod getMethod() {
        return this.nettyRequest.getMethod();
    }

    public String getUri() {
        return this.nettyRequest.getUri();
    }

    public String getAbsoluteUri() {
        return null != this.absoluteUri ? this.absoluteUri : this.getUri();
    }

    HttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    ContentSourceType getContentSourceType() {
        return null == this.contentSource ? (null == this.rawContentSource ? ContentSourceType.Absent : ContentSourceType.Raw) : ContentSourceType.Typed;
    }

    Observable<T> getContentSource() {
        return this.contentSource;
    }

    Observable<ByteBuf> getRawContentSource() {
        return this.rawContentSource;
    }

    void removeContent() {
        this.contentSource = null;
        this.rawContentSource = null;
    }

    void doOnWriteComplete(Action0 onWriteCompleteAction) {
        this.onWriteCompleteAction = onWriteCompleteAction;
    }

    void onWriteComplete() {
        if (null != this.onWriteCompleteAction) {
            this.onWriteCompleteAction.call();
        }
    }

    void setDynamicUriParts(String host, int port, boolean secure) {
        this.absoluteUri = secure ? "https" : "http://" + host + ':' + port;
    }

    static enum ContentSourceType {
        Raw,
        Typed,
        Absent;

    }
}

