/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.client;

import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.reactivex.netty.protocol.http.AbstractHttpContentHolder;
import io.reactivex.netty.protocol.http.CookiesHolder;
import io.reactivex.netty.protocol.http.UnicastContentSubject;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientResponse<T>
extends AbstractHttpContentHolder<T> {
    public static final long DEFAULT_CONTENT_SUBSCRIPTION_TIMEOUT_MS = 1L;
    private static final Logger logger = LoggerFactory.getLogger(HttpClientResponse.class);
    public static final String KEEP_ALIVE_HEADER_NAME = "Keep-Alive";
    private static final Pattern PATTERN_COMMA = Pattern.compile(",");
    private static final Pattern PATTERN_EQUALS = Pattern.compile("=");
    public static final String KEEP_ALIVE_TIMEOUT_HEADER_ATTR = "timeout";
    private final HttpResponse nettyResponse;
    private final HttpResponseHeaders responseHeaders;
    private final HttpVersion httpVersion;
    private final HttpResponseStatus status;
    private final CookiesHolder cookiesHolder;

    public HttpClientResponse(HttpResponse nettyResponse, UnicastContentSubject<T> content) {
        super(content);
        this.nettyResponse = nettyResponse;
        this.httpVersion = this.nettyResponse.getProtocolVersion();
        this.status = this.nettyResponse.getStatus();
        this.responseHeaders = new HttpResponseHeaders(nettyResponse);
        this.cookiesHolder = CookiesHolder.newClientResponseHolder(nettyResponse.headers());
    }

    public HttpResponseHeaders getHeaders() {
        return this.responseHeaders;
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public Map<String, Set<Cookie>> getCookies() {
        return this.cookiesHolder.getAllCookies();
    }

    void updateNoContentSubscriptionTimeoutIfNotScheduled(long noContentSubscriptionTimeout, TimeUnit timeUnit) {
        this.content.updateTimeoutIfNotScheduled(noContentSubscriptionTimeout, timeUnit);
    }

    public Long getKeepAliveTimeoutSeconds() {
        String[] pairs;
        String keepAliveHeader = this.responseHeaders.get(KEEP_ALIVE_HEADER_NAME);
        if (null != keepAliveHeader && !keepAliveHeader.isEmpty() && (pairs = PATTERN_COMMA.split(keepAliveHeader)) != null) {
            for (String pair : pairs) {
                String[] nameValue = PATTERN_EQUALS.split(pair.trim());
                if (nameValue == null || nameValue.length < 2) continue;
                String name = nameValue[0].trim().toLowerCase();
                String value = nameValue[1].trim();
                if (!KEEP_ALIVE_TIMEOUT_HEADER_ATTR.equals(name)) continue;
                try {
                    return Long.valueOf(value);
                }
                catch (NumberFormatException e) {
                    logger.info("Invalid HTTP keep alive timeout value. Keep alive header: " + keepAliveHeader + ", timeout attribute value: " + nameValue[1], (Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }
}

