/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon;

import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ClientOptions {
    private Map<IClientConfigKey<?>, Object> options = new ConcurrentHashMap();

    private ClientOptions() {
    }

    public static ClientOptions create() {
        return new ClientOptions();
    }

    public static ClientOptions from(IClientConfig config) {
        ClientOptions options = new ClientOptions();
        for (IClientConfigKey key : IClientConfigKey.Keys.keys()) {
            Object value = config.get(key);
            if (value == null) continue;
            options.options.put(key, value);
        }
        return options;
    }

    public ClientOptions withDiscoveryServiceIdentifier(String identifier) {
        this.options.put(IClientConfigKey.Keys.DeploymentContextBasedVipAddresses, identifier);
        return this;
    }

    public ClientOptions withConfigurationBasedServerList(String serverList) {
        this.options.put(IClientConfigKey.Keys.ListOfServers, serverList);
        return this;
    }

    public ClientOptions withMaxAutoRetries(int value) {
        this.options.put(IClientConfigKey.Keys.MaxAutoRetries, value);
        return this;
    }

    public ClientOptions withMaxAutoRetriesNextServer(int value) {
        this.options.put(IClientConfigKey.Keys.MaxAutoRetriesNextServer, value);
        return this;
    }

    public ClientOptions withRetryOnAllOperations(boolean value) {
        this.options.put(IClientConfigKey.Keys.OkToRetryOnAllOperations, value);
        return this;
    }

    public ClientOptions withMaxConnectionsPerHost(int value) {
        this.options.put(IClientConfigKey.Keys.MaxConnectionsPerHost, value);
        return this;
    }

    public ClientOptions withMaxTotalConnections(int value) {
        this.options.put(IClientConfigKey.Keys.MaxTotalConnections, value);
        return this;
    }

    public ClientOptions withConnectTimeout(int value) {
        this.options.put(IClientConfigKey.Keys.ConnectTimeout, value);
        return this;
    }

    public ClientOptions withReadTimeout(int value) {
        this.options.put(IClientConfigKey.Keys.ReadTimeout, value);
        return this;
    }

    public ClientOptions withFollowRedirects(boolean value) {
        this.options.put(IClientConfigKey.Keys.FollowRedirects, value);
        return this;
    }

    public ClientOptions withConnectionPoolIdleEvictTimeMilliseconds(int value) {
        this.options.put(IClientConfigKey.Keys.ConnIdleEvictTimeMilliSeconds, value);
        return this;
    }

    public ClientOptions withLoadBalancerEnabled(boolean value) {
        this.options.put(IClientConfigKey.Keys.InitializeNFLoadBalancer, value);
        return this;
    }

    Map<IClientConfigKey<?>, Object> getOptions() {
        return this.options;
    }
}

