/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.bootstrap.Bootstrap;
import java.util.Objects;
import java.util.function.Function;
import reactor.netty.ConnectionObserver;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientOperator;
import reactor.netty.tcp.TcpClient;

final class HttpClientObserve
extends HttpClientOperator
implements Function<Bootstrap, Bootstrap> {
    final ConnectionObserver observer;

    HttpClientObserve(HttpClient client, ConnectionObserver observer) {
        super(client);
        this.observer = Objects.requireNonNull(observer, "observer");
    }

    @Override
    protected TcpClient tcpConfiguration() {
        return this.source.tcpConfiguration().bootstrap(this);
    }

    @Override
    public Bootstrap apply(Bootstrap b) {
        ConnectionObserver observer = BootstrapHandlers.connectionObserver(b);
        BootstrapHandlers.connectionObserver(b, observer.then(this.observer));
        return b;
    }
}

