/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.exception.converter;

import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.ExceptionConverter;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExceptionConverter
implements ExceptionConverter<Throwable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExceptionConverter.class);
    public static final int ORDER = Integer.MAX_VALUE;

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean canConvert(Throwable throwable) {
        return true;
    }

    @Override
    public InvocationException convert(@Nullable Invocation invocation, Throwable throwable, Response.StatusType genericStatus) {
        String msg = throwable.getMessage();
        if (msg == null) {
            msg = "Unexpected exception when processing.";
        }
        LOGGER.error("convert unknown exception({}) to InvocationException, message={}.", (Object)throwable.getClass().getName(), (Object)msg);
        return new InvocationException(genericStatus, ExceptionConverter.getGenericCode(genericStatus), msg, throwable);
    }
}

