/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.protostuff.compiler.model.Proto;
import org.apache.servicecomb.foundation.protobuf.ProtoMapper;
import org.apache.servicecomb.foundation.protobuf.internal.bean.BeanDescriptorManager;
import org.apache.servicecomb.foundation.protobuf.internal.parser.ProtoParser;

public class ProtoMapperFactory {
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final BeanDescriptorManager beanDescriptorManager;
    private final ProtoParser protoParser = new ProtoParser();

    public ProtoMapperFactory() {
        this.jsonMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.beanDescriptorManager = new BeanDescriptorManager(this.jsonMapper.getSerializationConfig());
    }

    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public BeanDescriptorManager getBeanDescriptorManager() {
        return this.beanDescriptorManager;
    }

    public ProtoMapper createFromContent(String content) {
        Proto proto = this.protoParser.parseFromContent(content);
        return this.create(proto);
    }

    public ProtoMapper createFromName(String name) {
        Proto proto = this.protoParser.parse(name);
        return this.create(proto);
    }

    public ProtoMapper create(Proto proto) {
        return new ProtoMapper(this.jsonMapper, this.beanDescriptorManager, proto);
    }
}

