/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common;

import com.google.common.annotations.VisibleForTesting;
import org.springframework.core.env.Environment;

public class LegacyPropertyFactory {
    private static Environment environment;

    public LegacyPropertyFactory(Environment environment) {
        LegacyPropertyFactory.environment = environment;
    }

    @VisibleForTesting
    public static void setEnvironment(Environment environment) {
        LegacyPropertyFactory.environment = environment;
    }

    public static <T> T getProperty(String key, Class<T> targetType) {
        return (T)environment.getProperty(key, targetType);
    }

    public static <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        return (T)environment.getProperty(key, targetType, defaultValue);
    }

    public static boolean getBooleanProperty(String key, boolean defaultValue) {
        return (Boolean)environment.getProperty(key, Boolean.TYPE, (Object)defaultValue);
    }

    public static int getIntProperty(String key, int defaultValue) {
        return (Integer)environment.getProperty(key, Integer.TYPE, (Object)defaultValue);
    }

    public static long getLongProperty(String key, long defaultValue) {
        return (Long)environment.getProperty(key, Long.TYPE, (Object)defaultValue);
    }

    public static String getStringProperty(String key) {
        return environment.getProperty(key);
    }

    public static String getStringProperty(String key, String defaultValue) {
        return environment.getProperty(key, defaultValue);
    }

    public static Environment getEnvironment() {
        return environment;
    }
}

