/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core;

import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.configuration.api.DynamicConfigurationService;
import org.apache.skywalking.oap.server.core.ComponentLibraryCatalogUtil;
import org.apache.skywalking.oap.server.core.CoreModule;
import org.apache.skywalking.oap.server.core.CoreModuleConfig;
import org.apache.skywalking.oap.server.core.RunningMode;
import org.apache.skywalking.oap.server.core.analysis.ApdexThresholdConfig;
import org.apache.skywalking.oap.server.core.analysis.DisableRegister;
import org.apache.skywalking.oap.server.core.analysis.StreamAnnotationListener;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterEntity;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.apache.skywalking.oap.server.core.analysis.metrics.ApdexMetrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.analysis.worker.TopNStreamProcessor;
import org.apache.skywalking.oap.server.core.annotation.AnnotationScan;
import org.apache.skywalking.oap.server.core.cache.AsyncProfilerTaskCache;
import org.apache.skywalking.oap.server.core.cache.CacheUpdateTimer;
import org.apache.skywalking.oap.server.core.cache.NetworkAddressAliasCache;
import org.apache.skywalking.oap.server.core.cache.PprofTaskCache;
import org.apache.skywalking.oap.server.core.cache.ProfileTaskCache;
import org.apache.skywalking.oap.server.core.cluster.ClusterCoordinator;
import org.apache.skywalking.oap.server.core.cluster.OAPNodeChecker;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.command.CommandService;
import org.apache.skywalking.oap.server.core.config.ComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.config.ConfigService;
import org.apache.skywalking.oap.server.core.config.DownSamplingConfigService;
import org.apache.skywalking.oap.server.core.config.HierarchyDefinitionService;
import org.apache.skywalking.oap.server.core.config.IComponentLibraryCatalogService;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.config.group.EndpointNameGroupService;
import org.apache.skywalking.oap.server.core.config.group.EndpointNameGrouping;
import org.apache.skywalking.oap.server.core.config.group.EndpointNameGroupingRuleWatcher;
import org.apache.skywalking.oap.server.core.config.group.openapi.EndpointNameGroupingRule4OpenapiWatcher;
import org.apache.skywalking.oap.server.core.hierarchy.HierarchyService;
import org.apache.skywalking.oap.server.core.logging.LoggingConfigWatcher;
import org.apache.skywalking.oap.server.core.management.ui.menu.UIMenuInitializer;
import org.apache.skywalking.oap.server.core.management.ui.menu.UIMenuManagementService;
import org.apache.skywalking.oap.server.core.management.ui.template.UITemplateInitializer;
import org.apache.skywalking.oap.server.core.management.ui.template.UITemplateManagementService;
import org.apache.skywalking.oap.server.core.oal.rt.DisableOALDefine;
import org.apache.skywalking.oap.server.core.oal.rt.OALEngineLoaderService;
import org.apache.skywalking.oap.server.core.profiling.asyncprofiler.AsyncProfilerMutationService;
import org.apache.skywalking.oap.server.core.profiling.asyncprofiler.AsyncProfilerQueryService;
import org.apache.skywalking.oap.server.core.profiling.continuous.ContinuousProfilingMutationService;
import org.apache.skywalking.oap.server.core.profiling.continuous.ContinuousProfilingQueryService;
import org.apache.skywalking.oap.server.core.profiling.ebpf.EBPFProfilingMutationService;
import org.apache.skywalking.oap.server.core.profiling.ebpf.EBPFProfilingQueryService;
import org.apache.skywalking.oap.server.core.profiling.pprof.PprofMutationService;
import org.apache.skywalking.oap.server.core.profiling.pprof.PprofQueryService;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileTaskMutationService;
import org.apache.skywalking.oap.server.core.profiling.trace.ProfileTaskQueryService;
import org.apache.skywalking.oap.server.core.query.AggregationQueryService;
import org.apache.skywalking.oap.server.core.query.AlarmQueryService;
import org.apache.skywalking.oap.server.core.query.BrowserLogQueryService;
import org.apache.skywalking.oap.server.core.query.EventQueryService;
import org.apache.skywalking.oap.server.core.query.HierarchyQueryService;
import org.apache.skywalking.oap.server.core.query.LogQueryService;
import org.apache.skywalking.oap.server.core.query.MetadataQueryService;
import org.apache.skywalking.oap.server.core.query.MetricsMetadataQueryService;
import org.apache.skywalking.oap.server.core.query.MetricsQueryService;
import org.apache.skywalking.oap.server.core.query.RecordQueryService;
import org.apache.skywalking.oap.server.core.query.TTLStatusQuery;
import org.apache.skywalking.oap.server.core.query.TagAutoCompleteQueryService;
import org.apache.skywalking.oap.server.core.query.TopNRecordsQueryService;
import org.apache.skywalking.oap.server.core.query.TopologyQueryService;
import org.apache.skywalking.oap.server.core.query.TraceQueryService;
import org.apache.skywalking.oap.server.core.remote.RemoteSenderService;
import org.apache.skywalking.oap.server.core.remote.RemoteServiceHandler;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.core.remote.client.RemoteClientManager;
import org.apache.skywalking.oap.server.core.remote.health.HealthCheckServiceHandler;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegister;
import org.apache.skywalking.oap.server.core.server.GRPCHandlerRegisterImpl;
import org.apache.skywalking.oap.server.core.server.HTTPHandlerRegister;
import org.apache.skywalking.oap.server.core.server.HTTPHandlerRegisterImpl;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.core.source.SourceReceiverImpl;
import org.apache.skywalking.oap.server.core.status.ServerStatusService;
import org.apache.skywalking.oap.server.core.storage.PersistenceTimer;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.core.storage.model.IModelManager;
import org.apache.skywalking.oap.server.core.storage.model.ModelCreator;
import org.apache.skywalking.oap.server.core.storage.model.ModelManipulator;
import org.apache.skywalking.oap.server.core.storage.model.StorageModels;
import org.apache.skywalking.oap.server.core.storage.ttl.DataTTLKeeperTimer;
import org.apache.skywalking.oap.server.core.watermark.WatermarkGRPCInterceptor;
import org.apache.skywalking.oap.server.core.watermark.WatermarkWatcher;
import org.apache.skywalking.oap.server.core.worker.IWorkerInstanceGetter;
import org.apache.skywalking.oap.server.core.worker.IWorkerInstanceSetter;
import org.apache.skywalking.oap.server.core.worker.WorkerInstancesService;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.server.ServerException;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCServer;
import org.apache.skywalking.oap.server.library.server.http.HTTPServer;
import org.apache.skywalking.oap.server.library.server.http.HTTPServerConfig;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCollector;
import org.apache.skywalking.oap.server.telemetry.api.TelemetryRelatedContext;

public class CoreModuleProvider
extends ModuleProvider {
    private CoreModuleConfig moduleConfig;
    private GRPCServer grpcServer;
    private HTTPServer httpServer;
    private RemoteClientManager remoteClientManager;
    private final AnnotationScan annotationScan = new AnnotationScan();
    private final StorageModels storageModels = new StorageModels();
    private final SourceReceiverImpl receiver = new SourceReceiverImpl();
    private ApdexThresholdConfig apdexThresholdConfig;
    private EndpointNameGroupingRuleWatcher endpointNameGroupingRuleWatcher;
    private OALEngineLoaderService oalEngineLoaderService;
    private LoggingConfigWatcher loggingConfigWatcher;
    private EndpointNameGroupingRule4OpenapiWatcher endpointNameGroupingRule4OpenapiWatcher;
    private EndpointNameGrouping endpointNameGrouping;
    private HierarchyService hierarchyService;
    private WatermarkWatcher watermarkWatcher;

    public String name() {
        return "default";
    }

    public Class<? extends ModuleDefine> module() {
        return CoreModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<CoreModuleConfig>(){

            public Class type() {
                return CoreModuleConfig.class;
            }

            public void onInitialized(CoreModuleConfig initialized) {
                CoreModuleProvider.this.moduleConfig = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        if (this.moduleConfig.isActiveExtraModelColumns()) {
            DefaultScopeDefine.activeExtraModelColumns();
        }
        this.endpointNameGrouping = new EndpointNameGrouping();
        NamingControl namingControl = new NamingControl(this.moduleConfig.getServiceNameMaxLength(), this.moduleConfig.getInstanceNameMaxLength(), this.moduleConfig.getEndpointNameMaxLength(), this.endpointNameGrouping);
        this.registerServiceImplementation(NamingControl.class, namingControl);
        this.registerServiceImplementation(EndpointNameGroupService.class, this.endpointNameGrouping);
        MeterEntity.setNamingControl(namingControl);
        try {
            this.endpointNameGroupingRuleWatcher = new EndpointNameGroupingRuleWatcher(this, this.endpointNameGrouping);
            if (this.moduleConfig.isEnableEndpointNameGroupingByOpenapi()) {
                this.endpointNameGroupingRule4OpenapiWatcher = new EndpointNameGroupingRule4OpenapiWatcher(this, this.endpointNameGrouping);
            }
        }
        catch (FileNotFoundException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
        AnnotationScan scopeScan = new AnnotationScan();
        scopeScan.registerListener(new DefaultScopeDefine.Listener());
        try {
            scopeScan.scan();
        }
        catch (Exception e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
        this.registerServiceImplementation(MeterSystem.class, new MeterSystem(this.getManager()));
        AnnotationScan oalDisable = new AnnotationScan();
        oalDisable.registerListener(DisableRegister.INSTANCE);
        oalDisable.registerListener(new DisableRegister.SingleDisableScanListener());
        try {
            oalDisable.scan();
        }
        catch (IOException | StorageException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
        this.grpcServer = this.moduleConfig.isGRPCSslEnabled() ? new GRPCServer(this.moduleConfig.getGRPCHost(), this.moduleConfig.getGRPCPort(), this.moduleConfig.getGRPCSslCertChainPath(), this.moduleConfig.getGRPCSslKeyPath(), null) : new GRPCServer(this.moduleConfig.getGRPCHost(), this.moduleConfig.getGRPCPort());
        this.setBootingParameter("oap.internal.comm.host", this.moduleConfig.getGRPCHost());
        this.setBootingParameter("oap.internal.comm.port", this.moduleConfig.getGRPCPort());
        this.setBootingParameter("oap.external.grpc.host", this.moduleConfig.getGRPCHost());
        this.setBootingParameter("oap.external.grpc.port", this.moduleConfig.getGRPCPort());
        if (this.moduleConfig.getMaxConcurrentCallsPerConnection() > 0) {
            this.grpcServer.setMaxConcurrentCallsPerConnection(this.moduleConfig.getMaxConcurrentCallsPerConnection());
        }
        if (this.moduleConfig.getMaxMessageSize() > 0) {
            this.grpcServer.setMaxMessageSize(this.moduleConfig.getMaxMessageSize());
        }
        if (this.moduleConfig.getGRPCThreadPoolSize() > 0) {
            this.grpcServer.setThreadPoolSize(this.moduleConfig.getGRPCThreadPoolSize());
        }
        this.grpcServer.initialize();
        HTTPServerConfig httpServerConfig = HTTPServerConfig.builder().host(this.moduleConfig.getRestHost()).port(this.moduleConfig.getRestPort()).contextPath(this.moduleConfig.getRestContextPath()).idleTimeOut(this.moduleConfig.getRestIdleTimeOut()).acceptQueueSize(this.moduleConfig.getRestAcceptQueueSize()).maxRequestHeaderSize(this.moduleConfig.getHttpMaxRequestHeaderSize()).build();
        this.setBootingParameter("oap.external.http.host", this.moduleConfig.getRestHost());
        this.setBootingParameter("oap.external.http.port", this.moduleConfig.getRestPort());
        this.httpServer = new HTTPServer(httpServerConfig);
        this.httpServer.initialize();
        this.registerServiceImplementation(ConfigService.class, new ConfigService(this.moduleConfig, this));
        this.registerServiceImplementation(ServerStatusService.class, new ServerStatusService(this.getManager()));
        this.registerServiceImplementation(HierarchyDefinitionService.class, new HierarchyDefinitionService(this.moduleConfig));
        this.hierarchyService = new HierarchyService(this.getManager(), this.moduleConfig);
        this.registerServiceImplementation(HierarchyService.class, this.hierarchyService);
        this.registerServiceImplementation(DownSamplingConfigService.class, new DownSamplingConfigService(this.moduleConfig.getDownsampling()));
        this.registerServiceImplementation(GRPCHandlerRegister.class, new GRPCHandlerRegisterImpl(this.grpcServer));
        this.registerServiceImplementation(HTTPHandlerRegister.class, new HTTPHandlerRegisterImpl(this.httpServer));
        this.registerServiceImplementation(IComponentLibraryCatalogService.class, ComponentLibraryCatalogUtil.hold(new ComponentLibraryCatalogService()));
        this.registerServiceImplementation(SourceReceiver.class, this.receiver);
        WorkerInstancesService instancesService = new WorkerInstancesService();
        this.registerServiceImplementation(IWorkerInstanceGetter.class, instancesService);
        this.registerServiceImplementation(IWorkerInstanceSetter.class, instancesService);
        this.registerServiceImplementation(RemoteSenderService.class, new RemoteSenderService(this.getManager()));
        this.registerServiceImplementation(ModelCreator.class, this.storageModels);
        this.registerServiceImplementation(IModelManager.class, this.storageModels);
        this.registerServiceImplementation(ModelManipulator.class, this.storageModels);
        this.registerServiceImplementation(NetworkAddressAliasCache.class, new NetworkAddressAliasCache(this.moduleConfig));
        this.registerServiceImplementation(TopologyQueryService.class, new TopologyQueryService(this.getManager(), this.storageModels));
        this.registerServiceImplementation(MetricsMetadataQueryService.class, new MetricsMetadataQueryService());
        this.registerServiceImplementation(MetricsQueryService.class, new MetricsQueryService(this.getManager()));
        this.registerServiceImplementation(TraceQueryService.class, new TraceQueryService(this.getManager()));
        this.registerServiceImplementation(BrowserLogQueryService.class, new BrowserLogQueryService(this.getManager()));
        this.registerServiceImplementation(LogQueryService.class, new LogQueryService(this.getManager()));
        this.registerServiceImplementation(MetadataQueryService.class, new MetadataQueryService(this.getManager(), this.moduleConfig));
        this.registerServiceImplementation(AggregationQueryService.class, new AggregationQueryService(this.getManager()));
        this.registerServiceImplementation(AlarmQueryService.class, new AlarmQueryService(this.getManager()));
        this.registerServiceImplementation(TopNRecordsQueryService.class, new TopNRecordsQueryService(this.getManager()));
        this.registerServiceImplementation(EventQueryService.class, new EventQueryService(this.getManager()));
        this.registerServiceImplementation(TagAutoCompleteQueryService.class, new TagAutoCompleteQueryService(this.getManager(), this.moduleConfig));
        this.registerServiceImplementation(RecordQueryService.class, new RecordQueryService(this.getManager()));
        this.registerServiceImplementation(HierarchyQueryService.class, new HierarchyQueryService(this.getManager(), this.moduleConfig));
        this.registerServiceImplementation(TTLStatusQuery.class, new TTLStatusQuery(this.getManager(), this.moduleConfig.getMetricsDataTTL(), this.moduleConfig.getRecordDataTTL()));
        this.registerServiceImplementation(ProfileTaskMutationService.class, new ProfileTaskMutationService(this.getManager()));
        this.registerServiceImplementation(ProfileTaskQueryService.class, new ProfileTaskQueryService(this.getManager(), this.moduleConfig));
        this.registerServiceImplementation(ProfileTaskCache.class, new ProfileTaskCache(this.getManager(), this.moduleConfig));
        this.registerServiceImplementation(AsyncProfilerMutationService.class, new AsyncProfilerMutationService(this.getManager()));
        this.registerServiceImplementation(AsyncProfilerQueryService.class, new AsyncProfilerQueryService(this.getManager()));
        this.registerServiceImplementation(AsyncProfilerTaskCache.class, new AsyncProfilerTaskCache(this.getManager(), this.moduleConfig));
        this.registerServiceImplementation(PprofMutationService.class, new PprofMutationService(this.getManager()));
        this.registerServiceImplementation(PprofQueryService.class, new PprofQueryService(this.getManager()));
        this.registerServiceImplementation(PprofTaskCache.class, new PprofTaskCache(this.moduleConfig));
        this.registerServiceImplementation(EBPFProfilingMutationService.class, new EBPFProfilingMutationService(this.getManager()));
        this.registerServiceImplementation(EBPFProfilingQueryService.class, new EBPFProfilingQueryService(this.getManager(), this.moduleConfig, this.storageModels));
        this.registerServiceImplementation(ContinuousProfilingMutationService.class, new ContinuousProfilingMutationService(this.getManager()));
        this.registerServiceImplementation(ContinuousProfilingQueryService.class, new ContinuousProfilingQueryService(this.getManager()));
        this.registerServiceImplementation(CommandService.class, new CommandService(this.getManager()));
        this.oalEngineLoaderService = new OALEngineLoaderService(this.getManager());
        this.registerServiceImplementation(OALEngineLoaderService.class, this.oalEngineLoaderService);
        this.annotationScan.registerListener(new StreamAnnotationListener((ModuleDefineHolder)this.getManager()));
        this.remoteClientManager = this.moduleConfig.isGRPCSslEnabled() ? new RemoteClientManager((ModuleDefineHolder)this.getManager(), this.moduleConfig.getRemoteTimeout(), this.moduleConfig.getGRPCSslTrustedCAPath()) : new RemoteClientManager((ModuleDefineHolder)this.getManager(), this.moduleConfig.getRemoteTimeout());
        this.registerServiceImplementation(RemoteClientManager.class, this.remoteClientManager);
        this.registerServiceImplementation(UITemplateManagementService.class, new UITemplateManagementService(this.getManager()));
        this.registerServiceImplementation(UIMenuManagementService.class, new UIMenuManagementService(this.getManager(), this.moduleConfig));
        if (this.moduleConfig.getMetricsDataTTL() < 2) {
            throw new ModuleStartException("Metric TTL should be at least 2 days, current value is " + this.moduleConfig.getMetricsDataTTL());
        }
        this.setBootingParameter("TTL.metrics", this.moduleConfig.getMetricsDataTTL());
        if (this.moduleConfig.getRecordDataTTL() < 2) {
            throw new ModuleStartException("Record TTL should be at least 2 days, current value is " + this.moduleConfig.getRecordDataTTL());
        }
        this.setBootingParameter("TTL.record", this.moduleConfig.getRecordDataTTL());
        MetricsStreamProcessor metricsStreamProcessor = MetricsStreamProcessor.getInstance();
        metricsStreamProcessor.setL1FlushPeriod(this.moduleConfig.getL1FlushPeriod());
        metricsStreamProcessor.setStorageSessionTimeout(this.moduleConfig.getStorageSessionTimeout());
        metricsStreamProcessor.setMetricsDataTTL(this.moduleConfig.getMetricsDataTTL());
        RecordStreamProcessor.getInstance().setRecordDataTTL(this.moduleConfig.getRecordDataTTL());
        TopNStreamProcessor.getInstance().setTopNWorkerReportCycle(this.moduleConfig.getTopNReportPeriod());
        this.apdexThresholdConfig = new ApdexThresholdConfig(this);
        ApdexMetrics.setDICT(this.apdexThresholdConfig);
        this.loggingConfigWatcher = new LoggingConfigWatcher(this);
        WatermarkGRPCInterceptor.create();
        this.watermarkWatcher = new WatermarkWatcher(this.getManager(), this.moduleConfig.getMaxHeapMemoryUsagePercent(), this.moduleConfig.getMaxDirectMemoryUsage());
    }

    public void start() throws ModuleStartException {
        this.grpcServer.addHandler((BindableService)new RemoteServiceHandler((ModuleDefineHolder)this.getManager()));
        this.grpcServer.addHandler((BindableService)new HealthCheckServiceHandler());
        this.grpcServer.addInterceptor((ServerInterceptor)WatermarkGRPCInterceptor.INSTANCE);
        this.endpointNameGrouping.prepareForHTTPUrlRecognition((MetadataQueryService)this.getService(MetadataQueryService.class), this.moduleConfig.getSyncPeriodHttpUriRecognitionPattern(), this.moduleConfig.getTrainingPeriodHttpUriRecognitionPattern(), this.moduleConfig.getMaxHttpUrisNumberPerService());
        this.oalEngineLoaderService.load(DisableOALDefine.INSTANCE);
        try {
            this.receiver.scan();
            this.annotationScan.scan();
        }
        catch (IOException | IllegalAccessException | InstantiationException | StorageException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
        Address gRPCServerInstanceAddress = new Address(this.moduleConfig.getGRPCHost(), this.moduleConfig.getGRPCPort(), true);
        TelemetryRelatedContext.INSTANCE.setId(gRPCServerInstanceAddress.toString());
        ClusterCoordinator coordinator = (ClusterCoordinator)this.getManager().find("cluster").provider().getService(ClusterCoordinator.class);
        coordinator.registerWatcher(this.remoteClientManager);
        coordinator.start();
        if (CoreModuleConfig.Role.Mixed.name().equalsIgnoreCase(this.moduleConfig.getRole()) || CoreModuleConfig.Role.Aggregator.name().equalsIgnoreCase(this.moduleConfig.getRole())) {
            RemoteInstance gRPCServerInstance = new RemoteInstance(gRPCServerInstanceAddress);
            coordinator.registerRemote(gRPCServerInstance);
        }
        OAPNodeChecker.setROLE(CoreModuleConfig.Role.fromName(this.moduleConfig.getRole()));
        DynamicConfigurationService dynamicConfigurationService = (DynamicConfigurationService)this.getManager().find("configuration").provider().getService(DynamicConfigurationService.class);
        dynamicConfigurationService.registerConfigChangeWatcher((ConfigChangeWatcher)this.apdexThresholdConfig);
        dynamicConfigurationService.registerConfigChangeWatcher((ConfigChangeWatcher)this.endpointNameGroupingRuleWatcher);
        dynamicConfigurationService.registerConfigChangeWatcher((ConfigChangeWatcher)this.loggingConfigWatcher);
        if (this.moduleConfig.isEnableEndpointNameGroupingByOpenapi()) {
            dynamicConfigurationService.registerConfigChangeWatcher((ConfigChangeWatcher)this.endpointNameGroupingRule4OpenapiWatcher);
        }
        dynamicConfigurationService.registerConfigChangeWatcher((ConfigChangeWatcher)this.moduleConfig.getSearchableTracesTagsWatcher());
    }

    public void notifyAfterCompleted() throws ModuleStartException {
        try {
            if (!RunningMode.isInitMode()) {
                this.grpcServer.start();
                this.httpServer.start();
                this.remoteClientManager.start();
            }
        }
        catch (ServerException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
        PersistenceTimer.INSTANCE.start(this.getManager(), this.moduleConfig);
        if (this.moduleConfig.isEnableDataKeeperExecutor()) {
            DataTTLKeeperTimer.INSTANCE.start(this.getManager(), this.moduleConfig);
        }
        CacheUpdateTimer.INSTANCE.start((ModuleDefineHolder)this.getManager(), this.moduleConfig.getMetricsDataTTL());
        try {
            new UITemplateInitializer(this.getManager()).initAll();
        }
        catch (IOException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
        try {
            new UIMenuInitializer(this.getManager()).init();
        }
        catch (IOException e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
        this.hierarchyService.startAutoMatchingServiceHierarchy();
        this.watermarkWatcher.start((MetricsCollector)this.getManager().find("telemetry").provider().getService(MetricsCollector.class));
    }

    public String[] requiredModules() {
        return new String[]{"telemetry", "configuration"};
    }
}

