/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.httpclient.v5;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpHost;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public abstract class HttpClientDoExecuteInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String ERROR_URI = "/_blank";
    private static final ILog LOGGER = LogManager.getLogger(HttpClientDoExecuteInterceptor.class);

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String requestURI;
        if (this.skipIntercept(objInst, method, allArguments, argumentsTypes)) {
            return;
        }
        HttpHost httpHost = this.getHttpHost(objInst, method, allArguments, argumentsTypes);
        ClassicHttpRequest httpRequest = (ClassicHttpRequest)allArguments[1];
        ContextCarrier contextCarrier = new ContextCarrier();
        String remotePeer = httpHost.getHostName() + ":" + this.port(httpHost);
        String uri = httpRequest.getUri().toString();
        String operationName = requestURI = this.getRequestURI(uri);
        AbstractSpan span = ContextManager.createExitSpan((String)operationName, (ContextCarrier)contextCarrier, (String)remotePeer);
        if (ERROR_URI.equals(requestURI)) {
            span.errorOccurred();
        }
        span.setComponent((Component)ComponentsDefine.HTTPCLIENT);
        Tags.URL.set(span, this.buildURL(httpHost, uri));
        Tags.HTTP.METHOD.set(span, httpRequest.getMethod());
        SpanLayer.asHttp((AbstractSpan)span);
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            next = next.next();
            httpRequest.setHeader(next.getHeadKey(), (Object)next.getHeadValue());
        }
    }

    protected boolean skipIntercept(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes) {
        return allArguments[1] == null || this.getHttpHost(objInst, method, allArguments, argumentsTypes) == null;
    }

    protected abstract HttpHost getHttpHost(EnhancedInstance var1, Method var2, Object[] var3, Class<?>[] var4);

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        if (this.skipIntercept(objInst, method, allArguments, argumentsTypes)) {
            return ret;
        }
        if (ret != null) {
            ClassicHttpResponse response = (ClassicHttpResponse)ret;
            int statusCode = response.getCode();
            AbstractSpan span = ContextManager.activeSpan();
            Tags.HTTP_RESPONSE_STATUS_CODE.set(span, Integer.valueOf(statusCode));
            if (statusCode >= 400) {
                span.errorOccurred();
            }
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (this.skipIntercept(objInst, method, allArguments, argumentsTypes)) {
            return;
        }
        AbstractSpan activeSpan = ContextManager.activeSpan();
        activeSpan.log(t);
    }

    private String getRequestURI(String uri) {
        if (this.isUrl(uri)) {
            String requestPath;
            try {
                requestPath = new URL(uri).getPath();
            }
            catch (MalformedURLException e) {
                return ERROR_URI;
            }
            return requestPath != null && requestPath.length() > 0 ? requestPath : "/";
        }
        return uri;
    }

    private boolean isUrl(String uri) {
        String lowerUrl = uri.toLowerCase();
        return lowerUrl.startsWith("http") || lowerUrl.startsWith("https");
    }

    private String buildURL(HttpHost httpHost, String uri) {
        if (this.isUrl(uri)) {
            return uri;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(httpHost.getSchemeName().toLowerCase());
        buff.append("://");
        buff.append(httpHost.getHostName());
        buff.append(":");
        buff.append(this.port(httpHost));
        buff.append(uri);
        return buff.toString();
    }

    private int port(HttpHost httpHost) {
        int port = httpHost.getPort();
        return port > 0 ? port : ("https".equals(httpHost.getSchemeName().toLowerCase()) ? 443 : 80);
    }
}

