/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser;

import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.AbstractURLParser;
import org.apache.skywalking.apm.plugin.jdbc.connectionurl.parser.URLLocation;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class SqliteURLParser
extends AbstractURLParser {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = -1;
    private static final String DB_TYPE = "Sqlite";

    public SqliteURLParser(String url) {
        super(url);
    }

    @Override
    protected URLLocation fetchDatabaseHostsIndexRange() {
        return null;
    }

    @Override
    protected URLLocation fetchDatabaseNameIndexRange() {
        int databaseEndTag;
        int databaseStartTag = this.url.lastIndexOf("/");
        if (databaseStartTag == -1) {
            databaseStartTag = this.url.lastIndexOf(":");
        }
        if ((databaseEndTag = this.url.indexOf("?")) == -1) {
            databaseEndTag = this.url.length();
        }
        return new URLLocation(databaseStartTag + 1, databaseEndTag);
    }

    @Override
    public ConnectionInfo parse() {
        return new ConnectionInfo(ComponentsDefine.SQLITE_JDBC_DRIVER, DB_TYPE, DEFAULT_HOST, -1, this.fetchDatabaseNameFromURL());
    }
}

