/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.ClientUtils;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.ConnectionState;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.HostResolver;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.AuthenticationException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.LogContext;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;

final class ClusterConnectionStates {
    static final int RECONNECT_BACKOFF_EXP_BASE = 2;
    static final double RECONNECT_BACKOFF_JITTER = 0.2;
    static final int CONNECTION_SETUP_TIMEOUT_EXP_BASE = 2;
    static final double CONNECTION_SETUP_TIMEOUT_JITTER = 0.2;
    private final Map<String, NodeConnectionState> nodeState;
    private final Logger log;
    private final HostResolver hostResolver;
    private final Set<String> connectingNodes;
    private final ExponentialBackoff reconnectBackoff;
    private final ExponentialBackoff connectionSetupTimeout;

    public ClusterConnectionStates(long reconnectBackoffMs, long reconnectBackoffMaxMs, long connectionSetupTimeoutMs, long connectionSetupTimeoutMaxMs, LogContext logContext, HostResolver hostResolver) {
        this.log = logContext.logger(ClusterConnectionStates.class);
        this.reconnectBackoff = new ExponentialBackoff(reconnectBackoffMs, 2, reconnectBackoffMaxMs, 0.2);
        this.connectionSetupTimeout = new ExponentialBackoff(connectionSetupTimeoutMs, 2, connectionSetupTimeoutMaxMs, 0.2);
        this.nodeState = new HashMap<String, NodeConnectionState>();
        this.connectingNodes = new HashSet<String>();
        this.hostResolver = hostResolver;
    }

    public boolean canConnect(String id, long now) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state == null) {
            return true;
        }
        return state.state.isDisconnected() && now - state.lastConnectAttemptMs >= state.reconnectBackoffMs;
    }

    public boolean isBlackedOut(String id, long now) {
        NodeConnectionState state = this.nodeState.get(id);
        return state != null && state.state.isDisconnected() && now - state.lastConnectAttemptMs < state.reconnectBackoffMs;
    }

    public long connectionDelay(String id, long now) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state == null) {
            return 0L;
        }
        if (state.state == ConnectionState.CONNECTING) {
            return this.connectionSetupTimeoutMs(id);
        }
        if (state.state.isDisconnected()) {
            long timeWaited = now - state.lastConnectAttemptMs;
            return Math.max(state.reconnectBackoffMs - timeWaited, 0L);
        }
        return Long.MAX_VALUE;
    }

    public boolean isConnecting(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        return state != null && state.state == ConnectionState.CONNECTING;
    }

    public boolean isPreparingConnection(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        return state != null && (state.state == ConnectionState.CONNECTING || state.state == ConnectionState.CHECKING_API_VERSIONS);
    }

    public void connecting(String id, long now, String host) {
        NodeConnectionState connectionState = this.nodeState.get(id);
        if (connectionState != null && connectionState.host().equals(host)) {
            connectionState.lastConnectAttemptMs = now;
            connectionState.state = ConnectionState.CONNECTING;
            connectionState.moveToNextAddress();
            this.connectingNodes.add(id);
            return;
        }
        if (connectionState != null) {
            this.log.info("Hostname for node {} changed from {} to {}.", id, connectionState.host(), host);
        }
        this.nodeState.put(id, new NodeConnectionState(ConnectionState.CONNECTING, now, this.reconnectBackoff.backoff(0L), this.connectionSetupTimeout.backoff(0L), host, this.hostResolver, this.log));
        this.connectingNodes.add(id);
    }

    public InetAddress currentAddress(String id) throws UnknownHostException {
        return this.nodeState(id).currentAddress();
    }

    public void disconnected(String id, long now) {
        NodeConnectionState nodeState = this.nodeState(id);
        nodeState.lastConnectAttemptMs = now;
        this.updateReconnectBackoff(nodeState);
        if (nodeState.state == ConnectionState.CONNECTING) {
            this.updateConnectionSetupTimeout(nodeState);
            this.connectingNodes.remove(id);
        } else {
            this.resetConnectionSetupTimeout(nodeState);
            if (nodeState.state.isConnected()) {
                nodeState.clearAddresses();
            }
        }
        nodeState.state = ConnectionState.DISCONNECTED;
    }

    public void throttle(String id, long throttleUntilTimeMs) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state != null && state.throttleUntilTimeMs < throttleUntilTimeMs) {
            state.throttleUntilTimeMs = throttleUntilTimeMs;
        }
    }

    public long throttleDelayMs(String id, long now) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state != null && state.throttleUntilTimeMs > now) {
            return state.throttleUntilTimeMs - now;
        }
        return 0L;
    }

    public long pollDelayMs(String id, long now) {
        long throttleDelayMs = this.throttleDelayMs(id, now);
        if (this.isConnected(id) && throttleDelayMs > 0L) {
            return throttleDelayMs;
        }
        return this.connectionDelay(id, now);
    }

    public void checkingApiVersions(String id) {
        NodeConnectionState nodeState = this.nodeState(id);
        nodeState.state = ConnectionState.CHECKING_API_VERSIONS;
        this.resetConnectionSetupTimeout(nodeState);
        this.connectingNodes.remove(id);
    }

    public void ready(String id) {
        NodeConnectionState nodeState = this.nodeState(id);
        nodeState.state = ConnectionState.READY;
        nodeState.authenticationException = null;
        this.resetReconnectBackoff(nodeState);
        this.resetConnectionSetupTimeout(nodeState);
        this.connectingNodes.remove(id);
    }

    public void authenticationFailed(String id, long now, AuthenticationException exception) {
        NodeConnectionState nodeState = this.nodeState(id);
        nodeState.authenticationException = exception;
        nodeState.state = ConnectionState.AUTHENTICATION_FAILED;
        nodeState.lastConnectAttemptMs = now;
        this.updateReconnectBackoff(nodeState);
    }

    public boolean isReady(String id, long now) {
        return this.isReady(this.nodeState.get(id), now);
    }

    private boolean isReady(NodeConnectionState state, long now) {
        return state != null && state.state == ConnectionState.READY && state.throttleUntilTimeMs <= now;
    }

    public boolean hasReadyNodes(long now) {
        for (Map.Entry<String, NodeConnectionState> entry : this.nodeState.entrySet()) {
            if (!this.isReady(entry.getValue(), now)) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        return state != null && state.state.isConnected();
    }

    public boolean isDisconnected(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        return state != null && state.state.isDisconnected();
    }

    public AuthenticationException authenticationException(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        return state != null ? state.authenticationException : null;
    }

    private void resetReconnectBackoff(NodeConnectionState nodeState) {
        nodeState.failedAttempts = 0L;
        nodeState.reconnectBackoffMs = this.reconnectBackoff.backoff(0L);
    }

    private void resetConnectionSetupTimeout(NodeConnectionState nodeState) {
        nodeState.failedConnectAttempts = 0L;
        nodeState.connectionSetupTimeoutMs = this.connectionSetupTimeout.backoff(0L);
    }

    private void updateReconnectBackoff(NodeConnectionState nodeState) {
        nodeState.reconnectBackoffMs = this.reconnectBackoff.backoff(nodeState.failedAttempts);
        ++nodeState.failedAttempts;
    }

    private void updateConnectionSetupTimeout(NodeConnectionState nodeState) {
        ++nodeState.failedConnectAttempts;
        nodeState.connectionSetupTimeoutMs = this.connectionSetupTimeout.backoff(nodeState.failedConnectAttempts);
    }

    public void remove(String id) {
        this.nodeState.remove(id);
        this.connectingNodes.remove(id);
    }

    public ConnectionState connectionState(String id) {
        return this.nodeState((String)id).state;
    }

    private NodeConnectionState nodeState(String id) {
        NodeConnectionState state = this.nodeState.get(id);
        if (state == null) {
            throw new IllegalStateException("No entry found for connection " + id);
        }
        return state;
    }

    Set<String> connectingNodes() {
        return this.connectingNodes;
    }

    public long lastConnectAttemptMs(String id) {
        NodeConnectionState nodeState = this.nodeState.get(id);
        return nodeState == null ? 0L : nodeState.lastConnectAttemptMs;
    }

    public long connectionSetupTimeoutMs(String id) {
        NodeConnectionState nodeState = this.nodeState(id);
        return nodeState.connectionSetupTimeoutMs;
    }

    public boolean isConnectionSetupTimeout(String id, long now) {
        NodeConnectionState nodeState = this.nodeState(id);
        if (nodeState.state != ConnectionState.CONNECTING) {
            throw new IllegalStateException("Node " + id + " is not in connecting state");
        }
        return now - this.lastConnectAttemptMs(id) > this.connectionSetupTimeoutMs(id);
    }

    public List<String> nodesWithConnectionSetupTimeout(long now) {
        return this.connectingNodes.stream().filter(id -> this.isConnectionSetupTimeout((String)id, now)).collect(Collectors.toList());
    }

    private static class NodeConnectionState {
        private final String host;
        private final HostResolver hostResolver;
        private final Logger log;
        ConnectionState state;
        AuthenticationException authenticationException;
        long lastConnectAttemptMs;
        long failedAttempts;
        long failedConnectAttempts;
        long reconnectBackoffMs;
        long connectionSetupTimeoutMs;
        long throttleUntilTimeMs;
        private List<InetAddress> addresses;
        private int addressIndex;
        private InetAddress lastAttemptedAddress;

        private NodeConnectionState(ConnectionState state, long lastConnectAttemptMs, long reconnectBackoffMs, long connectionSetupTimeoutMs, String host, HostResolver hostResolver, Logger log) {
            this.state = state;
            this.addresses = Collections.emptyList();
            this.addressIndex = -1;
            this.authenticationException = null;
            this.lastConnectAttemptMs = lastConnectAttemptMs;
            this.failedAttempts = 0L;
            this.reconnectBackoffMs = reconnectBackoffMs;
            this.connectionSetupTimeoutMs = connectionSetupTimeoutMs;
            this.throttleUntilTimeMs = 0L;
            this.host = host;
            this.hostResolver = hostResolver;
            this.log = log;
        }

        public String host() {
            return this.host;
        }

        private InetAddress currentAddress() throws UnknownHostException {
            InetAddress currentAddress;
            if (this.addresses.isEmpty()) {
                this.resolveAddresses();
            }
            this.lastAttemptedAddress = currentAddress = this.addresses.get(this.addressIndex);
            return currentAddress;
        }

        private void moveToNextAddress() {
            if (this.addresses.isEmpty()) {
                return;
            }
            this.addressIndex = (this.addressIndex + 1) % this.addresses.size();
            if (this.addressIndex == 0) {
                this.clearAddresses();
            }
        }

        private void resolveAddresses() throws UnknownHostException {
            this.addresses = ClientUtils.resolve(this.host, this.hostResolver);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Resolved host {} to addresses {}", (Object)this.host, (Object)this.addresses);
            }
            this.addressIndex = 0;
            if (this.addresses.size() > 1 && this.addresses.get(this.addressIndex).equals(this.lastAttemptedAddress)) {
                ++this.addressIndex;
            }
        }

        private void clearAddresses() {
            this.addresses = Collections.emptyList();
        }

        public String toString() {
            return "NodeConnectionState(state=" + (Object)((Object)this.state) + ", lastConnectAttemptMs=" + this.lastConnectAttemptMs + ", failedAttempts=" + this.failedAttempts + ", failedConnectAttempts=" + this.failedConnectAttempts + ", throttleUntilTimeMs=" + this.throttleUntilTimeMs + ")";
        }
    }
}

