/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.AcknowledgementCommitCallback;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.Acknowledgements;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.ConsumerUtils;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicIdPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.ApiException;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;
import org.apache.skywalking.apm.dependencies.org.slf4j.LoggerFactory;

public class AcknowledgementCommitCallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AcknowledgementCommitCallbackHandler.class);
    private final AcknowledgementCommitCallback acknowledgementCommitCallback;
    private boolean enteredCallback = false;

    AcknowledgementCommitCallbackHandler(AcknowledgementCommitCallback acknowledgementCommitCallback) {
        this.acknowledgementCommitCallback = acknowledgementCommitCallback;
    }

    public boolean hasEnteredCallback() {
        return this.enteredCallback;
    }

    void onComplete(List<Map<TopicIdPartition, Acknowledgements>> acknowledgementsMapList) {
        ArrayList exceptions = new ArrayList();
        acknowledgementsMapList.forEach(acknowledgementsMap -> acknowledgementsMap.forEach((partition, acknowledgements) -> {
            ApiException exception = null;
            if (acknowledgements.getAcknowledgeErrorCode() != null) {
                exception = acknowledgements.getAcknowledgeErrorCode().exception();
            }
            Set<Long> offsets = acknowledgements.getAcknowledgementsTypeMap().keySet();
            Set<Long> offsetsCopy = Collections.unmodifiableSet(offsets);
            this.enteredCallback = true;
            try {
                this.acknowledgementCommitCallback.onComplete(Collections.singletonMap(partition, offsetsCopy), exception);
            }
            catch (Throwable e) {
                LOG.error("Exception thrown by acknowledgement commit callback", e);
                exceptions.add(e);
            }
            finally {
                this.enteredCallback = false;
            }
        }));
        if (!exceptions.isEmpty()) {
            throw ConsumerUtils.maybeWrapAsKafkaException((Throwable)exceptions.get(0), "Exception thrown by acknowledgement commit callback");
        }
    }
}

