/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.TopicPartition;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Utils;

public class Fetch<K, V> {
    private final Map<TopicPartition, List<ConsumerRecord<K, V>>> records;
    private boolean positionAdvanced;
    private int numRecords;

    public static <K, V> Fetch<K, V> empty() {
        return new Fetch<K, V>(new HashMap<TopicPartition, List<ConsumerRecord<K, V>>>(), false, 0);
    }

    public static <K, V> Fetch<K, V> forPartition(TopicPartition partition, List<ConsumerRecord<K, V>> records, boolean positionAdvanced) {
        HashMap<TopicPartition, List<ConsumerRecord<K, V>>> recordsMap = records.isEmpty() ? new HashMap<TopicPartition, List<ConsumerRecord<K, V>>>() : Utils.mkMap(Utils.mkEntry(partition, records));
        return new Fetch<K, V>(recordsMap, positionAdvanced, records.size());
    }

    private Fetch(Map<TopicPartition, List<ConsumerRecord<K, V>>> records, boolean positionAdvanced, int numRecords) {
        this.records = records;
        this.positionAdvanced = positionAdvanced;
        this.numRecords = numRecords;
    }

    public void add(Fetch<K, V> fetch) {
        Objects.requireNonNull(fetch);
        this.addRecords(fetch.records);
        this.positionAdvanced |= fetch.positionAdvanced;
    }

    public Map<TopicPartition, List<ConsumerRecord<K, V>>> records() {
        return Collections.unmodifiableMap(this.records);
    }

    public boolean positionAdvanced() {
        return this.positionAdvanced;
    }

    public int numRecords() {
        return this.numRecords;
    }

    public boolean isEmpty() {
        return this.numRecords == 0 && !this.positionAdvanced;
    }

    private void addRecords(Map<TopicPartition, List<ConsumerRecord<K, V>>> records) {
        records.forEach((partition, partRecords) -> {
            this.numRecords += partRecords.size();
            List<ConsumerRecord<K, V>> currentRecords = this.records.get(partition);
            if (currentRecords == null) {
                this.records.put((TopicPartition)partition, (List<ConsumerRecord<TopicPartition, List>>)partRecords);
            } else {
                ArrayList<ConsumerRecord<K, V>> newRecords = new ArrayList<ConsumerRecord<K, V>>(currentRecords.size() + partRecords.size());
                newRecords.addAll(currentRecords);
                newRecords.addAll((Collection<ConsumerRecord<K, V>>)partRecords);
                this.records.put((TopicPartition)partition, newRecords);
            }
        });
    }
}

