/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals;

import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.LogContext;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;

class RequestState {
    private final Logger log;
    protected final String owner;
    static final int RETRY_BACKOFF_EXP_BASE = 2;
    static final double RETRY_BACKOFF_JITTER = 0.2;
    protected final ExponentialBackoff exponentialBackoff;
    protected long lastSentMs = -1L;
    protected long lastReceivedMs = -1L;
    protected int numAttempts = 0;
    protected long backoffMs = 0L;
    private boolean requestInFlight = false;

    public RequestState(LogContext logContext, String owner, long retryBackoffMs, long retryBackoffMaxMs) {
        this.log = logContext.logger(RequestState.class);
        this.owner = owner;
        this.exponentialBackoff = new ExponentialBackoff(retryBackoffMs, 2, retryBackoffMaxMs, 0.2);
    }

    RequestState(LogContext logContext, String owner, long retryBackoffMs, int retryBackoffExpBase, long retryBackoffMaxMs, double jitter) {
        this.log = logContext.logger(RequestState.class);
        this.owner = owner;
        this.exponentialBackoff = new ExponentialBackoff(retryBackoffMs, retryBackoffExpBase, retryBackoffMaxMs, jitter);
    }

    public void reset() {
        this.requestInFlight = false;
        this.lastSentMs = -1L;
        this.lastReceivedMs = -1L;
        this.numAttempts = 0;
        this.backoffMs = this.exponentialBackoff.backoff(0L);
    }

    public boolean canSendRequest(long currentTimeMs) {
        if (this.requestInFlight()) {
            this.log.trace("An inflight request already exists for {}", (Object)this);
            return false;
        }
        long remainingBackoffMs = this.remainingBackoffMs(currentTimeMs);
        if (remainingBackoffMs <= 0L) {
            return true;
        }
        this.log.trace("{} ms remain before another request should be sent for {}", (Object)remainingBackoffMs, (Object)this);
        return false;
    }

    public boolean requestInFlight() {
        return this.requestInFlight;
    }

    public void onSendAttempt(long currentTimeMs) {
        this.requestInFlight = true;
        this.lastSentMs = currentTimeMs;
    }

    public void onSuccessfulAttempt(long currentTimeMs) {
        this.requestInFlight = false;
        this.lastReceivedMs = currentTimeMs;
        this.backoffMs = this.exponentialBackoff.backoff(0L);
        this.numAttempts = 0;
    }

    public void onFailedAttempt(long currentTimeMs) {
        this.requestInFlight = false;
        this.lastReceivedMs = currentTimeMs;
        this.backoffMs = this.exponentialBackoff.backoff(this.numAttempts);
        ++this.numAttempts;
    }

    long remainingBackoffMs(long currentTimeMs) {
        long timeSinceLastReceiveMs = currentTimeMs - this.lastReceivedMs;
        return Math.max(0L, this.backoffMs - timeSinceLastReceiveMs);
    }

    protected String toStringBase() {
        return "owner='" + this.owner + '\'' + ", exponentialBackoff=" + this.exponentialBackoff + ", lastSentMs=" + this.lastSentMs + ", lastReceivedMs=" + this.lastReceivedMs + ", numAttempts=" + this.numAttempts + ", backoffMs=" + this.backoffMs + ", requestInFlight=" + this.requestInFlight;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.toStringBase() + '}';
    }
}

