/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.events;

import java.io.Closeable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.function.Supplier;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.ConsumerNetworkThread;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.ConsumerUtils;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.RequestManagers;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.events.ApplicationEventProcessor;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.events.CompletableEventReaper;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.internals.IdempotentCloser;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.LogContext;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Time;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Utils;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;

public class ApplicationEventHandler
implements Closeable {
    private final Logger log;
    private final BlockingQueue<ApplicationEvent> applicationEventQueue;
    private final ConsumerNetworkThread networkThread;
    private final IdempotentCloser closer = new IdempotentCloser();

    public ApplicationEventHandler(LogContext logContext, Time time, BlockingQueue<ApplicationEvent> applicationEventQueue, CompletableEventReaper applicationEventReaper, Supplier<ApplicationEventProcessor> applicationEventProcessorSupplier, Supplier<NetworkClientDelegate> networkClientDelegateSupplier, Supplier<RequestManagers> requestManagersSupplier) {
        this.log = logContext.logger(ApplicationEventHandler.class);
        this.applicationEventQueue = applicationEventQueue;
        this.networkThread = new ConsumerNetworkThread(logContext, time, applicationEventQueue, applicationEventReaper, applicationEventProcessorSupplier, networkClientDelegateSupplier, requestManagersSupplier);
        this.networkThread.start();
    }

    public void add(ApplicationEvent event) {
        Objects.requireNonNull(event, "ApplicationEvent provided to add must be non-null");
        this.applicationEventQueue.add(event);
        this.wakeupNetworkThread();
    }

    public void wakeupNetworkThread() {
        this.networkThread.wakeup();
    }

    public long maximumTimeToWait() {
        return this.networkThread.maximumTimeToWait();
    }

    public <T> T addAndGet(CompletableApplicationEvent<T> event) {
        Objects.requireNonNull(event, "CompletableApplicationEvent provided to addAndGet must be non-null");
        this.add(event);
        return ConsumerUtils.getResult(event.future());
    }

    @Override
    public void close() {
        this.close(Duration.ZERO);
    }

    public void close(Duration timeout) {
        this.closer.close(() -> Utils.closeQuietly(() -> this.networkThread.close(timeout), "consumer network thread"), () -> this.log.warn("The application event handler was already closed"));
    }
}

