/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.events;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.clients.consumer.internals.events.CompletableEvent;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.TimeoutException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.LogContext;
import org.apache.skywalking.apm.dependencies.org.slf4j.Logger;

public class CompletableEventReaper {
    private final Logger log;
    private final List<CompletableEvent<?>> tracked;

    public CompletableEventReaper(LogContext logContext) {
        this.log = logContext.logger(CompletableEventReaper.class);
        this.tracked = new ArrayList();
    }

    public void add(CompletableEvent<?> event) {
        this.tracked.add(Objects.requireNonNull(event, "Event to track must be non-null"));
    }

    public void reap(long currentTimeMs) {
        Consumer<CompletableEvent> expireEvent = event -> {
            long pastDueMs = currentTimeMs - event.deadlineMs();
            TimeoutException error = new TimeoutException(String.format("%s was %s ms past its expiration of %s", event.getClass().getSimpleName(), pastDueMs, event.deadlineMs()));
            if (event.future().completeExceptionally(error)) {
                this.log.debug("Event {} completed exceptionally since its expiration of {} passed {} ms ago", event, event.deadlineMs(), pastDueMs);
            } else {
                this.log.trace("Event {} not completed exceptionally since it was previously completed", event);
            }
        };
        this.tracked.stream().filter(e -> !e.future().isDone()).filter(e -> currentTimeMs >= e.deadlineMs()).forEach(expireEvent);
        this.tracked.removeIf(e -> e.future().isDone());
    }

    public void reap(Collection<?> events) {
        Objects.requireNonNull(events, "Event queue to reap must be non-null");
        Consumer<CompletableEvent> expireEvent = event -> {
            TimeoutException error = new TimeoutException(String.format("%s could not be completed before the consumer closed", event.getClass().getSimpleName()));
            if (event.future().completeExceptionally(error)) {
                this.log.debug("Event {} completed exceptionally since the consumer is closing", event);
            } else {
                this.log.trace("Event {} not completed exceptionally since it was completed prior to the consumer closing", event);
            }
        };
        this.tracked.stream().filter(e -> !e.future().isDone()).forEach(expireEvent);
        this.tracked.clear();
        events.stream().filter(e -> e instanceof CompletableEvent).map(e -> (CompletableEvent)e).filter(e -> !e.future().isDone()).forEach(expireEvent);
        events.clear();
    }

    public int size() {
        return this.tracked.size();
    }

    public boolean contains(CompletableEvent<?> event) {
        return event != null && this.tracked.contains(event);
    }
}

