/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.Uuid;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Message;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Readable;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Writable;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Field;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Schema;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Type;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ByteUtils;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class CreateTopicsResponseData
implements ApiMessage {
    int throttleTimeMs;
    CreatableTopicResultCollection topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(CreatableTopicResult.SCHEMA_0), "Results for each topic we tried to create."));
    public static final Schema SCHEMA_1 = new Schema(new Field("topics", new ArrayOf(CreatableTopicResult.SCHEMA_1), "Results for each topic we tried to create."));
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 7;

    public CreateTopicsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public CreateTopicsResponseData() {
        this.throttleTimeMs = 0;
        this.topics = new CreatableTopicResultCollection(0);
    }

    @Override
    public short apiKey() {
        return 19;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 7;
    }

    @Override
    public final void read(Readable _readable, short _version) {
        int i;
        CreatableTopicResultCollection newCollection;
        int arrayLength;
        this.throttleTimeMs = _version >= 2 ? _readable.readInt() : 0;
        if (_version >= 5) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new CreatableTopicResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new CreatableTopicResult(_readable, _version));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new CreatableTopicResultCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new CreatableTopicResult(_readable, _version));
            }
            this.topics = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 5) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeInt(this.throttleTimeMs);
        }
        if (_version >= 5) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            for (CreatableTopicResult topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.topics.size());
            for (CreatableTopicResult topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 5) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _size.addBytes(4);
        }
        if (_version >= 5) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (CreatableTopicResult topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 5) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateTopicsResponseData)) {
            return false;
        }
        CreateTopicsResponseData other = (CreateTopicsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public CreateTopicsResponseData duplicate() {
        CreateTopicsResponseData _duplicate = new CreateTopicsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        CreatableTopicResultCollection newTopics = new CreatableTopicResultCollection(this.topics.size());
        for (CreatableTopicResult _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "CreateTopicsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public CreatableTopicResultCollection topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public CreateTopicsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public CreateTopicsResponseData setTopics(CreatableTopicResultCollection v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new ArrayOf(CreatableTopicResult.SCHEMA_1), "Results for each topic we tried to create.")));
        SCHEMA_6 = SCHEMA_5 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new CompactArrayOf(CreatableTopicResult.SCHEMA_5), "Results for each topic we tried to create."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_7 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", new CompactArrayOf(CreatableTopicResult.SCHEMA_7), "Results for each topic we tried to create."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
    }

    public static class CreatableTopicResultCollection
    extends ImplicitLinkedHashMultiCollection<CreatableTopicResult> {
        public CreatableTopicResultCollection() {
        }

        public CreatableTopicResultCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public CreatableTopicResultCollection(Iterator<CreatableTopicResult> iterator) {
            super(iterator);
        }

        @Override
        public CreatableTopicResult find(String name) {
            CreatableTopicResult _key = new CreatableTopicResult();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<CreatableTopicResult> findAll(String name) {
            CreatableTopicResult _key = new CreatableTopicResult();
            _key.setName(name);
            return this.findAll(_key);
        }

        public CreatableTopicResultCollection duplicate() {
            CreatableTopicResultCollection _duplicate = new CreatableTopicResultCollection(this.size());
            for (CreatableTopicResult _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class CreatableTopicConfigs
    implements Message {
        String name;
        String value;
        boolean readOnly;
        byte configSource;
        boolean isSensitive;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 5;
        public static final short HIGHEST_SUPPORTED_VERSION = 7;

        public CreatableTopicConfigs(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public CreatableTopicConfigs() {
            this.name = "";
            this.value = "";
            this.readOnly = false;
            this.configSource = (byte)-1;
            this.isSensitive = false;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableTopicConfigs");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.value = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field value had invalid length " + length);
                }
                this.value = _readable.readString(length);
            }
            this.readOnly = _readable.readByte() != 0;
            this.configSource = _readable.readByte();
            this.isSensitive = _readable.readByte() != 0;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatableTopicConfigs");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            if (this.value == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.value);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeByte(this.readOnly ? (byte)1 : 0);
            _writable.writeByte(this.configSource);
            _writable.writeByte(this.isSensitive ? (byte)1 : 0);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatableTopicConfigs");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            if (this.value == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'value' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.value, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatableTopicConfigs)) {
                return false;
            }
            CreatableTopicConfigs other = (CreatableTopicConfigs)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            if (this.readOnly != other.readOnly) {
                return false;
            }
            if (this.configSource != other.configSource) {
                return false;
            }
            if (this.isSensitive != other.isSensitive) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.value == null ? 0 : this.value.hashCode());
            hashCode = 31 * hashCode + (this.readOnly ? 1231 : 1237);
            hashCode = 31 * hashCode + this.configSource;
            hashCode = 31 * hashCode + (this.isSensitive ? 1231 : 1237);
            return hashCode;
        }

        @Override
        public CreatableTopicConfigs duplicate() {
            CreatableTopicConfigs _duplicate = new CreatableTopicConfigs();
            _duplicate.name = this.name;
            _duplicate.value = this.value == null ? null : this.value;
            _duplicate.readOnly = this.readOnly;
            _duplicate.configSource = this.configSource;
            _duplicate.isSensitive = this.isSensitive;
            return _duplicate;
        }

        public String toString() {
            return "CreatableTopicConfigs(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", value=" + (this.value == null ? "null" : "'" + this.value.toString() + "'") + ", readOnly=" + (this.readOnly ? "true" : "false") + ", configSource=" + this.configSource + ", isSensitive=" + (this.isSensitive ? "true" : "false") + ")";
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public boolean readOnly() {
            return this.readOnly;
        }

        public byte configSource() {
            return this.configSource;
        }

        public boolean isSensitive() {
            return this.isSensitive;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatableTopicConfigs setName(String v) {
            this.name = v;
            return this;
        }

        public CreatableTopicConfigs setValue(String v) {
            this.value = v;
            return this;
        }

        public CreatableTopicConfigs setReadOnly(boolean v) {
            this.readOnly = v;
            return this;
        }

        public CreatableTopicConfigs setConfigSource(byte v) {
            this.configSource = v;
            return this;
        }

        public CreatableTopicConfigs setIsSensitive(boolean v) {
            this.isSensitive = v;
            return this;
        }

        static {
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("name", Type.COMPACT_STRING, "The configuration name."), new Field("value", Type.COMPACT_NULLABLE_STRING, "The configuration value."), new Field("read_only", Type.BOOLEAN, "True if the configuration is read-only."), new Field("config_source", Type.INT8, "The configuration source."), new Field("is_sensitive", Type.BOOLEAN, "True if this configuration is sensitive."), Field.TaggedFieldsSection.of(new Object[0])));
            SCHEMAS = new Schema[]{null, null, null, null, null, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }

    public static class CreatableTopicResult
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        Uuid topicId;
        short errorCode;
        String errorMessage;
        short topicConfigErrorCode;
        int numPartitions;
        short replicationFactor;
        List<CreatableTopicConfigs> configs;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."));
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 7;

        public CreatableTopicResult(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public CreatableTopicResult() {
            this.name = "";
            this.topicId = Uuid.ZERO_UUID;
            this.errorCode = 0;
            this.errorMessage = "";
            this.topicConfigErrorCode = 0;
            this.numPartitions = -1;
            this.replicationFactor = (short)-1;
            this.configs = new ArrayList<CreatableTopicConfigs>(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableTopicResult");
            }
            int length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.topicId = _version >= 7 ? _readable.readUuid() : Uuid.ZERO_UUID;
            this.errorCode = _readable.readShort();
            if (_version >= 1) {
                length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
                if (length < 0) {
                    this.errorMessage = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field errorMessage had invalid length " + length);
                    }
                    this.errorMessage = _readable.readString(length);
                }
            } else {
                this.errorMessage = "";
            }
            this.topicConfigErrorCode = 0;
            this.numPartitions = _version >= 5 ? _readable.readInt() : -1;
            this.replicationFactor = _version >= 5 ? _readable.readShort() : (short)-1;
            if (_version >= 5) {
                int arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    this.configs = null;
                } else {
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    ArrayList<CreatableTopicConfigs> newCollection = new ArrayList<CreatableTopicConfigs>(arrayLength);
                    for (int i = 0; i < arrayLength; ++i) {
                        newCollection.add(new CreatableTopicConfigs(_readable, _version));
                    }
                    this.configs = newCollection;
                }
            } else {
                this.configs = new ArrayList<CreatableTopicConfigs>(0);
            }
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                block4: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        case 0: {
                            this.topicConfigErrorCode = _readable.readShort();
                            continue block4;
                        }
                        default: {
                            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        }
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 7) {
                _writable.writeUuid(this.topicId);
            }
            _writable.writeShort(this.errorCode);
            if (_version >= 1) {
                if (this.errorMessage == null) {
                    if (_version >= 5) {
                        _writable.writeUnsignedVarint(0);
                    } else {
                        _writable.writeShort((short)-1);
                    }
                } else {
                    _stringBytes = _cache.getSerializedValue(this.errorMessage);
                    if (_version >= 5) {
                        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                    } else {
                        _writable.writeShort((short)((byte[])_stringBytes).length);
                    }
                    _writable.writeByteArray((byte[])_stringBytes);
                }
            }
            if (_version >= 5 && this.topicConfigErrorCode != 0) {
                ++_numTaggedFields;
            }
            if (_version >= 5) {
                _writable.writeInt(this.numPartitions);
            }
            if (_version >= 5) {
                _writable.writeShort(this.replicationFactor);
            }
            if (_version >= 5) {
                if (this.configs == null) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeUnsignedVarint(this.configs.size() + 1);
                    _stringBytes = this.configs.iterator();
                    while (_stringBytes.hasNext()) {
                        CreatableTopicConfigs configsElement = (CreatableTopicConfigs)_stringBytes.next();
                        configsElement.write(_writable, _cache, _version);
                    }
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                if (this.topicConfigErrorCode != 0) {
                    _writable.writeUnsignedVarint(0);
                    _writable.writeUnsignedVarint(2);
                    _writable.writeShort(this.topicConfigErrorCode);
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatableTopicResult");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            if (_version >= 5) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 7) {
                _size.addBytes(16);
            }
            _size.addBytes(2);
            if (_version >= 1) {
                if (this.errorMessage == null) {
                    if (_version >= 5) {
                        _size.addBytes(1);
                    } else {
                        _size.addBytes(2);
                    }
                } else {
                    _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'errorMessage' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                    if (_version >= 5) {
                        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                    } else {
                        _size.addBytes(_stringBytes.length + 2);
                    }
                }
            }
            if (_version >= 5 && this.topicConfigErrorCode != 0) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(2);
            }
            if (_version >= 5) {
                _size.addBytes(4);
            }
            if (_version >= 5) {
                _size.addBytes(2);
            }
            if (_version >= 5) {
                if (this.configs == null) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.configs.size() + 1));
                    for (CreatableTopicConfigs configsElement : this.configs) {
                        configsElement.addSize(_size, _cache, _version);
                    }
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 5) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof CreatableTopicResult)) {
                return false;
            }
            CreatableTopicResult other = (CreatableTopicResult)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatableTopicResult)) {
                return false;
            }
            CreatableTopicResult other = (CreatableTopicResult)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.topicConfigErrorCode != other.topicConfigErrorCode) {
                return false;
            }
            if (this.numPartitions != other.numPartitions) {
                return false;
            }
            if (this.replicationFactor != other.replicationFactor) {
                return false;
            }
            if (this.configs == null ? other.configs != null : !this.configs.equals(other.configs)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public CreatableTopicResult duplicate() {
            CreatableTopicResult _duplicate = new CreatableTopicResult();
            _duplicate.name = this.name;
            _duplicate.topicId = this.topicId;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.topicConfigErrorCode = this.topicConfigErrorCode;
            _duplicate.numPartitions = this.numPartitions;
            _duplicate.replicationFactor = this.replicationFactor;
            if (this.configs == null) {
                _duplicate.configs = null;
            } else {
                ArrayList<CreatableTopicConfigs> newConfigs = new ArrayList<CreatableTopicConfigs>(this.configs.size());
                for (CreatableTopicConfigs _element : this.configs) {
                    newConfigs.add(_element.duplicate());
                }
                _duplicate.configs = newConfigs;
            }
            return _duplicate;
        }

        public String toString() {
            return "CreatableTopicResult(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", topicId=" + this.topicId.toString() + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", topicConfigErrorCode=" + this.topicConfigErrorCode + ", numPartitions=" + this.numPartitions + ", replicationFactor=" + this.replicationFactor + ", configs=" + (this.configs == null ? "null" : MessageUtil.deepToString(this.configs.iterator())) + ")";
        }

        public String name() {
            return this.name;
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public short topicConfigErrorCode() {
            return this.topicConfigErrorCode;
        }

        public int numPartitions() {
            return this.numPartitions;
        }

        public short replicationFactor() {
            return this.replicationFactor;
        }

        public List<CreatableTopicConfigs> configs() {
            return this.configs;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatableTopicResult setName(String v) {
            this.name = v;
            return this;
        }

        public CreatableTopicResult setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public CreatableTopicResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public CreatableTopicResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public CreatableTopicResult setTopicConfigErrorCode(short v) {
            this.topicConfigErrorCode = v;
            return this;
        }

        public CreatableTopicResult setNumPartitions(int v) {
            this.numPartitions = v;
            return this;
        }

        public CreatableTopicResult setReplicationFactor(short v) {
            this.replicationFactor = v;
            return this;
        }

        public CreatableTopicResult setConfigs(List<CreatableTopicConfigs> v) {
            this.configs = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."))));
            SCHEMA_6 = SCHEMA_5 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("num_partitions", Type.INT32, "Number of partitions of the topic."), new Field("replication_factor", Type.INT16, "Replication factor of the topic."), new Field("configs", CompactArrayOf.nullable(CreatableTopicConfigs.SCHEMA_5), "Configuration of the topic."), Field.TaggedFieldsSection.of(0, new Field("topic_config_error_code", Type.INT16, "Optional topic config error returned if configs are not returned in the response.")));
            SCHEMA_7 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("topic_id", Type.UUID, "The unique topic ID"), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The error message, or null if there was no error."), new Field("num_partitions", Type.INT32, "Number of partitions of the topic."), new Field("replication_factor", Type.INT16, "Replication factor of the topic."), new Field("configs", CompactArrayOf.nullable(CreatableTopicConfigs.SCHEMA_5), "Configuration of the topic."), Field.TaggedFieldsSection.of(0, new Field("topic_config_error_code", Type.INT16, "Optional topic config error returned if configs are not returned in the response.")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }
}

