/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.CompressionType;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.Record;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.record.TimestampType;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.BufferSupplier;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.CloseableIterator;

public interface RecordBatch
extends Iterable<Record> {
    public static final byte MAGIC_VALUE_V0 = 0;
    public static final byte MAGIC_VALUE_V1 = 1;
    public static final byte MAGIC_VALUE_V2 = 2;
    public static final byte CURRENT_MAGIC_VALUE = 2;
    public static final long NO_TIMESTAMP = -1L;
    public static final long NO_PRODUCER_ID = -1L;
    public static final short NO_PRODUCER_EPOCH = -1;
    public static final int NO_SEQUENCE = -1;
    public static final int NO_PARTITION_LEADER_EPOCH = -1;

    public boolean isValid();

    public void ensureValid();

    public long checksum();

    public long maxTimestamp();

    public TimestampType timestampType();

    public long baseOffset();

    public long lastOffset();

    public long nextOffset();

    public byte magic();

    public long producerId();

    public short producerEpoch();

    public boolean hasProducerId();

    public int baseSequence();

    public int lastSequence();

    public CompressionType compressionType();

    public int sizeInBytes();

    public Integer countOrNull();

    public boolean isCompressed();

    public void writeTo(ByteBuffer var1);

    public boolean isTransactional();

    public OptionalLong deleteHorizonMs();

    public int partitionLeaderEpoch();

    public CloseableIterator<Record> streamingIterator(BufferSupplier var1);

    public boolean isControlBatch();

    default public Optional<Long> offsetOfMaxTimestamp() {
        if (this.magic() == 0) {
            return Optional.empty();
        }
        long maxTimestamp = this.maxTimestamp();
        try (CloseableIterator<Record> iter = this.streamingIterator(BufferSupplier.create());){
            while (iter.hasNext()) {
                Record record = (Record)iter.next();
                if (maxTimestamp != record.timestamp()) continue;
                Optional<Long> optional = Optional.of(record.offset());
                return optional;
            }
        }
        return Optional.empty();
    }
}

