/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.SystemTime;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.Timer;

public interface Time {
    public static final Time SYSTEM = SystemTime.getSystemTime();

    public long milliseconds();

    default public long hiResClockMs() {
        return TimeUnit.NANOSECONDS.toMillis(this.nanoseconds());
    }

    public long nanoseconds();

    public void sleep(long var1);

    public void waitObject(Object var1, Supplier<Boolean> var2, long var3) throws InterruptedException;

    default public Timer timer(long timeoutMs) {
        return new Timer(this, timeoutMs);
    }

    default public Timer timer(Duration timeout) {
        return this.timer(timeout.toMillis());
    }

    default public <T> T waitForFuture(Future<T> future, long deadlineNs) throws TimeoutException, InterruptedException, ExecutionException {
        TimeoutException timeoutException = null;
        while (true) {
            long nowNs;
            if (deadlineNs <= (nowNs = this.nanoseconds())) {
                throw timeoutException == null ? new TimeoutException() : timeoutException;
            }
            long deltaNs = deadlineNs - nowNs;
            try {
                return future.get(deltaNs, TimeUnit.NANOSECONDS);
            }
            catch (TimeoutException t) {
                timeoutException = t;
                continue;
            }
            break;
        }
    }
}

