/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.OffsetInstance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.IterativelyReweightedLeastSquaresModel;
import org.apache.spark.ml.optim.WeightedLeastSquares;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.ml.util.OptionalInstrumentation;
import org.apache.spark.ml.util.OptionalInstrumentation$;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005\u0005}a!B\t\u0013\u0001Qa\u0002\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011A\u001c\t\u0011q\u0002!\u0011!Q\u0001\naB\u0001\"\u0010\u0001\u0003\u0006\u0004%\tA\u0010\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u007f!Aq\n\u0001BC\u0002\u0013\u0005\u0001\u000b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003R\u0011!)\u0006A!b\u0001\n\u00031\u0006\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011B&\t\u0011a\u0003!Q1A\u0005\u0002eC\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0017\u0005\t=\u0002\u0011)\u0019!C\u0001-\"Aq\f\u0001B\u0001B\u0003%1\nC\u0003a\u0001\u0011\u0005\u0011\rC\u0003j\u0001\u0011\u0005!\u000eC\u0005\u0002\u0002\u0001\t\n\u0011\"\u0001\u0002\u0004!I\u0011\u0011\u0004\u0001\u0012\u0002\u0013\u0005\u00111\u0004\u0002\"\u0013R,'/\u0019;jm\u0016d\u0017PU3xK&<\u0007\u000e^3e\u0019\u0016\f7\u000f^*rk\u0006\u0014Xm\u001d\u0006\u0003'Q\tQa\u001c9uS6T!!\u0006\f\u0002\u00055d'BA\f\u0019\u0003\u0015\u0019\b/\u0019:l\u0015\tI\"$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00027\u0005\u0019qN]4\u0014\t\u0001i2\u0005\r\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011jcBA\u0013,\u001d\t1#&D\u0001(\u0015\tA\u0013&\u0001\u0004=e>|GOP\u0002\u0001\u0013\u0005\u0001\u0013B\u0001\u0017 \u0003\u001d\u0001\u0018mY6bO\u0016L!AL\u0018\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u00051z\u0002CA\u00195\u001b\u0005\u0011$BA\u001a\u0017\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001b3\u0005\u001daunZ4j]\u001e\fA\"\u001b8ji&\fG.T8eK2,\u0012\u0001\u000f\t\u0003sij\u0011AE\u0005\u0003wI\u0011\u0011dV3jO\"$X\r\u001a'fCN$8+];be\u0016\u001cXj\u001c3fY\u0006i\u0011N\\5uS\u0006dWj\u001c3fY\u0002\nAB]3xK&<\u0007\u000e\u001e$v]\u000e,\u0012a\u0010\t\u0006=\u0001\u0013\u0005\bS\u0005\u0003\u0003~\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015#\u0012a\u00024fCR,(/Z\u0005\u0003\u000f\u0012\u0013ab\u00144gg\u0016$\u0018J\\:uC:\u001cW\r\u0005\u0003\u001f\u0013.[\u0015B\u0001& \u0005\u0019!V\u000f\u001d7feA\u0011a\u0004T\u0005\u0003\u001b~\u0011a\u0001R8vE2,\u0017!\u0004:fo\u0016Lw\r\u001b;Gk:\u001c\u0007%\u0001\u0007gSRLe\u000e^3sG\u0016\u0004H/F\u0001R!\tq\"+\u0003\u0002T?\t9!i\\8mK\u0006t\u0017!\u00044ji&sG/\u001a:dKB$\b%\u0001\u0005sK\u001e\u0004\u0016M]1n+\u0005Y\u0015!\u0003:fOB\u000b'/Y7!\u0003\u001di\u0017\r_%uKJ,\u0012A\u0017\t\u0003=mK!\u0001X\u0010\u0003\u0007%sG/\u0001\u0005nCbLE/\u001a:!\u0003\r!x\u000e\\\u0001\u0005i>d\u0007%\u0001\u0004=S:LGO\u0010\u000b\bE\u000e$WMZ4i!\tI\u0004\u0001C\u00037\u001b\u0001\u0007\u0001\bC\u0003>\u001b\u0001\u0007q\bC\u0003P\u001b\u0001\u0007\u0011\u000bC\u0003V\u001b\u0001\u00071\nC\u0003Y\u001b\u0001\u0007!\fC\u0003_\u001b\u0001\u00071*A\u0002gSR$Ba\u001b8w}B\u0011\u0011\b\\\u0005\u0003[J\u0011a%\u0013;fe\u0006$\u0018N^3msJ+w/Z5hQR,G\rT3bgR\u001c\u0016/^1sKNlu\u000eZ3m\u0011\u0015yg\u00021\u0001q\u0003%Ign\u001d;b]\u000e,7\u000fE\u0002ri\nk\u0011A\u001d\u0006\u0003gZ\t1A\u001d3e\u0013\t)(OA\u0002S\t\u0012Cqa\u001e\b\u0011\u0002\u0003\u0007\u00010A\u0003j]N$(\u000f\u0005\u0002zy6\t!P\u0003\u0002|)\u0005!Q\u000f^5m\u0013\ti(PA\fPaRLwN\\1m\u0013:\u001cHO];nK:$\u0018\r^5p]\"9qP\u0004I\u0001\u0002\u0004Q\u0016!\u00023faRD\u0017!\u00044ji\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0006)\u001a\u00010a\u0002,\u0005\u0005%\u0001\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0005 \u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003/\tiAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQBZ5uI\u0011,g-Y;mi\u0012\u001aTCAA\u000fU\rQ\u0016q\u0001")
public class IterativelyReweightedLeastSquares
implements Serializable,
Logging {
    private final WeightedLeastSquaresModel initialModel;
    private final Function2<OffsetInstance, WeightedLeastSquaresModel, Tuple2<Object, Object>> reweightFunc;
    private final boolean fitIntercept;
    private final double regParam;
    private final int maxIter;
    private final double tol;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public WeightedLeastSquaresModel initialModel() {
        return this.initialModel;
    }

    public Function2<OffsetInstance, WeightedLeastSquaresModel, Tuple2<Object, Object>> reweightFunc() {
        return this.reweightFunc;
    }

    public boolean fitIntercept() {
        return this.fitIntercept;
    }

    public double regParam() {
        return this.regParam;
    }

    public int maxIter() {
        return this.maxIter;
    }

    public double tol() {
        return this.tol;
    }

    public IterativelyReweightedLeastSquaresModel fit(RDD<OffsetInstance> instances, OptionalInstrumentation instr, int depth) {
        boolean converged = false;
        IntRef iter = IntRef.create((int)0);
        WeightedLeastSquaresModel model = this.initialModel();
        ObjectRef oldModel = ObjectRef.create(null);
        while (iter.elem < this.maxIter() && !converged) {
            oldModel.elem = model;
            RDD newInstances = instances.map((Function1 & Serializable)instance -> {
                Tuple2 tuple2 = (Tuple2)this.reweightFunc().apply(instance, (Object)((WeightedLeastSquaresModel)oldModel$1.elem));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                double newLabel = tuple2._1$mcD$sp();
                double newWeight = tuple2._2$mcD$sp();
                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(newLabel, newWeight);
                double newLabel2 = sp2._1$mcD$sp();
                double newWeight2 = sp2._2$mcD$sp();
                return new Instance(newLabel2, newWeight2, instance.features());
            }, ClassTag$.MODULE$.apply(Instance.class));
            model = new WeightedLeastSquares(this.fitIntercept(), this.regParam(), 0.0, false, false, WeightedLeastSquares$.MODULE$.$lessinit$greater$default$6(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7(), WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8()).fit((RDD<Instance>)newInstances, instr, depth);
            DenseVector oldCoefficients = ((WeightedLeastSquaresModel)oldModel.elem).coefficients();
            DenseVector coefficients = model.coefficients();
            BLAS$.MODULE$.axpy(-1.0, (Vector)coefficients, (Vector)oldCoefficients);
            double maxTolOfCoefficients = BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.doubleArrayOps(oldCoefficients.toArray()), (Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable)(x, y) -> package$.MODULE$.max(package$.MODULE$.abs(x), package$.MODULE$.abs(y))));
            double maxTol = package$.MODULE$.max(maxTolOfCoefficients, package$.MODULE$.abs(((WeightedLeastSquaresModel)oldModel.elem).intercept() - model.intercept()));
            if (maxTol < this.tol()) {
                converged = true;
                instr.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"IRLS converged in ", " iterations."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_ITERATIONS, BoxesRunTime.boxToInteger((int)iter$1.elem))}))));
            }
            instr.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Iteration ", ": "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_ITERATIONS, BoxesRunTime.boxToInteger((int)iter$1.elem))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"relative tolerance = ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.RELATIVE_TOLERANCE, BoxesRunTime.boxToDouble((double)maxTol))})))));
            ++iter.elem;
            if (iter.elem != this.maxIter()) continue;
            instr.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"IRLS reached the max number of iterations: ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_ITERATIONS, BoxesRunTime.boxToInteger((int)iter$1.elem))}))));
        }
        return new IterativelyReweightedLeastSquaresModel(model.coefficients(), model.intercept(), model.diagInvAtWA(), iter.elem);
    }

    public OptionalInstrumentation fit$default$2() {
        return OptionalInstrumentation$.MODULE$.create(IterativelyReweightedLeastSquares.class);
    }

    public int fit$default$3() {
        return 2;
    }

    public IterativelyReweightedLeastSquares(WeightedLeastSquaresModel initialModel, Function2<OffsetInstance, WeightedLeastSquaresModel, Tuple2<Object, Object>> reweightFunc, boolean fitIntercept, double regParam, int maxIter, double tol) {
        this.initialModel = initialModel;
        this.reweightFunc = reweightFunc;
        this.fitIntercept = fitIntercept;
        this.regParam = regParam;
        this.maxIter = maxIter;
        this.tol = tol;
        Logging.$init$((Logging)this);
    }
}

