/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.model;

import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.EnsembleCombiningStrategy$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel$;
import org.apache.spark.rdd.RDD;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rMe!\u0002-Z!m+\u0007\u0002C=\u0001\u0005\u000b\u0007I\u0011\u0003>\t\u0013\u0005\u0005\u0002A!A!\u0002\u0013Y\bBCA\u0012\u0001\t\u0015\r\u0011\"\u0005\u0002&!Q\u0011Q\u0007\u0001\u0003\u0002\u0003\u0006I!a\n\t\u0015\u0005]\u0002A!b\u0001\n#\tI\u0004\u0003\u0006\u0002D\u0001\u0011\t\u0011)A\u0005\u0003wA!\"!\u0012\u0001\u0005\u000b\u0007I\u0011CA$\u0011)\t9\u0006\u0001B\u0001B\u0003%\u0011\u0011\n\u0005\b\u00033\u0002A\u0011AA.\u0011%\t9\u0007\u0001b\u0001\n\u0013\tI\u0007\u0003\u0005\u0002l\u0001\u0001\u000b\u0011BA\u001f\u0011\u001d\ti\u0007\u0001C\u0005\u0003_Bq!!!\u0001\t\u0013\t\u0019\tC\u0004\u0002\b\u0002!\t!!#\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\u000e\"9\u0011q\u0011\u0001\u0005\u0002\u0005}\u0005bBAa\u0001\u0011\u0005\u00131\u0019\u0005\b\u0003+\u0004A\u0011AAl\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!a9\u0001\t\u0003\tYn\u0002\u0005\u0002pfC\taWAy\r\u001dA\u0016\f#\u0001\\\u0003gDq!!\u0017\u0017\t\u0003\u0011YaB\u0004\u0003\u000eYA\tAa\u0004\u0007\u000f\tMa\u0003#\u0001\u0003\u0016!9\u0011\u0011L\r\u0005\u0002\t]\u0001b\u0002B\r3\u0011\u0005\u0011q\u001b\u0004\u0007\u00057I\u0002I!\b\t\u0013ed\"Q3A\u0005\u0002\u0005]\u0007BCA\u00119\tE\t\u0015!\u0003\u0002F\"Q!Q\u0005\u000f\u0003\u0016\u0004%\t!a6\t\u0015\t\u001dBD!E!\u0002\u0013\t)\r\u0003\u0006\u0002Fq\u0011)\u001a!C\u0001\u0003/D!\"a\u0016\u001d\u0005#\u0005\u000b\u0011BAc\u0011)\t9\u0004\bBK\u0002\u0013\u0005\u0011\u0011\b\u0005\u000b\u0003\u0007b\"\u0011#Q\u0001\n\u0005m\u0002bBA-9\u0011\u0005!\u0011\u0006\u0005\n\u0005oa\u0012\u0011!C\u0001\u0005sA\u0011Ba\u0011\u001d#\u0003%\tA!\u0012\t\u0013\tmC$%A\u0005\u0002\t\u0015\u0003\"\u0003B/9E\u0005I\u0011\u0001B#\u0011%\u0011y\u0006HI\u0001\n\u0003\u0011\t\u0007C\u0005\u0003fq\t\t\u0011\"\u0011\u0003h!I!Q\u000e\u000f\u0002\u0002\u0013\u0005\u00111\u001c\u0005\n\u0005_b\u0012\u0011!C\u0001\u0005cB\u0011B! \u001d\u0003\u0003%\tEa \t\u0013\t5E$!A\u0005\u0002\t=\u0005\"\u0003BM9\u0005\u0005I\u0011\tBN\u0011%\u0011y\nHA\u0001\n\u0003\u0012\t\u000bC\u0005\u0002Br\t\t\u0011\"\u0011\u0003$\"I!Q\u0015\u000f\u0002\u0002\u0013\u0005#qU\u0004\n\u0005WK\u0012\u0011!E\u0001\u0005[3\u0011Ba\u0007\u001a\u0003\u0003E\tAa,\t\u000f\u0005eS\u0007\"\u0001\u0003>\"I\u0011\u0011Y\u001b\u0002\u0002\u0013\u0015#1\u0015\u0005\n\u0005\u007f+\u0014\u0011!CA\u0005\u0003D\u0011Ba36\u0003\u0003%\tI!4\t\u0013\t}W'!A\u0005\n\t\u0005hA\u0002Bu3\u0001\u0013Y\u000f\u0003\u0006\u0003nn\u0012)\u001a!C\u0001\u00037D!Ba<<\u0005#\u0005\u000b\u0011BAo\u0011)\u0011\tp\u000fBK\u0002\u0013\u0005!1\u001f\u0005\u000b\u0007\u001bY$\u0011#Q\u0001\n\tU\bbBA-w\u0011\u00051q\u0002\u0005\n\u0005oY\u0014\u0011!C\u0001\u0007/A\u0011Ba\u0011<#\u0003%\ta!\b\t\u0013\tm3(%A\u0005\u0002\r\u0005\u0002\"\u0003B3w\u0005\u0005I\u0011\tB4\u0011%\u0011igOA\u0001\n\u0003\tY\u000eC\u0005\u0003pm\n\t\u0011\"\u0001\u0004&!I!QP\u001e\u0002\u0002\u0013\u0005#q\u0010\u0005\n\u0005\u001b[\u0014\u0011!C\u0001\u0007SA\u0011B!'<\u0003\u0003%\te!\f\t\u0013\t}5(!A\u0005B\t\u0005\u0006\"CAaw\u0005\u0005I\u0011\tBR\u0011%\u0011)kOA\u0001\n\u0003\u001a\tdB\u0005\u00046e\t\t\u0011#\u0001\u00048\u0019I!\u0011^\r\u0002\u0002#\u00051\u0011\b\u0005\b\u00033rE\u0011AB!\u0011%\t\tMTA\u0001\n\u000b\u0012\u0019\u000bC\u0005\u0003@:\u000b\t\u0011\"!\u0004D!I!1\u001a(\u0002\u0002\u0013\u00055\u0011\n\u0005\n\u0005?t\u0015\u0011!C\u0005\u0005CDqa!\u0016\u001a\t\u0003\u00199\u0006C\u0004\u0004ve!\taa\u001e\t\u000f\r%\u0015\u0004\"\u0001\u0004\f\"I!q\u001c\f\u0002\u0002\u0013%!\u0011\u001d\u0002\u0012)J,W-\u00128tK6\u0014G.Z'pI\u0016d'B\u0001.\\\u0003\u0015iw\u000eZ3m\u0015\taV,\u0001\u0003ue\u0016,'B\u00010`\u0003\u0015iG\u000e\\5c\u0015\t\u0001\u0017-A\u0003ta\u0006\u00148N\u0003\u0002cG\u00061\u0011\r]1dQ\u0016T\u0011\u0001Z\u0001\u0004_J<7c\u0001\u0001gYB\u0011qM[\u0007\u0002Q*\t\u0011.A\u0003tG\u0006d\u0017-\u0003\u0002lQ\n1\u0011I\\=SK\u001a\u0004\"!\u001c<\u000f\u00059$hBA8t\u001b\u0005\u0001(BA9s\u0003\u0019a$o\\8u}\r\u0001\u0011\"A5\n\u0005UD\u0017a\u00029bG.\fw-Z\u0005\u0003ob\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!!\u001e5\u0002\t\u0005dwm\\\u000b\u0002wB\u0019A0a\u0007\u000f\u0007u\f)BD\u0002\u007f\u0003#q1a`A\b\u001d\u0011\t\t!!\u0004\u000f\t\u0005\r\u00111\u0002\b\u0005\u0003\u000b\tIAD\u0002p\u0003\u000fI\u0011\u0001Z\u0005\u0003E\u000eL!\u0001Y1\n\u0005y{\u0016B\u0001/^\u0013\r\t\u0019bW\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\t\u0005]\u0011\u0011D\u0001\u0005\u00032<wNC\u0002\u0002\u0014mKA!!\b\u0002 \t!\u0011\t\\4p\u0015\u0011\t9\"!\u0007\u0002\u000b\u0005dwm\u001c\u0011\u0002\u000bQ\u0014X-Z:\u0016\u0005\u0005\u001d\u0002#B4\u0002*\u00055\u0012bAA\u0016Q\n)\u0011I\u001d:bsB!\u0011qFA\u0019\u001b\u0005I\u0016bAA\u001a3\n\tB)Z2jg&|g\u000e\u0016:fK6{G-\u001a7\u0002\rQ\u0014X-Z:!\u0003-!(/Z3XK&<\u0007\u000e^:\u0016\u0005\u0005m\u0002#B4\u0002*\u0005u\u0002cA4\u0002@%\u0019\u0011\u0011\t5\u0003\r\u0011{WO\u00197f\u00031!(/Z3XK&<\u0007\u000e^:!\u0003E\u0019w.\u001c2j]&twm\u0015;sCR,w-_\u000b\u0003\u0003\u0013\u0002B!a\u0013\u0002R9\u0019Q0!\u0014\n\t\u0005=\u0013\u0011D\u0001\u001a\u000b:\u001cX-\u001c2mK\u000e{WNY5oS:<7\u000b\u001e:bi\u0016<\u00170\u0003\u0003\u0002T\u0005U#!G#og\u0016l'\r\\3D_6\u0014\u0017N\\5oON#(/\u0019;fOfTA!a\u0014\u0002\u001a\u0005\u00112m\\7cS:LgnZ*ue\u0006$XmZ=!\u0003\u0019a\u0014N\\5u}QQ\u0011QLA0\u0003C\n\u0019'!\u001a\u0011\u0007\u0005=\u0002\u0001C\u0003z\u0013\u0001\u00071\u0010C\u0004\u0002$%\u0001\r!a\n\t\u000f\u0005]\u0012\u00021\u0001\u0002<!9\u0011QI\u0005A\u0002\u0005%\u0013AC:v[^+\u0017n\u001a5ugV\u0011\u0011QH\u0001\fgVlw+Z5hQR\u001c\b%\u0001\tqe\u0016$\u0017n\u0019;CsN+X.\\5oOR!\u0011QHA9\u0011\u001d\t\u0019\b\u0004a\u0001\u0003k\n\u0001BZ3biV\u0014Xm\u001d\t\u0005\u0003o\ni(\u0004\u0002\u0002z)\u0019\u00111P/\u0002\r1Lg.\u00197h\u0013\u0011\ty(!\u001f\u0003\rY+7\r^8s\u0003=\u0001(/\u001a3jGR\u0014\u0015PV8uS:<G\u0003BA\u001f\u0003\u000bCq!a\u001d\u000e\u0001\u0004\t)(A\u0004qe\u0016$\u0017n\u0019;\u0015\t\u0005u\u00121\u0012\u0005\b\u0003gr\u0001\u0019AA;)\u0011\ty)a'\u0011\r\u0005E\u0015qSA\u001f\u001b\t\t\u0019JC\u0002\u0002\u0016~\u000b1A\u001d3e\u0013\u0011\tI*a%\u0003\u0007I#E\tC\u0004\u0002t=\u0001\r!!(\u0011\r\u0005E\u0015qSA;)\u0011\t\t+!0\u0011\r\u0005\r\u0016QVAY\u001b\t\t)K\u0003\u0003\u0002(\u0006%\u0016\u0001\u00026bm\u0006T1!a+`\u0003\r\t\u0007/[\u0005\u0005\u0003_\u000b)KA\u0004KCZ\f'\u000b\u0012#\u0011\t\u0005M\u00161X\u0007\u0003\u0003kSA!a.\u0002:\u0006!A.\u00198h\u0015\t\t9+\u0003\u0003\u0002B\u0005U\u0006bBA:!\u0001\u0007\u0011q\u0018\t\u0007\u0003G\u000bi+!\u001e\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!2\u0011\t\u0005\u001d\u0017q\u001a\b\u0005\u0003\u0013\fY\r\u0005\u0002pQ&\u0019\u0011Q\u001a5\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t.a5\u0003\rM#(/\u001b8h\u0015\r\ti\r[\u0001\u000ei>$UMY;h'R\u0014\u0018N\\4\u0016\u0005\u0005\u0015\u0017\u0001\u00038v[R\u0013X-Z:\u0016\u0005\u0005u\u0007cA4\u0002`&\u0019\u0011\u0011\u001d5\u0003\u0007%sG/A\u0007u_R\fGNT;n\u001d>$Wm]\u0015\u0006\u0001\u0005\u001d\u00181^\u0005\u0004\u0003SL&!G$sC\u0012LWM\u001c;C_>\u001cH/\u001a3Ue\u0016,7/T8eK2L1!!<Z\u0005E\u0011\u0016M\u001c3p[\u001a{'/Z:u\u001b>$W\r\\\u0001\u0012)J,W-\u00128tK6\u0014G.Z'pI\u0016d\u0007cAA\u0018-M1aCZA{\u0005\u0003\u0001B!a>\u0002~6\u0011\u0011\u0011 \u0006\u0004\u0003w|\u0016\u0001C5oi\u0016\u0014h.\u00197\n\t\u0005}\u0018\u0011 \u0002\b\u0019><w-\u001b8h!\u0011\u0011\u0019A!\u0003\u000e\u0005\t\u0015!\u0002\u0002B\u0004\u0003s\u000b!![8\n\u0007]\u0014)\u0001\u0006\u0002\u0002r\u0006a1+\u0019<f\u0019>\fGMV\u0019`aA\u0019!\u0011C\r\u000e\u0003Y\u0011AbU1wK2{\u0017\r\u001a,2?B\u001a\"!\u00074\u0015\u0005\t=\u0011!\u0005;iSN4uN]7biZ+'o]5p]\nAQ*\u001a;bI\u0006$\u0018mE\u0003\u001dM\n}A\u000eE\u0002h\u0005CI1Aa\ti\u0005\u001d\u0001&o\u001c3vGR\f\u0001\u0002\u001e:fK\u0006cwm\\\u0001\niJ,W-\u00117h_\u0002\"\"Ba\u000b\u00030\tE\"1\u0007B\u001b!\r\u0011i\u0003H\u0007\u00023!1\u00110\na\u0001\u0003\u000bDqA!\n&\u0001\u0004\t)\rC\u0004\u0002F\u0015\u0002\r!!2\t\u000f\u0005]R\u00051\u0001\u0002<\u0005!1m\u001c9z))\u0011YCa\u000f\u0003>\t}\"\u0011\t\u0005\ts\u001a\u0002\n\u00111\u0001\u0002F\"I!Q\u0005\u0014\u0011\u0002\u0003\u0007\u0011Q\u0019\u0005\n\u0003\u000b2\u0003\u0013!a\u0001\u0003\u000bD\u0011\"a\u000e'!\u0003\u0005\r!a\u000f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\t\u0016\u0005\u0003\u000b\u0014Ie\u000b\u0002\u0003LA!!Q\nB,\u001b\t\u0011yE\u0003\u0003\u0003R\tM\u0013!C;oG\",7m[3e\u0015\r\u0011)\u0006[\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B-\u0005\u001f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\r$\u0006BA\u001e\u0005\u0013\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B5!\u0011\t\u0019La\u001b\n\t\u0005E\u0017QW\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011\u0019H!\u001f\u0011\u0007\u001d\u0014)(C\u0002\u0003x!\u00141!\u00118z\u0011%\u0011Y(LA\u0001\u0002\u0004\ti.A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u0003\u0003bAa!\u0003\n\nMTB\u0001BC\u0015\r\u00119\t[\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002BF\u0005\u000b\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!\u0011\u0013BL!\r9'1S\u0005\u0004\u0005+C'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005wz\u0013\u0011!a\u0001\u0005g\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!\u0011\u000eBO\u0011%\u0011Y\bMA\u0001\u0002\u0004\ti.\u0001\u0005iCND7i\u001c3f)\t\ti\u000e\u0006\u0002\u0003j\u00051Q-];bYN$BA!%\u0003*\"I!1P\u001a\u0002\u0002\u0003\u0007!1O\u0001\t\u001b\u0016$\u0018\rZ1uCB\u0019!QF\u001b\u0014\u000bU\u0012\tL!\u0001\u0011\u001d\tM&\u0011XAc\u0003\u000b\f)-a\u000f\u0003,5\u0011!Q\u0017\u0006\u0004\u0005oC\u0017a\u0002:v]RLW.Z\u0005\u0005\u0005w\u0013)LA\tBEN$(/Y2u\rVt7\r^5p]R\"\"A!,\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\t-\"1\u0019Bc\u0005\u000f\u0014I\r\u0003\u0004zq\u0001\u0007\u0011Q\u0019\u0005\b\u0005KA\u0004\u0019AAc\u0011\u001d\t)\u0005\u000fa\u0001\u0003\u000bDq!a\u000e9\u0001\u0004\tY$A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t='1\u001c\t\u0006O\nE'Q[\u0005\u0004\u0005'D'AB(qi&|g\u000eE\u0006h\u0005/\f)-!2\u0002F\u0006m\u0012b\u0001BmQ\n1A+\u001e9mKRB\u0011B!8:\u0003\u0003\u0005\rAa\u000b\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003dB!\u00111\u0017Bs\u0013\u0011\u00119/!.\u0003\r=\u0013'.Z2u\u0005A)en]3nE2,gj\u001c3f\t\u0006$\u0018mE\u0003<M\n}A.\u0001\u0004ue\u0016,\u0017\nZ\u0001\biJ,W-\u00133!\u0003\u0011qw\u000eZ3\u0016\u0005\tU\b\u0003\u0002B|\u0007\u000fqAA!?\u0004\u00049!!1 B\u0000\u001d\rq(Q`\u0005\u00035nK1a!\u0001Z\u0003E!UmY5tS>tGK]3f\u001b>$W\r\\\u0005\u0005\u0005\u001b\u0019)AC\u0002\u0004\u0002eKAa!\u0003\u0004\f\tAaj\u001c3f\t\u0006$\u0018M\u0003\u0003\u0003\u000e\r\u0015\u0011!\u00028pI\u0016\u0004CCBB\t\u0007'\u0019)\u0002E\u0002\u0003.mBqA!<A\u0001\u0004\ti\u000eC\u0004\u0003r\u0002\u0003\rA!>\u0015\r\rE1\u0011DB\u000e\u0011%\u0011i/\u0011I\u0001\u0002\u0004\ti\u000eC\u0005\u0003r\u0006\u0003\n\u00111\u0001\u0003vV\u00111q\u0004\u0016\u0005\u0003;\u0014I%\u0006\u0002\u0004$)\"!Q\u001fB%)\u0011\u0011\u0019ha\n\t\u0013\tmd)!AA\u0002\u0005uG\u0003\u0002BI\u0007WA\u0011Ba\u001fI\u0003\u0003\u0005\rAa\u001d\u0015\t\t%4q\u0006\u0005\n\u0005wJ\u0015\u0011!a\u0001\u0003;$BA!%\u00044!I!1\u0010'\u0002\u0002\u0003\u0007!1O\u0001\u0011\u000b:\u001cX-\u001c2mK:{G-\u001a#bi\u0006\u00042A!\fO'\u0015q51\bB\u0001!)\u0011\u0019l!\u0010\u0002^\nU8\u0011C\u0005\u0005\u0007\u007f\u0011)LA\tBEN$(/Y2u\rVt7\r^5p]J\"\"aa\u000e\u0015\r\rE1QIB$\u0011\u001d\u0011i/\u0015a\u0001\u0003;DqA!=R\u0001\u0004\u0011)\u0010\u0006\u0003\u0004L\rM\u0003#B4\u0003R\u000e5\u0003cB4\u0004P\u0005u'Q_\u0005\u0004\u0007#B'A\u0002+va2,'\u0007C\u0005\u0003^J\u000b\t\u00111\u0001\u0004\u0012\u0005!1/\u0019<f))\u0019Ifa\u0018\u0004l\r=4\u0011\u000f\t\u0004O\u000em\u0013bAB/Q\n!QK\\5u\u0011\u001d\u0019\t\u0007\u0016a\u0001\u0007G\n!a]2\u0011\t\r\u00154qM\u0007\u0002?&\u00191\u0011N0\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u000f\r5D\u000b1\u0001\u0002F\u0006!\u0001/\u0019;i\u0011\u0019QF\u000b1\u0001\u0002^!911\u000f+A\u0002\u0005\u0015\u0017!C2mCN\u001ch*Y7f\u00031\u0011X-\u00193NKR\fG-\u0019;b)\u0011\u0011Yc!\u001f\t\u000f\rmT\u000b1\u0001\u0004~\u0005AQ.\u001a;bI\u0006$\u0018\r\u0005\u0003\u0004\u0000\r\u0015UBABA\u0015\r\u0019\u0019iY\u0001\u0007UN|g\u000eN:\n\t\r\u001d5\u0011\u0011\u0002\u0007\u0015Z\u000bG.^3\u0002\u00131|\u0017\r\u001a+sK\u0016\u001cH\u0003CA\u0014\u0007\u001b\u001byi!%\t\u000f\r\u0005d\u000b1\u0001\u0004d!91Q\u000e,A\u0002\u0005\u0015\u0007b\u0002B\u0013-\u0002\u0007\u0011Q\u0019")
public class TreeEnsembleModel
implements Serializable {
    private final Enumeration.Value algo;
    private final DecisionTreeModel[] trees;
    private final double[] treeWeights;
    private final Enumeration.Value combiningStrategy;
    private final double sumWeights;

    public static Logging.LogStringContext LogStringContext(StringContext sc) {
        return TreeEnsembleModel$.MODULE$.LogStringContext(sc);
    }

    public Enumeration.Value algo() {
        return this.algo;
    }

    public DecisionTreeModel[] trees() {
        return this.trees;
    }

    public double[] treeWeights() {
        return this.treeWeights;
    }

    public Enumeration.Value combiningStrategy() {
        return this.combiningStrategy;
    }

    private double sumWeights() {
        return this.sumWeights;
    }

    private double predictBySumming(Vector features) {
        double[] treePredictions = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.trees()), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToDouble((double)x$9.predict(features)), (ClassTag)ClassTag$.MODULE$.Double());
        return BLAS$.MODULE$.nativeBLAS().ddot(this.numTrees(), treePredictions, 1, this.treeWeights(), 1);
    }

    private double predictByVoting(Vector features) {
        Map votes = (Map)Map$.MODULE$.empty();
        ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])this.trees())).zip((IterableOnce)ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.doubleArrayOps(this.treeWeights()))).foreach((Function1 & Serializable)x0$1 -> {
            TreeEnsembleModel.$anonfun$predictByVoting$1(features, votes, x0$1);
            return BoxedUnit.UNIT;
        });
        return ((Tuple2)votes.maxBy((Function1 & Serializable)x$10 -> BoxesRunTime.boxToDouble((double)x$10._2$mcD$sp()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$))._1$mcI$sp();
    }

    public double predict(Vector features) {
        Tuple2 tuple2 = new Tuple2((Object)this.algo(), (Object)this.combiningStrategy());
        if (tuple2 != null) {
            Enumeration.Value value = (Enumeration.Value)tuple2._1();
            Enumeration.Value value2 = (Enumeration.Value)tuple2._2();
            Enumeration.Value value3 = Algo$.MODULE$.Regression();
            Enumeration.Value value4 = value;
            if (!(value3 != null ? !value3.equals(value4) : value4 != null)) {
                Enumeration.Value value5 = EnsembleCombiningStrategy$.MODULE$.Sum();
                Enumeration.Value value6 = value2;
                if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                    return this.predictBySumming(features);
                }
            }
        }
        if (tuple2 != null) {
            Enumeration.Value value = (Enumeration.Value)tuple2._1();
            Enumeration.Value value7 = (Enumeration.Value)tuple2._2();
            Enumeration.Value value8 = Algo$.MODULE$.Regression();
            Enumeration.Value value9 = value;
            if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                Enumeration.Value value10 = EnsembleCombiningStrategy$.MODULE$.Average();
                Enumeration.Value value11 = value7;
                if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                    return this.predictBySumming(features) / this.sumWeights();
                }
            }
        }
        if (tuple2 != null) {
            Enumeration.Value value = (Enumeration.Value)tuple2._1();
            Enumeration.Value value12 = (Enumeration.Value)tuple2._2();
            Enumeration.Value value13 = Algo$.MODULE$.Classification();
            Enumeration.Value value14 = value;
            if (!(value13 != null ? !value13.equals(value14) : value14 != null)) {
                Enumeration.Value value15 = EnsembleCombiningStrategy$.MODULE$.Sum();
                Enumeration.Value value16 = value12;
                if (!(value15 != null ? !value15.equals(value16) : value16 != null)) {
                    double prediction = this.predictBySumming(features);
                    if (prediction > 0.0) {
                        return 1.0;
                    }
                    return 0.0;
                }
            }
        }
        if (tuple2 != null) {
            Enumeration.Value value = (Enumeration.Value)tuple2._1();
            Enumeration.Value value17 = (Enumeration.Value)tuple2._2();
            Enumeration.Value value18 = Algo$.MODULE$.Classification();
            Enumeration.Value value19 = value;
            if (!(value18 != null ? !value18.equals(value19) : value19 != null)) {
                Enumeration.Value value20 = EnsembleCombiningStrategy$.MODULE$.Vote();
                Enumeration.Value value21 = value17;
                if (!(value20 != null ? !value20.equals(value21) : value21 != null)) {
                    return this.predictByVoting(features);
                }
            }
        }
        throw new IllegalArgumentException("TreeEnsembleModel given unsupported (algo, combiningStrategy) combination: (" + this.algo() + ", " + this.combiningStrategy() + ").");
    }

    public RDD<Object> predict(RDD<Vector> features) {
        return features.map((Function1 & Serializable)x -> BoxesRunTime.boxToDouble((double)this.predict(x)), (ClassTag)ClassTag$.MODULE$.Double());
    }

    public JavaRDD<Double> predict(JavaRDD<Vector> features) {
        return this.predict((RDD<Vector>)features.rdd()).toJavaRDD();
    }

    public String toString() {
        Enumeration.Value value = this.algo();
        Enumeration.Value value2 = Algo$.MODULE$.Classification();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return "TreeEnsembleModel classifier with " + this.numTrees() + " trees\n";
        }
        Enumeration.Value value4 = Algo$.MODULE$.Regression();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return "TreeEnsembleModel regressor with " + this.numTrees() + " trees\n";
        }
        throw new IllegalArgumentException("TreeEnsembleModel given unknown algo parameter: " + this.algo() + ".");
    }

    public String toDebugString() {
        String header = this.toString() + "\n";
        return header + ArrayOps$.MODULE$.fold$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])this.trees()))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                DecisionTreeModel tree = (DecisionTreeModel)tuple2._1();
                int treeIndex = tuple2._2$mcI$sp();
                return "  Tree " + treeIndex + ":\n" + tree.topNode().subtreeToString(4);
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(String.class))), (Object)"", (Function2 & Serializable)(x$11, x$12) -> x$11 + x$12);
    }

    public int numTrees() {
        return this.trees().length;
    }

    public int totalNumNodes() {
        return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.trees()), (Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.numNodes()), (ClassTag)ClassTag$.MODULE$.Int())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$predictByVoting$1(Vector features$2, Map votes$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            DecisionTreeModel tree = (DecisionTreeModel)tuple2._1();
            double weight = tuple2._2$mcD$sp();
            int prediction = (int)tree.predict(features$2);
            votes$1.update((Object)BoxesRunTime.boxToInteger((int)prediction), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)votes$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)prediction), (Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0)) + weight)));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public TreeEnsembleModel(Enumeration.Value algo, DecisionTreeModel[] trees, double[] treeWeights, Enumeration.Value combiningStrategy) {
        this.algo = algo;
        this.trees = trees;
        this.treeWeights = treeWeights;
        this.combiningStrategy = combiningStrategy;
        Predef$.MODULE$.require(this.numTrees() > 0, (Function0 & Serializable)() -> "TreeEnsembleModel cannot be created without trees.");
        this.sumWeights = package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(treeWeights).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)), 1.0E-15);
    }
}

