/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.util.VersionInfo;
import org.apache.orc.impl.HadoopShims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopShimsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopShimsFactory.class);
    private static final String CURRENT_SHIM_NAME = "org.apache.orc.impl.HadoopShimsCurrent";
    private static volatile HadoopShims SHIMS = null;

    private static HadoopShims createShimByName(String name) {
        try {
            Class<?> cls = Class.forName(name);
            return (HadoopShims)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Can't create shims for " + name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HadoopShims get() {
        if (SHIMS != null) return SHIMS;
        Class<HadoopShimsFactory> clazz = HadoopShimsFactory.class;
        synchronized (HadoopShimsFactory.class) {
            if (SHIMS != null) return SHIMS;
            String[] versionParts = VersionInfo.getVersion().split("[.]");
            int major = Integer.parseInt(versionParts[0]);
            int minor = Integer.parseInt(versionParts[1]);
            if (major < 2 || major == 2 && minor < 7) {
                LOG.warn("Hadoop " + VersionInfo.getVersion() + " support is dropped.");
            }
            SHIMS = HadoopShimsFactory.createShimByName(CURRENT_SHIM_NAME);
            // ** MonitorExit[var0] (shouldn't be in output)
            return SHIMS;
        }
    }
}

