/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.PartitionStatistics;
import org.apache.spark.sql.execution.command.RepairTableCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ArrayImplicits$;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.immutable.ParVector;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\tug\u0001B\u0016-\u0001fB\u0001B\u0017\u0001\u0003\u0016\u0004%\ta\u0017\u0005\tA\u0002\u0011\t\u0012)A\u00059\"A\u0011\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005g\u0001\tE\t\u0015!\u0003d\u0011!9\u0007A!f\u0001\n\u0003\u0011\u0007\u0002\u00035\u0001\u0005#\u0005\u000b\u0011B2\t\u0011%\u0004!Q3A\u0005\u0002)D\u0001b\u001d\u0001\u0003\u0012\u0003\u0006Ia\u001b\u0005\u0006i\u0002!\t!\u001e\u0005\bw\u0002\u0011\r\u0011\"\u0001}\u0011\u001d\tI\u0001\u0001Q\u0001\nuD\u0001\"a\u0003\u0001\u0005\u0004%\t\u0001 \u0005\b\u0003\u001b\u0001\u0001\u0015!\u0003~\u0011!\ty\u0001\u0001b\u0001\n\u0003a\bbBA\t\u0001\u0001\u0006I! \u0005\b\u0003'\u0001A\u0011BA\u000b\u0011\u001d\t9\u0004\u0001C!\u0003sAq!!\u0015\u0001\t\u0013\t\u0019\u0006C\u0004\u0002`\u0002!I!!9\t\u000f\u0005u\b\u0001\"\u0003\u0002\u0000\"9!1\u0004\u0001\u0005\n\tu\u0001\"\u0003B\u0015\u0001\u0005\u0005I\u0011\u0001B\u0016\u0011%\u0011)\u0004AI\u0001\n\u0003\u00119\u0004C\u0005\u0003N\u0001\t\n\u0011\"\u0001\u0003P!I!1\u000b\u0001\u0012\u0002\u0013\u0005!q\n\u0005\n\u0005+\u0002\u0011\u0013!C\u0001\u0005/B\u0001Ba\u0017\u0001\u0003\u0003%\t\u0005 \u0005\n\u0005;\u0002\u0011\u0011!C\u0001\u0005?B\u0011B!\u0019\u0001\u0003\u0003%\tAa\u0019\t\u0013\t=\u0004!!A\u0005B\tE\u0004\"\u0003B>\u0001\u0005\u0005I\u0011\u0001B?\u0011%\u0011\t\tAA\u0001\n\u0003\u0012\u0019\tC\u0005\u0003\b\u0002\t\t\u0011\"\u0011\u0003\n\u001eI!Q\u0012\u0017\u0002\u0002#\u0005!q\u0012\u0004\tW1\n\t\u0011#\u0001\u0003\u0012\"1Ao\tC\u0001\u0005SC\u0011Ba+$\u0003\u0003%)E!,\t\u0013\t=6%!A\u0005\u0002\nE\u0006\"\u0003B^GE\u0005I\u0011\u0001B,\u0011%\u0011ilIA\u0001\n\u0003\u0013y\fC\u0005\u0003R\u000e\n\n\u0011\"\u0001\u0003X!I!1[\u0012\u0002\u0002\u0013%!Q\u001b\u0002\u0013%\u0016\u0004\u0018-\u001b:UC\ndWmQ8n[\u0006tGM\u0003\u0002.]\u000591m\\7nC:$'BA\u00181\u0003%)\u00070Z2vi&|gN\u0003\u00022e\u0005\u00191/\u001d7\u000b\u0005M\"\u0014!B:qCJ\\'BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001e\u001c\u0001aE\u0003\u0001u\u0011Ce\n\u0005\u0002<\u00056\tAH\u0003\u0002>}\u00059An\\4jG\u0006d'BA A\u0003\u0015\u0001H.\u00198t\u0015\t\t\u0005'\u0001\u0005dCR\fG._:u\u0013\t\u0019EHA\u0006M_\u001eL7-\u00197QY\u0006t\u0007CA#G\u001b\u0005a\u0013BA$-\u0005MaU-\u00194Sk:t\u0017M\u00197f\u0007>lW.\u00198e!\tIE*D\u0001K\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0005\u001d\u0001&o\u001c3vGR\u0004\"aT,\u000f\u0005A+fBA)U\u001b\u0005\u0011&BA*9\u0003\u0019a$o\\8u}%\t1*\u0003\u0002W\u0015\u00069\u0001/Y2lC\u001e,\u0017B\u0001-Z\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t1&*A\u0005uC\ndWMT1nKV\tA\f\u0005\u0002^=6\t\u0001)\u0003\u0002`\u0001\nyA+\u00192mK&#WM\u001c;jM&,'/\u0001\u0006uC\ndWMT1nK\u0002\n1#\u001a8bE2,\u0017\t\u001a3QCJ$\u0018\u000e^5p]N,\u0012a\u0019\t\u0003\u0013\u0012L!!\u001a&\u0003\u000f\t{w\u000e\\3b]\u0006!RM\\1cY\u0016\fE\r\u001a)beRLG/[8og\u0002\nA#\u001a8bE2,GI]8q!\u0006\u0014H/\u001b;j_:\u001c\u0018!F3oC\ndW\r\u0012:paB\u000b'\u000f^5uS>t7\u000fI\u0001\u0004G6$W#A6\u0011\u00051\u0004hBA7o!\t\t&*\u0003\u0002p\u0015\u00061\u0001K]3eK\u001aL!!\u001d:\u0003\rM#(/\u001b8h\u0015\ty'*\u0001\u0003d[\u0012\u0004\u0013A\u0002\u001fj]&$h\bF\u0003wobL(\u0010\u0005\u0002F\u0001!)!,\u0003a\u00019\")\u0011-\u0003a\u0001G\")q-\u0003a\u0001G\"9\u0011.\u0003I\u0001\u0002\u0004Y\u0017!\u0003(V\u001b~3\u0015\nT#T+\u0005i\bc\u0001@\u0002\b5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001\u00027b]\u001eT!!!\u0002\u0002\t)\fg/Y\u0005\u0003c~\f!BT+N?\u001aKE*R*!\u0003)!v\nV!M?NK%,R\u0001\f)>#\u0016\tT0T\u0013j+\u0005%\u0001\u0005E\t2{F+S'F\u0003%!E\tT0U\u00136+\u0005%A\u0007hKR\u0004\u0016\r\u001e5GS2$XM\u001d\u000b\u0005\u0003/\t9\u0003\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0005\u0019\u001c(bAA\u0011i\u00051\u0001.\u00193p_BLA!!\n\u0002\u001c\tQ\u0001+\u0019;i\r&dG/\u001a:\t\u000f\u0005%\u0002\u00031\u0001\u0002,\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\t\u00055\u00121G\u0007\u0003\u0003_QA!!\r\u0002 \u0005!1m\u001c8g\u0013\u0011\t)$a\f\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003\r\u0011XO\u001c\u000b\u0005\u0003w\tI\u0005E\u0003P\u0003{\t\t%C\u0002\u0002@e\u00131aU3r!\u0011\t\u0019%!\u0012\u000e\u0003AJ1!a\u00121\u0005\r\u0011vn\u001e\u0005\u0007gE\u0001\r!a\u0013\u0011\t\u0005\r\u0013QJ\u0005\u0004\u0003\u001f\u0002$\u0001D*qCJ\\7+Z:tS>t\u0017AD:dC:\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0015\u0003+\ni)a$\u0002\u0018\u0006m\u0015qTAR\u0003S\u000b\u0019,a3\u0011\u000b=\u000bi$a\u0016\u0011\u000f%\u000bI&!\u0018\u0002\b&\u0019\u00111\f&\u0003\rQ+\b\u000f\\33!\u0011\ty&!!\u000f\t\u0005\u0005\u00141\u0010\b\u0005\u0003G\n9H\u0004\u0003\u0002f\u0005Ud\u0002BA4\u0003grA!!\u001b\u0002r9!\u00111NA8\u001d\r\t\u0016QN\u0005\u0002o%\u0011QGN\u0005\u0003gQJ!!\r\u001a\n\u0005\u0005\u0003\u0014bAA=\u0001\u000691-\u0019;bY><\u0017\u0002BA?\u0003\u007f\nAbQ1uC2|w\rV=qKNT1!!\u001fA\u0013\u0011\t\u0019)!\"\u0003%Q\u000b'\r\\3QCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0006\u0005\u0003{\ny\b\u0005\u0003\u0002\u001a\u0005%\u0015\u0002BAF\u00037\u0011A\u0001U1uQ\"11G\u0005a\u0001\u0003\u0017Bq!!\b\u0013\u0001\u0004\t\t\n\u0005\u0003\u0002\u001a\u0005M\u0015\u0002BAK\u00037\u0011!BR5mKNK8\u000f^3n\u0011\u001d\tIJ\u0005a\u0001\u0003/\taAZ5mi\u0016\u0014\bbBAO%\u0001\u0007\u0011qQ\u0001\u0005a\u0006$\b\u000eC\u0004\u0002\"J\u0001\r!!\u0018\u0002\tM\u0004Xm\u0019\u0005\b\u0003K\u0013\u0002\u0019AAT\u00039\u0001\u0018M\u001d;ji&|gNT1nKN\u0004BaTA\u001fW\"9\u00111\u0016\nA\u0002\u00055\u0016!\u0003;ie\u0016\u001c\bn\u001c7e!\rI\u0015qV\u0005\u0004\u0003cS%aA%oi\"9\u0011Q\u0017\nA\u0002\u0005]\u0016\u0001\u0003:fg>dg/\u001a:\u0011\t\u0005e\u0016Q\u0019\b\u0005\u0003w\u000b\tM\u0004\u0003\u0002d\u0005u\u0016bAA`\u0001\u0006A\u0011M\\1msNL7/C\u0002W\u0003\u0007T1!a0A\u0013\u0011\t9-!3\u0003\u0011I+7o\u001c7wKJT1AVAb\u0011\u001d\tiM\u0005a\u0001\u0003\u001f\fq\"\u001a<bYR\u000b7o[*vaB|'\u000f\u001e\t\u0005\u0003#\fY.\u0004\u0002\u0002T*!\u0011Q[Al\u0003!\u0001\u0018M]1mY\u0016d'bAAm\u0015\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005u\u00171\u001b\u0002\u0014\r>\u00148NS8j]R\u000b7o[*vaB|'\u000f^\u0001\u0015O\u0006$\b.\u001a:QCJ$\u0018\u000e^5p]N#\u0018\r^:\u0015\u0019\u0005\r\u0018q^Ay\u0003k\f90a?\u0011\u000f1\f)/a\"\u0002j&\u0019\u0011q\u001d:\u0003\u00075\u000b\u0007\u000fE\u0002F\u0003WL1!!<-\u0005M\u0001\u0016M\u001d;ji&|gn\u0015;bi&\u001cH/[2t\u0011\u0019\u00194\u00031\u0001\u0002L!9\u00111_\nA\u0002\u0005U\u0013!\u00069beRLG/[8o'B,7m]!oI2{7m\u001d\u0005\b\u0003;\u0019\u0002\u0019AAI\u0011\u001d\tIp\u0005a\u0001\u0003/\t!\u0002]1uQ\u001aKG\u000e^3s\u0011\u001d\tYk\u0005a\u0001\u0003[\u000bQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cHC\u0003B\u0001\u0005\u000f\u0011IA!\u0006\u0003\u0018A\u0019\u0011Ja\u0001\n\u0007\t\u0015!J\u0001\u0003V]&$\bBB\u001a\u0015\u0001\u0004\tY\u0005C\u0004\u0003\fQ\u0001\rA!\u0004\u0002\u000bQ\f'\r\\3\u0011\t\t=!\u0011C\u0007\u0003\u0003\u007fJAAa\u0005\u0002\u0000\ta1)\u0019;bY><G+\u00192mK\"9\u00111\u001f\u000bA\u0002\u0005U\u0003b\u0002B\r)\u0001\u0007\u00111]\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cF/\u0019;t\u00039!'o\u001c9QCJ$\u0018\u000e^5p]N$b!!,\u0003 \t\u001d\u0002bBA=+\u0001\u0007!\u0011\u0005\t\u0005\u0005\u001f\u0011\u0019#\u0003\u0003\u0003&\u0005}$AD*fgNLwN\\\"bi\u0006dwn\u001a\u0005\b\u0003;)\u0002\u0019AAI\u0003\u0011\u0019w\u000e]=\u0015\u0013Y\u0014iCa\f\u00032\tM\u0002b\u0002.\u0017!\u0003\u0005\r\u0001\u0018\u0005\bCZ\u0001\n\u00111\u0001d\u0011\u001d9g\u0003%AA\u0002\rDq!\u001b\f\u0011\u0002\u0003\u00071.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\te\"f\u0001/\u0003<-\u0012!Q\b\t\u0005\u0005\u007f\u0011I%\u0004\u0002\u0003B)!!1\tB#\u0003%)hn\u00195fG.,GMC\u0002\u0003H)\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YE!\u0011\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tE#fA2\u0003<\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u00053R3a\u001bB\u001e\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011QV\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011)Ga\u001b\u0011\u0007%\u00139'C\u0002\u0003j)\u00131!\u00118z\u0011%\u0011i'HA\u0001\u0002\u0004\ti+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005g\u0002bA!\u001e\u0003x\t\u0015TBAAl\u0013\u0011\u0011I(a6\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004G\n}\u0004\"\u0003B7?\u0005\u0005\t\u0019\u0001B3\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\u0007u\u0014)\tC\u0005\u0003n\u0001\n\t\u00111\u0001\u0002.\u00061Q-];bYN$2a\u0019BF\u0011%\u0011i'IA\u0001\u0002\u0004\u0011)'\u0001\nSKB\f\u0017N\u001d+bE2,7i\\7nC:$\u0007CA#$'\u0015\u0019#1\u0013BP!%\u0011)Ja']G\u000e\\g/\u0004\u0002\u0003\u0018*\u0019!\u0011\u0014&\u0002\u000fI,h\u000e^5nK&!!Q\u0014BL\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0005C\u00139+\u0004\u0002\u0003$*!!QUA\u0002\u0003\tIw.C\u0002Y\u0005G#\"Aa$\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!`\u0001\u0006CB\u0004H.\u001f\u000b\nm\nM&Q\u0017B\\\u0005sCQA\u0017\u0014A\u0002qCQ!\u0019\u0014A\u0002\rDQa\u001a\u0014A\u0002\rDq!\u001b\u0014\u0011\u0002\u0003\u00071.A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0003\u001d)h.\u00199qYf$BA!1\u0003NB)\u0011Ja1\u0003H&\u0019!Q\u0019&\u0003\r=\u0003H/[8o!\u001dI%\u0011\u001a/dG.L1Aa3K\u0005\u0019!V\u000f\u001d7fi!A!q\u001a\u0015\u0002\u0002\u0003\u0007a/A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001Bl!\rq(\u0011\\\u0005\u0004\u00057|(AB(cU\u0016\u001cG\u000f")
public class RepairTableCommand
extends LogicalPlan
implements LeafRunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final boolean enableAddPartitions;
    private final boolean enableDropPartitions;
    private final String cmd;
    private final String NUM_FILES;
    private final String TOTAL_SIZE;
    private final String DDL_TIME;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$4() {
        return RepairTableCommand$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<TableIdentifier, Object, Object, String>> unapply(RepairTableCommand x$0) {
        return RepairTableCommand$.MODULE$.unapply(x$0);
    }

    public static String apply$default$4() {
        return RepairTableCommand$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<TableIdentifier, Object, Object, String>, RepairTableCommand> tupled() {
        return RepairTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, Function1<Object, Function1<String, RepairTableCommand>>>> curried() {
        return RepairTableCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        RepairTableCommand repairTableCommand = this;
        synchronized (repairTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public boolean enableAddPartitions() {
        return this.enableAddPartitions;
    }

    public boolean enableDropPartitions() {
        return this.enableDropPartitions;
    }

    public String cmd() {
        return this.cmd;
    }

    public String NUM_FILES() {
        return this.NUM_FILES;
    }

    public String TOTAL_SIZE() {
        return this.TOTAL_SIZE;
    }

    public String DDL_TIME() {
        return this.DDL_TIME;
    }

    private PathFilter getPathFilter(Configuration hadoopConf) {
        JobConf jobConf = new JobConf(hadoopConf, this.getClass());
        PathFilter pathFilter = FileInputFormat.getInputPathFilter((JobConf)jobConf);
        return path -> {
            String name;
            String string = name = path.getName();
            String string2 = "_SUCCESS";
            if (string == null ? string2 != null : !string.equals(string2)) {
                String string3 = name;
                String string4 = "_temporary";
                if ((string3 == null ? string4 != null : !string3.equals(string4)) && !name.startsWith(".")) {
                    return pathFilter == null || pathFilter.accept(path);
                }
            }
            return false;
        };
    }

    @Override
    public Seq<Row> run(SparkSession spark) {
        int n;
        int droppedAmount;
        SessionCatalog catalog = spark.sessionState().catalog();
        CatalogTable table = catalog.getTableRawMetadata(this.tableName());
        String tableIdentWithDB = table.identifier().quotedString();
        if (table.partitionColumnNames().isEmpty()) {
            throw QueryCompilationErrors$.MODULE$.cmdOnlyWorksOnPartitionedTablesError(this.cmd(), tableIdentWithDB);
        }
        if (table.storage().locationUri().isEmpty()) {
            throw QueryCompilationErrors$.MODULE$.cmdOnlyWorksOnTableWithLocationError(this.cmd(), tableIdentWithDB);
        }
        Path root = new Path(table.location());
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Recover all the partitions in ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, root)}))));
        Configuration hadoopConf = spark.sessionState().newHadoopConf();
        FileSystem fs = root.getFileSystem(hadoopConf);
        int n2 = droppedAmount = this.enableDropPartitions() ? this.dropPartitions(catalog, fs) : 0;
        if (this.enableAddPartitions()) {
            Seq<Tuple2<Map<String, String>, Path>> seq;
            int threshold = BoxesRunTime.unboxToInt((Object)spark.sparkContext().conf().get(org.apache.spark.internal.config.package$.MODULE$.RDD_PARALLEL_LISTING_THRESHOLD()));
            PathFilter pathFilter = this.getPathFilter(hadoopConf);
            ForkJoinPool evalPool = ThreadUtils$.MODULE$.newForkJoinPool("RepairTableCommand", 8);
            try {
                seq = this.scanPartitions(spark, fs, pathFilter, root, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Seq<String>)table.partitionColumnNames(), threshold, (Function2<String, String, Object>)spark.sessionState().conf().resolver(), new ForkJoinTaskSupport(evalPool));
            }
            finally {
                evalPool.shutdown();
            }
            Seq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs = seq;
            int total = partitionSpecsAndLocs.length();
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " partitions "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_PARTITIONS, BoxesRunTime.boxToInteger((int)total))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"in ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, root)})))));
            Map<Path, PartitionStatistics> partitionStats = spark.sessionState().conf().gatherFastStats() ? this.gatherPartitionStats(spark, partitionSpecsAndLocs, fs, pathFilter, threshold) : Predef$.MODULE$.Map().empty();
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Finished to gather the fast stats for all "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " partitions."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_PARTITIONS, BoxesRunTime.boxToInteger((int)total))})))));
            this.addPartitions(spark, table, partitionSpecsAndLocs, partitionStats);
            n = total;
        } else {
            n = 0;
        }
        int addedAmount = n;
        boolean x$1 = true;
        TableIdentifier x$2 = table.copy$default$1();
        CatalogTableType x$3 = table.copy$default$2();
        CatalogStorageFormat x$4 = table.copy$default$3();
        StructType x$5 = table.copy$default$4();
        Option x$6 = table.copy$default$5();
        Seq x$7 = table.copy$default$6();
        Option x$8 = table.copy$default$7();
        String x$9 = table.copy$default$8();
        long x$10 = table.copy$default$9();
        long x$11 = table.copy$default$10();
        String x$12 = table.copy$default$11();
        Map x$13 = table.copy$default$12();
        Option x$14 = table.copy$default$13();
        Option x$15 = table.copy$default$14();
        Option x$16 = table.copy$default$15();
        Option x$17 = table.copy$default$16();
        Seq x$18 = table.copy$default$17();
        boolean x$19 = table.copy$default$19();
        Map x$20 = table.copy$default$20();
        Option x$21 = table.copy$default$21();
        spark.sessionState().catalog().alterTable(table.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, true, x$19, x$20, x$21));
        try {
            spark.catalog().refreshTable(tableIdentWithDB);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot refresh the table '", "'. "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TABLE_NAME, tableIdentWithDB)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A query of the table might return wrong result if the table was cached. "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"To avoid such issue, you should uncache the table manually via the UNCACHE TABLE "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"command after table recovering will complete fully."}))).log((Seq)Nil$.MODULE$))), throwable2);
            }
            throw throwable;
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Recovered all partitions: "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"added (", "), "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_ADDED_PARTITIONS, BoxesRunTime.boxToInteger((int)addedAmount))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"dropped (", ")."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_DROPPED_PARTITIONS, BoxesRunTime.boxToInteger((int)droppedAmount))})))));
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private Seq<Tuple2<Map<String, String>, Path>> scanPartitions(SparkSession spark, FileSystem fs, PathFilter filter, Path path, Map<String, String> spec, Seq<String> partitionNames, int threshold, Function2<String, String, Object> resolver, ForkJoinTaskSupport evalTaskSupport) {
        ArraySeq arraySeq;
        if (partitionNames.isEmpty()) {
            return new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(spec), (Object)path), (List)Nil$.MODULE$);
        }
        FileStatus[] statuses = fs.listStatus(path, filter);
        if (partitionNames.length() > 1 && statuses.length > threshold || partitionNames.length() > 2) {
            ParVector parArray = new ParVector(Predef$.MODULE$.wrapRefArray((Object[])statuses).toVector());
            parArray.tasksupport_$eq((TaskSupport)evalTaskSupport);
            arraySeq = parArray.seq();
        } else {
            arraySeq = ArrayImplicits$.MODULE$.SparkArrayOps((Object)statuses).toImmutableArraySeq();
        }
        ArraySeq statusPar = arraySeq;
        return (Seq)statusPar.flatMap((Function1 & Serializable)st -> {
            String name = st.getPath().getName();
            if (st.isDirectory() && name.contains("=")) {
                String[] ps = name.split("=", 2);
                String columnName = ExternalCatalogUtils$.MODULE$.unescapePathName(ps[0]);
                String value = ExternalCatalogUtils$.MODULE$.unescapePathName(ps[1]);
                if (BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)columnName, partitionNames.head()))) {
                    return this.scanPartitions(spark, fs, filter, st.getPath(), (Map<String, String>)((Map)spec.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partitionNames.head()), (Object)value)})))), (Seq<String>)((Seq)partitionNames.drop(1)), threshold, resolver, evalTaskSupport);
                }
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"expected partition column "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ","}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.EXPECTED_PARTITION_COLUMN, partitionNames.head())}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" but got ", ", ignoring it"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.ACTUAL_PARTITION_COLUMN, ps[0])})))));
                return package$.MODULE$.Seq().empty();
            }
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ignore ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PATH, new Path(path, name))}))));
            return package$.MODULE$.Seq().empty();
        });
    }

    private Map<Path, PartitionStatistics> gatherPartitionStats(SparkSession spark, Seq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, FileSystem fs, PathFilter pathFilter, int threshold) {
        int partitionNum = partitionSpecsAndLocs.length();
        if (partitionNum > threshold) {
            Configuration hadoopConf = spark.sessionState().newHadoopConf();
            SerializableConfiguration serializableConfiguration = new SerializableConfiguration(hadoopConf);
            Seq locations = (Seq)partitionSpecsAndLocs.map((Function1 & Serializable)x$6 -> (Path)x$6._2());
            int numParallelism = Math.min(partitionNum, Math.min(spark.sparkContext().defaultParallelism(), 10000));
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Gather the fast stats in parallel using ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.COUNT, BoxesRunTime.boxToInteger((int)numParallelism))})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tasks."}))).log((Seq)Nil$.MODULE$))));
            RDD qual$1 = spark.sparkContext().parallelize(locations, numParallelism, ClassTag$.MODULE$.apply(Path.class));
            Function1 & Serializable x$1 = (Function1 & Serializable)locationsEachPartition -> {
                PathFilter pathFilter = this.getPathFilter(serializableConfiguration.value());
                return locationsEachPartition.map((Function1 & Serializable)location -> {
                    FileSystem fs = location.getFileSystem(serializableConfiguration.value());
                    FileStatus[] statuses = fs.listStatus(location, pathFilter);
                    return new Tuple2(location, (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])statuses), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.getLen()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
                });
            };
            boolean x$2 = qual$1.mapPartitions$default$2();
            return RDD$.MODULE$.rddToPairRDDFunctions(qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Path.class), ClassTag$.MODULE$.apply(PartitionStatistics.class), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())).collectAsMap().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        return ((IterableOnceOps)partitionSpecsAndLocs.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Path location = (Path)tuple2._2();
                FileStatus[] statuses = fs.listStatus(location, pathFilter);
                return new Tuple2((Object)location, (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])statuses), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.getLen()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
            }
            throw new MatchError((Object)tuple2);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void addPartitions(SparkSession spark, CatalogTable table, Seq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, Map<Path, PartitionStatistics> partitionStats) {
        int total = partitionSpecsAndLocs.length();
        LongRef done = LongRef.create((long)0L);
        int batchSize = BoxesRunTime.unboxToInt((Object)spark.sessionState().conf().getConf(SQLConf$.MODULE$.ADD_PARTITION_BATCH_SIZE()));
        partitionSpecsAndLocs.iterator().grouped(batchSize).foreach((Function1 & Serializable)batch -> {
            RepairTableCommand.$anonfun$addPartitions$1(this, partitionStats, table, spark, done, total, batch);
            return BoxedUnit.UNIT;
        });
    }

    private int dropPartitions(SessionCatalog catalog, FileSystem fs) {
        Seq dropPartSpecs = (Seq)ThreadUtils$.MODULE$.parmap(catalog.listPartitions(this.tableName(), catalog.listPartitions$default$2()), "RepairTableCommand: non-existing partitions", 8, (Function1 & Serializable)partition -> partition.storage().locationUri().flatMap((Function1 & Serializable)uri -> {
            if (fs.exists(new Path(uri))) {
                return None$.MODULE$;
            }
            return new Some((Object)partition.spec());
        })).flatten(Predef$.MODULE$.$conforms());
        catalog.dropPartitions(this.tableName(), dropPartSpecs, true, false, true);
        return dropPartSpecs.length();
    }

    public RepairTableCommand copy(TableIdentifier tableName, boolean enableAddPartitions, boolean enableDropPartitions, String cmd) {
        return new RepairTableCommand(tableName, enableAddPartitions, enableDropPartitions, cmd);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public boolean copy$default$2() {
        return this.enableAddPartitions();
    }

    public boolean copy$default$3() {
        return this.enableDropPartitions();
    }

    public String copy$default$4() {
        return this.cmd();
    }

    public String productPrefix() {
        return "RepairTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.tableName();
            }
            case 1: {
                return BoxesRunTime.boxToBoolean((boolean)this.enableAddPartitions());
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.enableDropPartitions());
            }
            case 3: {
                return this.cmd();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RepairTableCommand;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "tableName";
            }
            case 1: {
                return "enableAddPartitions";
            }
            case 2: {
                return "enableDropPartitions";
            }
            case 3: {
                return "cmd";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RepairTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        RepairTableCommand repairTableCommand = (RepairTableCommand)x$1;
        if (this.enableAddPartitions() != repairTableCommand.enableAddPartitions()) return false;
        if (this.enableDropPartitions() != repairTableCommand.enableDropPartitions()) return false;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = repairTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.cmd();
        String string2 = repairTableCommand.cmd();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!repairTableCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$addPartitions$1(RepairTableCommand $this, Map partitionStats$1, CatalogTable table$5, SparkSession spark$2, LongRef done$1, int total$2, Seq batch) {
        long now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        Seq parts = (Seq)batch.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Map spec = (Map)tuple2._1();
                Path location = (Path)tuple2._2();
                Map params = (Map)partitionStats$1.get((Object)location).map((Function1 & Serializable)x0$2 -> {
                    PartitionStatistics partitionStatistics = x0$2;
                    if (partitionStatistics != null) {
                        int numFiles = partitionStatistics.numFiles();
                        long totalSize = partitionStatistics.totalSize();
                        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.NUM_FILES()), (Object)Integer.toString(numFiles)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.TOTAL_SIZE()), (Object)Long.toString(totalSize)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.DDL_TIME()), (Object)Long.toString(now))}));
                    }
                    throw new MatchError((Object)partitionStatistics);
                }).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
                return new CatalogTablePartition(spec, table$5.storage().copy((Option)new Some((Object)location.toUri()), table$5.storage().copy$default$2(), table$5.storage().copy$default$3(), table$5.storage().copy$default$4(), table$5.storage().copy$default$5(), table$5.storage().copy$default$6()), params, CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
            }
            throw new MatchError((Object)tuple2);
        });
        spark$2.sessionState().catalog().createPartitions($this.tableName(), parts, true);
        done$1.elem += (long)parts.length();
        $this.logDebug((Function0 & Serializable)() -> "Recovered " + parts.length() + " partitions (" + done$1.elem + "/" + total$2 + " so far)");
    }

    public RepairTableCommand(TableIdentifier tableName, boolean enableAddPartitions, boolean enableDropPartitions, String cmd) {
        this.tableName = tableName;
        this.enableAddPartitions = enableAddPartitions;
        this.enableDropPartitions = enableDropPartitions;
        this.cmd = cmd;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
        this.NUM_FILES = "numFiles";
        this.TOTAL_SIZE = "totalSize";
        this.DDL_TIME = "transient_lastDdlTime";
        Statics.releaseFence();
    }
}

