/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.util.Iterator;
import org.apache.axiom.core.Axis;
import org.apache.axiom.core.ChildNotAllowedException;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.Mappers;
import org.apache.axiom.core.NodeType;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMInformationItem;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSerializable;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.intf.AxiomDocument;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.om.impl.intf.AxiomSerializable;
import org.apache.axiom.om.impl.llom.AxiomContainerImpl;

public class AxiomDocumentImpl
extends AxiomContainerImpl
implements AxiomDocument,
OMDocument,
OMContainer,
OMSerializable,
OMInformationItem,
CoreDocument {
    private String inputEncoding;
    private String xmlVersion;
    private String xmlEncoding;
    private Boolean standalone;

    public AxiomDocumentImpl() {
        this.init$AxiomDocumentMixin();
        this.init$CoreDocumentMixin();
    }

    private void init$AxiomDocumentMixin() {
    }

    private void init$CoreDocumentMixin() {
        this.xmlVersion = "1.0";
    }

    @Override
    public final OMElement getOMDocumentElement() {
        try {
            return (OMElement)((Object)this.coreGetDocumentElement());
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final void setOMDocumentElement(OMElement documentElement) {
        try {
            if (documentElement == null) {
                throw new IllegalArgumentException("documentElement must not be null");
            }
            AxiomElement existingDocumentElement = (AxiomElement)this.coreGetDocumentElement();
            if (existingDocumentElement == null) {
                this.addChild(documentElement);
            } else {
                existingDocumentElement.coreReplaceWith((AxiomElement)documentElement, AxiomSemantics.INSTANCE);
            }
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final String getCharsetEncoding() {
        String inputEncoding = this.coreGetInputEncoding();
        return inputEncoding == null ? "UTF-8" : inputEncoding;
    }

    @Override
    public final void setCharsetEncoding(String charsetEncoding) {
        this.coreSetInputEncoding(charsetEncoding);
    }

    @Override
    public final String getXMLVersion() {
        return this.coreGetXmlVersion();
    }

    @Override
    public final void setXMLVersion(String xmlVersion) {
        this.coreSetXmlVersion(xmlVersion);
    }

    @Override
    public final String getXMLEncoding() {
        return this.coreGetXmlEncoding();
    }

    @Override
    public final void setXMLEncoding(String xmlEncoding) {
        this.coreSetXmlEncoding(xmlEncoding);
    }

    @Override
    public final String isStandalone() {
        Boolean standalone = this.coreGetStandalone();
        if (standalone == null) {
            return null;
        }
        return standalone != false ? "yes" : "no";
    }

    @Override
    public final void setStandalone(String standalone) {
        this.coreSetStandalone("yes".equalsIgnoreCase(standalone));
    }

    @Override
    public final void checkChild(OMNode child) {
        if (child instanceof OMElement) {
            if (this.getOMDocumentElement() != null) {
                throw new OMException("Document element already exists");
            }
            this.checkDocumentElement((OMElement)child);
        }
    }

    public void checkDocumentElement(OMElement element) {
    }

    @Override
    public final CoreElement getContextElement() {
        return null;
    }

    @Override
    public Iterator<OMSerializable> getDescendants(boolean includeSelf) {
        return this.coreGetNodes(includeSelf ? Axis.DESCENDANTS_OR_SELF : Axis.DESCENDANTS, AxiomSerializable.class, Mappers.identity(), AxiomSemantics.INSTANCE);
    }

    @Override
    public final NodeType coreGetNodeType() {
        return NodeType.DOCUMENT;
    }

    @Override
    public final CoreNode getRootOrOwnerDocument() {
        return this;
    }

    @Override
    public final void coreSetOwnerDocument(CoreDocument document) {
        if (document != this) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public final CoreElement coreGetDocumentElement() throws CoreModelException {
        for (CoreChildNode child = this.coreGetFirstChild(); child != null; child = child.coreGetNextSibling()) {
            if (!(child instanceof CoreElement)) continue;
            return (CoreElement)child;
        }
        return null;
    }

    @Override
    public final String coreGetInputEncoding() {
        return this.inputEncoding;
    }

    @Override
    public final void coreSetInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    @Override
    public final String coreGetXmlVersion() {
        return this.xmlVersion;
    }

    @Override
    public final void coreSetXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    @Override
    public final String coreGetXmlEncoding() {
        return this.xmlEncoding;
    }

    @Override
    public final void coreSetXmlEncoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding;
    }

    @Override
    public final Boolean coreGetStandalone() {
        return this.standalone;
    }

    @Override
    public final void coreSetStandalone(Boolean standalone) {
        this.standalone = standalone;
    }

    @Override
    public final <T> void init(ClonePolicy<T> policy, T options, CoreNode other) {
        CoreDocument o = (CoreDocument)other;
        this.coreSetXmlVersion(o.coreGetXmlVersion());
        this.coreSetXmlEncoding(o.coreGetXmlEncoding());
        this.coreSetStandalone(o.coreGetStandalone());
        this.coreSetInputEncoding(o.coreGetInputEncoding());
    }

    @Override
    public final void serializeStartEvent(XmlHandler handler) throws CoreModelException, StreamException {
        handler.startDocument(this.coreGetInputEncoding(), this.coreGetXmlVersion(), this.coreGetXmlEncoding(), this.coreGetStandalone());
    }

    @Override
    public final void serializeEndEvent(XmlHandler handler) throws StreamException {
        handler.completed();
    }

    @Override
    final void internalCheckNewChild0(CoreChildNode newChild, CoreChildNode replacedChild) throws CoreModelException {
        if (newChild instanceof CoreElement && !(replacedChild instanceof CoreElement) && this.coreGetDocumentElement() != null) {
            throw new ChildNotAllowedException();
        }
    }
}

