/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.mixin;

import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.mime.PartDataHandler;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.common.AxiomExceptionTranslator;
import org.apache.axiom.om.impl.common.AxiomSemantics;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.intf.AxiomText;
import org.apache.axiom.om.impl.intf.TextContent;
import org.apache.axiom.weaver.annotation.Mixin;

@Mixin
public abstract class AxiomTextMixin
implements AxiomText {
    private TextContent getTextContent(boolean force) {
        try {
            Object content = this.coreGetCharacterData();
            if (content instanceof TextContent) {
                return (TextContent)content;
            }
            if (force) {
                TextContent textContent = new TextContent((String)content);
                this.coreSetCharacterData(textContent, AxiomSemantics.INSTANCE);
                return textContent;
            }
            return null;
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final boolean isBinary() {
        TextContent textContent = this.getTextContent(false);
        return textContent != null && textContent.isBinary();
    }

    @Override
    public final void setBinary(boolean binary) {
        TextContent textContent = this.getTextContent(binary);
        if (textContent != null) {
            textContent.setBinary(binary);
        }
    }

    @Override
    public final boolean isOptimized() {
        TextContent textContent = this.getTextContent(false);
        return textContent != null && textContent.isOptimize();
    }

    @Override
    public final void setOptimize(boolean optimize) {
        TextContent textContent = this.getTextContent(optimize);
        if (textContent != null) {
            textContent.setOptimize(optimize);
        }
    }

    @Override
    public final String getText() throws OMException {
        try {
            return this.coreGetCharacterData().toString();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final char[] getTextCharacters() {
        try {
            Object content = this.coreGetCharacterData();
            if (content instanceof TextContent) {
                return ((TextContent)content).toCharArray();
            }
            return ((String)content).toCharArray();
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final boolean isCharacters() {
        return false;
    }

    @Override
    public final QName getTextAsQName() throws OMException {
        return ((OMElement)this.getParent()).resolveQName(this.getText());
    }

    @Override
    public final OMNamespace getNamespace() {
        QName qname = this.getTextAsQName();
        if (qname == null) {
            return null;
        }
        String namespaceURI = qname.getNamespaceURI();
        return namespaceURI.length() == 0 ? null : new OMNamespaceImpl(namespaceURI, qname.getPrefix());
    }

    @Override
    public final DataHandler getDataHandler() {
        try {
            Object content = this.coreGetCharacterData();
            if (content instanceof TextContent) {
                return ((TextContent)content).getDataHandler();
            }
            throw new OMException("No DataHandler available");
        }
        catch (CoreModelException ex) {
            throw AxiomExceptionTranslator.translate(ex);
        }
    }

    @Override
    public final String getContentID() {
        return this.getTextContent(true).getContentID();
    }

    @Override
    public final void buildWithAttachments() {
        DataHandler dataHandler;
        if (this.isOptimized() && (dataHandler = this.getDataHandler()) instanceof PartDataHandler) {
            ((PartDataHandler)dataHandler).getPart().fetch();
        }
    }

    @Override
    public final void setContentID(String cid) {
        this.getTextContent(true).setContentID(cid);
    }
}

