/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.TypeError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AttrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSIDREF;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FnID
extends Function {
    private static Collection _expected_args = null;

    public FnID() {
        super(new QName("id"), 1, 2);
    }

    @Override
    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnID.id(args, this.dynamic_context());
    }

    public static ResultSequence id(Collection args, DynamicContext context) throws DynamicError {
        Collection cargs = Function.convert_arguments(args, FnID.expected_args());
        ResultSequence rs = ResultSequenceFactory.create_new();
        Iterator argIt = cargs.iterator();
        ResultSequence idrefRS = (ResultSequence)argIt.next();
        String[] idrefst = idrefRS.first().string_value().split(" ");
        ArrayList idrefs = FnID.createIDRefs(idrefst);
        ResultSequence nodeArg = null;
        NodeType nodeType = null;
        if (argIt.hasNext()) {
            nodeArg = (ResultSequence)argIt.next();
            nodeType = (NodeType)nodeArg.first();
        } else {
            if (context.context_item() == null) {
                throw DynamicError.contextUndefined();
            }
            if (!(context.context_item() instanceof NodeType)) {
                throw new DynamicError(TypeError.invalid_type(null));
            }
            nodeType = (NodeType)context.context_item();
            if (nodeType.node_value().getOwnerDocument() == null) {
                throw DynamicError.contextUndefined();
            }
        }
        Node node = nodeType.node_value();
        if (node.getOwnerDocument() == null) {
            throw DynamicError.contextUndefined();
        }
        if (FnID.hasIDREF(idrefs, node)) {
            ElementType element = new ElementType((Element)node);
            rs.add(element);
        }
        rs = FnID.processAttributes(node, idrefs, rs);
        rs = FnID.processChildNodes(node, idrefs, rs);
        return rs;
    }

    private static ArrayList createIDRefs(String[] idReftokens) {
        ArrayList<XSIDREF> xsidRef = new ArrayList<XSIDREF>();
        int i = 0;
        while (i < idReftokens.length) {
            XSIDREF idref = new XSIDREF(idReftokens[i]);
            xsidRef.add(idref);
            ++i;
        }
        return xsidRef;
    }

    private static ResultSequence processChildNodes(Node node, List idrefs, ResultSequence rs) {
        if (!node.hasChildNodes()) {
            return rs;
        }
        NodeList nodeList = node.getChildNodes();
        int nodecnt = 0;
        while (nodecnt < nodeList.getLength()) {
            Node childNode = nodeList.item(nodecnt);
            if (childNode.getNodeType() == 1 && !FnID.isDuplicate(childNode, rs)) {
                ElementType element = new ElementType((Element)childNode);
                if (element.isID() && FnID.hasIDREF(idrefs, childNode)) {
                    rs.add(element);
                }
                rs = FnID.processAttributes(childNode, idrefs, rs);
                rs = FnID.processChildNodes(childNode, idrefs, rs);
            }
            ++nodecnt;
        }
        return rs;
    }

    private static ResultSequence processAttributes(Node node, List idrefs, ResultSequence rs) {
        if (!node.hasAttributes()) {
            return rs;
        }
        NamedNodeMap attributeList = node.getAttributes();
        int atsub = 0;
        while (atsub < attributeList.getLength()) {
            Attr atNode = (Attr)attributeList.item(atsub);
            AttrType atType = new AttrType(atNode);
            if (((NodeType)atType).isID() && FnID.hasIDREF(idrefs, atNode) && !FnID.isDuplicate(node, rs)) {
                ElementType element = new ElementType((Element)node);
                rs.add(element);
            }
            ++atsub;
        }
        return rs;
    }

    private static boolean hasIDREF(List idrefs, Node node) {
        int i = 0;
        while (i < idrefs.size()) {
            XSIDREF idref = (XSIDREF)idrefs.get(i);
            if (idref.string_value().equals(node.getNodeValue())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isDuplicate(Node node, ResultSequence rs) {
        ListIterator it = rs.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(node)) continue;
            return true;
        }
        return false;
    }

    public static synchronized Collection expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList();
            SeqType arg = new SeqType(new XSString(), 1);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(0));
        }
        return _expected_args;
    }
}

