/* This file is auto-generated from ../src/rpc/virnetprotocol.x */

#include <rpc/rpc.h>
#include "internal.h"

#pragma once

#include "internal.h"

#include "virxdrdefs.h"

#include "virsocket.h"

#define VIR_NET_MESSAGE_INITIAL 65536

#define VIR_NET_MESSAGE_LEGACY_PAYLOAD_MAX 262120

#define VIR_NET_MESSAGE_MAX 33554432

#define VIR_NET_MESSAGE_HEADER_MAX 24

#define VIR_NET_MESSAGE_PAYLOAD_MAX 33554408

#define VIR_NET_MESSAGE_LEN_MAX 4

#define VIR_NET_MESSAGE_STRING_MAX 4194304

#define VIR_NET_MESSAGE_NUM_FDS_MAX 32

enum virNetMessageType {
    VIR_NET_CALL = 0,
    VIR_NET_REPLY = 1,
    VIR_NET_MESSAGE = 2,
    VIR_NET_STREAM = 3,
    VIR_NET_CALL_WITH_FDS = 4,
    VIR_NET_REPLY_WITH_FDS = 5,
    VIR_NET_STREAM_HOLE = 6,
};
typedef enum virNetMessageType virNetMessageType;

enum virNetMessageStatus {
    VIR_NET_OK = 0,
    VIR_NET_ERROR = 1,
    VIR_NET_CONTINUE = 2,
};
typedef enum virNetMessageStatus virNetMessageStatus;

#define VIR_NET_MESSAGE_HEADER_XDR_LEN 4

struct virNetMessageHeader {
    u_int prog;
    u_int vers;
    int proc;
    virNetMessageType type;
    u_int serial;
    virNetMessageStatus status;
};
typedef struct virNetMessageHeader virNetMessageHeader;
void xdr_virNetMessageHeader_clear(virNetMessageHeader *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(virNetMessageHeader, xdr_virNetMessageHeader_clear);

typedef char virNetMessageUUID[VIR_UUID_BUFLEN];
void xdr_virNetMessageUUID_clear(virNetMessageUUID *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(virNetMessageUUID, xdr_virNetMessageUUID_clear);

typedef char *virNetMessageNonnullString;
void xdr_virNetMessageNonnullString_clear(virNetMessageNonnullString *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(virNetMessageNonnullString, xdr_virNetMessageNonnullString_clear);

typedef virNetMessageNonnullString *virNetMessageString;
void xdr_virNetMessageString_clear(virNetMessageString *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(virNetMessageString, xdr_virNetMessageString_clear);

struct virNetMessageNonnullDomain {
    virNetMessageNonnullString name;
    virNetMessageUUID uuid;
    int id;
};
typedef struct virNetMessageNonnullDomain virNetMessageNonnullDomain;
void xdr_virNetMessageNonnullDomain_clear(virNetMessageNonnullDomain *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(virNetMessageNonnullDomain, xdr_virNetMessageNonnullDomain_clear);

struct virNetMessageNonnullNetwork {
    virNetMessageNonnullString name;
    virNetMessageUUID uuid;
};
typedef struct virNetMessageNonnullNetwork virNetMessageNonnullNetwork;
void xdr_virNetMessageNonnullNetwork_clear(virNetMessageNonnullNetwork *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(virNetMessageNonnullNetwork, xdr_virNetMessageNonnullNetwork_clear);

typedef virNetMessageNonnullDomain *virNetMessageDomain;
void xdr_virNetMessageDomain_clear(virNetMessageDomain *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(virNetMessageDomain, xdr_virNetMessageDomain_clear);

typedef virNetMessageNonnullNetwork *virNetMessageNetwork;
void xdr_virNetMessageNetwork_clear(virNetMessageNetwork *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(virNetMessageNetwork, xdr_virNetMessageNetwork_clear);

struct virNetMessageError {
    int code;
    int domain;
    virNetMessageString message;
    int level;
    virNetMessageDomain dom;
    virNetMessageString str1;
    virNetMessageString str2;
    virNetMessageString str3;
    int int1;
    int int2;
    virNetMessageNetwork net;
};
typedef struct virNetMessageError virNetMessageError;
void xdr_virNetMessageError_clear(virNetMessageError *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(virNetMessageError, xdr_virNetMessageError_clear);

struct virNetStreamHole {
    int64_t length;
    u_int flags;
};
typedef struct virNetStreamHole virNetStreamHole;
void xdr_virNetStreamHole_clear(virNetStreamHole *objp);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC(virNetStreamHole, xdr_virNetStreamHole_clear);

extern  bool_t xdr_virNetMessageType(XDR *, virNetMessageType*);

extern  bool_t xdr_virNetMessageStatus(XDR *, virNetMessageStatus*);

extern  bool_t xdr_virNetMessageHeader(XDR *, virNetMessageHeader*);

extern  bool_t xdr_virNetMessageUUID(XDR *, virNetMessageUUID);

extern  bool_t xdr_virNetMessageNonnullString(XDR *, virNetMessageNonnullString*);

extern  bool_t xdr_virNetMessageString(XDR *, virNetMessageString*);

extern  bool_t xdr_virNetMessageNonnullDomain(XDR *, virNetMessageNonnullDomain*);

extern  bool_t xdr_virNetMessageNonnullNetwork(XDR *, virNetMessageNonnullNetwork*);

extern  bool_t xdr_virNetMessageDomain(XDR *, virNetMessageDomain*);

extern  bool_t xdr_virNetMessageNetwork(XDR *, virNetMessageNetwork*);

extern  bool_t xdr_virNetMessageError(XDR *, virNetMessageError*);

extern  bool_t xdr_virNetStreamHole(XDR *, virNetStreamHole*);

