// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A10__F153

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x)xyzw" };
#else
{ R"xyzw(amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊fp16@16_224_T_F_0_1)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1200)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0x17497db8u, 0x51364360u, 302, 202 }, // 17497db851364360 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x__P__0_2_16_16_False__CO__wave1_warp4_stg1--Arch_gfx1200
    { 0x30305ea1u, 0x3fe307e3u, 302, 16 }, // 30305ea13fe307e3 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x__P__0_2_16_16_False__CO__wave2_warp2_stg1--Arch_gfx1200
    { 0xca32f03fu, 0x5d42b665u, 302, 116 }, // ca32f03f5d42b665 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x__P__0_2_16_16_False__CO__wave2_warp4_stg1--Arch_gfx1200
    { 0x0b6ee1d8u, 0x8f29c76bu, 302, 33 }, // 0b6ee1d88f29c76b = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x__P__0_2_16_16_False__CO__wave3_warp2_stg1--Arch_gfx1200
    { 0x43fb6ca9u, 0x0f5aa7bcu, 302, 167 }, // 43fb6ca90f5aa7bc = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x__P__0_2_16_16_False__CO__wave3_warp4_stg1--Arch_gfx1200
    { 0x1a8ca805u, 0xb350c488u, 302, 50 }, // 1a8ca805b350c488 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x__P__0_2_16_16_False__CO__wave4_warp2_stg1--Arch_gfx1200
    { 0x011b1465u, 0x9545c226u, 302, 133 }, // 011b14659545c226 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x__P__0_2_16_16_False__CO__wave4_warp4_stg1--Arch_gfx1200
    { 0x6519fe90u, 0xb5e8c005u, 0, 202 }, // 6519fe90b5e8c005 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x__P__0_2_32_16_False__CO__wave1_warp4_stg1--Arch_gfx1200
    { 0xe34f9eeeu, 0x47f400c6u, 0, 116 }, // e34f9eee47f400c6 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x__P__0_2_32_16_False__CO__wave2_warp4_stg1--Arch_gfx1200
    { 0x9dbd38f2u, 0xbf8c5440u, 0, 167 }, // 9dbd38f2bf8c5440 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x__P__0_2_32_16_False__CO__wave3_warp4_stg1--Arch_gfx1200
    { 0xc058382fu, 0x454e7053u, 318, 202 }, // c058382f454e7053 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x__P__0_2_32_32_False__CO__wave1_warp4_stg1--Arch_gfx1200
    { 0x79243d86u, 0x02c4f112u, 318, 116 }, // 79243d8602c4f112 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x__P__0_2_32_32_False__CO__wave2_warp4_stg1--Arch_gfx1200
    { 0x8df12659u, 0xa0e6e5e6u, 67, 116 }, // 8df12659a0e6e5e6 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x__P__0_2_64_32_False__CO__wave2_warp4_stg1--Arch_gfx1200
    { 0xc6c65699u, 0x7cc42422u, 67, 167 }, // c6c656997cc42422 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x__P__0_2_64_32_False__CO__wave3_warp4_stg1--Arch_gfx1200
    { 0x35c79133u, 0x5c9aadd3u, 67, 133 }, // 35c791335c9aadd3 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_224_T_F_0_1___gfx120x__P__0_2_64_32_False__CO__wave4_warp4_stg1--Arch_gfx1200
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1200_mod0
{{ 6, 2, 4, 6, 4, 0, 0, 2, 2, 6},
 { 0, 4, 0, 2, 9, 7, 7, 7, 7, 9},
 { 4, 4, 6, 0, 2, 6,12, 9, 9, 9},
 { 5, 6, 9, 9, 9, 8, 9, 7, 7, 0},
 { 9, 5, 5, 7, 8, 7, 9, 8, 2, 0},
 { 9, 9, 5, 8, 7, 8, 8, 0, 0, 0},
 { 8, 9, 8, 7, 8, 8, 8, 9, 7, 5},
 {11, 5, 3, 8, 7, 9, 7,13,12,14},
 { 8, 3, 1, 7, 7, 8, 8,10,13,13},
 { 9, 3, 5, 7, 7, 9, 8, 5,12,14}}
// End of GPU gfx1200_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A10__F153 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 7;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 7;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*fp16:16"
// B = "*fp16:16"
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 224
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = False
// dropout_p = 0
// philox_seed_ptr = 0
// philox_offset1 = 0
// philox_offset2 = 0
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 1
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx1201_mod0') AND inputs$Q_dtype = 'torch.float16' AND inputs$BLOCK_DMODEL = 224 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = False AND inputs$CAUSAL_TYPE = 0 AND inputs$BIAS_TYPE = 1

// vim: set fileencoding=utf-8

