; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=aarch64 -global-isel -stop-after=irtranslator -verify-machineinstrs \
; RUN:     -trap-unreachable=false -o - %s | FileCheck -check-prefix=NO_TRAP_UNREACHABLE %s
; RUN: llc -mtriple=aarch64 -global-isel -stop-after=irtranslator -verify-machineinstrs \
; RUN:     -trap-unreachable -no-trap-after-noreturn -o - %s | FileCheck -check-prefix=NO_TRAP_UNREACHABLE %s
; RUN: llc -mtriple=aarch64 -global-isel -stop-after=irtranslator -verify-machineinstrs \
; RUN:     -trap-unreachable -no-trap-after-noreturn=false -o - %s | FileCheck -check-prefix=TRAP_UNREACHABLE %s

;; Make sure we emit trap instructions after stack protector checks iff NoTrapAfterNoReturn is false.

define void @test() nounwind ssp {
  ; NO_TRAP_UNREACHABLE-LABEL: name: test
  ; NO_TRAP_UNREACHABLE: bb.1.entry:
  ; NO_TRAP_UNREACHABLE-NEXT:   successors: %bb.2(0x7ffff800), %bb.3(0x00000800)
  ; NO_TRAP_UNREACHABLE-NEXT: {{  $}}
  ; NO_TRAP_UNREACHABLE-NEXT:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %stack.0.StackGuardSlot
  ; NO_TRAP_UNREACHABLE-NEXT:   [[LOAD_STACK_GUARD:%[0-9]+]]:gpr64sp(p0) = LOAD_STACK_GUARD :: (dereferenceable invariant load (p0) from @__stack_chk_guard)
  ; NO_TRAP_UNREACHABLE-NEXT:   [[LOAD_STACK_GUARD1:%[0-9]+]]:gpr64sp(p0) = LOAD_STACK_GUARD :: (dereferenceable invariant load (p0) from @__stack_chk_guard)
  ; NO_TRAP_UNREACHABLE-NEXT:   G_STORE [[LOAD_STACK_GUARD1]](p0), [[FRAME_INDEX]](p0) :: (volatile store (p0) into %stack.0.StackGuardSlot)
  ; NO_TRAP_UNREACHABLE-NEXT:   [[FRAME_INDEX1:%[0-9]+]]:_(p0) = G_FRAME_INDEX %stack.1.buf
  ; NO_TRAP_UNREACHABLE-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $sp, implicit $sp
  ; NO_TRAP_UNREACHABLE-NEXT:   $x0 = COPY [[FRAME_INDEX1]](p0)
  ; NO_TRAP_UNREACHABLE-NEXT:   BL @callee, csr_aarch64_aapcs, implicit-def $lr, implicit $sp, implicit $x0, implicit-def $w0
  ; NO_TRAP_UNREACHABLE-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $sp, implicit $sp
  ; NO_TRAP_UNREACHABLE-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; NO_TRAP_UNREACHABLE-NEXT:   [[FRAME_INDEX2:%[0-9]+]]:_(p0) = G_FRAME_INDEX %stack.0.StackGuardSlot
  ; NO_TRAP_UNREACHABLE-NEXT:   [[LOAD:%[0-9]+]]:_(s64) = G_LOAD [[FRAME_INDEX2]](p0) :: (volatile load (s64) from %stack.0.StackGuardSlot)
  ; NO_TRAP_UNREACHABLE-NEXT:   [[LOAD_STACK_GUARD2:%[0-9]+]]:gpr64sp(s64) = LOAD_STACK_GUARD :: (dereferenceable invariant load (p0) from @__stack_chk_guard)
  ; NO_TRAP_UNREACHABLE-NEXT:   [[ICMP:%[0-9]+]]:_(s1) = G_ICMP intpred(ne), [[LOAD_STACK_GUARD2]](s64), [[LOAD]]
  ; NO_TRAP_UNREACHABLE-NEXT:   G_BRCOND [[ICMP]](s1), %bb.3
  ; NO_TRAP_UNREACHABLE-NEXT:   G_BR %bb.2
  ; NO_TRAP_UNREACHABLE-NEXT: {{  $}}
  ; NO_TRAP_UNREACHABLE-NEXT: bb.3.entry:
  ; NO_TRAP_UNREACHABLE-NEXT:   successors:
  ; NO_TRAP_UNREACHABLE-NEXT: {{  $}}
  ; NO_TRAP_UNREACHABLE-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $sp, implicit $sp
  ; NO_TRAP_UNREACHABLE-NEXT:   BL &__stack_chk_fail, csr_aarch64_aapcs, implicit-def $lr, implicit $sp
  ; NO_TRAP_UNREACHABLE-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $sp, implicit $sp
  ; NO_TRAP_UNREACHABLE-NEXT: {{  $}}
  ; NO_TRAP_UNREACHABLE-NEXT: bb.2.entry:
  ; NO_TRAP_UNREACHABLE-NEXT:   RET_ReallyLR
  ;
  ; TRAP_UNREACHABLE-LABEL: name: test
  ; TRAP_UNREACHABLE: bb.1.entry:
  ; TRAP_UNREACHABLE-NEXT:   successors: %bb.2(0x7ffff800), %bb.3(0x00000800)
  ; TRAP_UNREACHABLE-NEXT: {{  $}}
  ; TRAP_UNREACHABLE-NEXT:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %stack.0.StackGuardSlot
  ; TRAP_UNREACHABLE-NEXT:   [[LOAD_STACK_GUARD:%[0-9]+]]:gpr64sp(p0) = LOAD_STACK_GUARD :: (dereferenceable invariant load (p0) from @__stack_chk_guard)
  ; TRAP_UNREACHABLE-NEXT:   [[LOAD_STACK_GUARD1:%[0-9]+]]:gpr64sp(p0) = LOAD_STACK_GUARD :: (dereferenceable invariant load (p0) from @__stack_chk_guard)
  ; TRAP_UNREACHABLE-NEXT:   G_STORE [[LOAD_STACK_GUARD1]](p0), [[FRAME_INDEX]](p0) :: (volatile store (p0) into %stack.0.StackGuardSlot)
  ; TRAP_UNREACHABLE-NEXT:   [[FRAME_INDEX1:%[0-9]+]]:_(p0) = G_FRAME_INDEX %stack.1.buf
  ; TRAP_UNREACHABLE-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $sp, implicit $sp
  ; TRAP_UNREACHABLE-NEXT:   $x0 = COPY [[FRAME_INDEX1]](p0)
  ; TRAP_UNREACHABLE-NEXT:   BL @callee, csr_aarch64_aapcs, implicit-def $lr, implicit $sp, implicit $x0, implicit-def $w0
  ; TRAP_UNREACHABLE-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $sp, implicit $sp
  ; TRAP_UNREACHABLE-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $w0
  ; TRAP_UNREACHABLE-NEXT:   [[FRAME_INDEX2:%[0-9]+]]:_(p0) = G_FRAME_INDEX %stack.0.StackGuardSlot
  ; TRAP_UNREACHABLE-NEXT:   [[LOAD:%[0-9]+]]:_(s64) = G_LOAD [[FRAME_INDEX2]](p0) :: (volatile load (s64) from %stack.0.StackGuardSlot)
  ; TRAP_UNREACHABLE-NEXT:   [[LOAD_STACK_GUARD2:%[0-9]+]]:gpr64sp(s64) = LOAD_STACK_GUARD :: (dereferenceable invariant load (p0) from @__stack_chk_guard)
  ; TRAP_UNREACHABLE-NEXT:   [[ICMP:%[0-9]+]]:_(s1) = G_ICMP intpred(ne), [[LOAD_STACK_GUARD2]](s64), [[LOAD]]
  ; TRAP_UNREACHABLE-NEXT:   G_BRCOND [[ICMP]](s1), %bb.3
  ; TRAP_UNREACHABLE-NEXT:   G_BR %bb.2
  ; TRAP_UNREACHABLE-NEXT: {{  $}}
  ; TRAP_UNREACHABLE-NEXT: bb.3.entry:
  ; TRAP_UNREACHABLE-NEXT:   successors:
  ; TRAP_UNREACHABLE-NEXT: {{  $}}
  ; TRAP_UNREACHABLE-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $sp, implicit $sp
  ; TRAP_UNREACHABLE-NEXT:   BL &__stack_chk_fail, csr_aarch64_aapcs, implicit-def $lr, implicit $sp
  ; TRAP_UNREACHABLE-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $sp, implicit $sp
  ; TRAP_UNREACHABLE-NEXT:   G_TRAP
  ; TRAP_UNREACHABLE-NEXT: {{  $}}
  ; TRAP_UNREACHABLE-NEXT: bb.2.entry:
  ; TRAP_UNREACHABLE-NEXT:   RET_ReallyLR
entry:
  %buf = alloca [8 x i8]
  %result = call i32(ptr) @callee(ptr %buf) nounwind
  ret void
}

declare i32 @callee(ptr) nounwind
